import {
  ExpandableAttribute_default
} from "./chunk-SQS3CAW7.js";
import {
  ConfirmationButtons,
  EditButton
} from "./chunk-3VW6XNOP.js";

// src/EditableLongText.tsx
import { useCallback, useEffect, useState } from "react";
import { TextField } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { toggle } from "@northern.tech/utils/helpers";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  notes: { display: "block", whiteSpace: "pre-wrap" },
  // @ts-expect-error: type misalignment in styleOverride root type
  notesWrapper: { minWidth: theme.components?.MuiFormControl?.styleOverrides?.root?.minWidth }
}));
var EditableLongText = ({ contentFallback = "", fullWidth, original, onChange, placeholder = "-" }) => {
  const [isEditing, setIsEditing] = useState(false);
  const [value, setValue] = useState(original);
  const { classes } = useStyles();
  useEffect(() => {
    setValue(original);
  }, [original]);
  const onCancelClick = () => {
    setValue(original);
    setIsEditing(false);
  };
  const onEdit = ({ target: { value: value2 } }) => setValue(value2);
  const onEditClick = () => setIsEditing(true);
  const onToggleEditing = useCallback(
    (event) => {
      event.stopPropagation();
      if (event.key && (event.key !== "Enter" || event.shiftKey)) {
        return;
      }
      if (isEditing) {
        onChange(value);
      }
      setIsEditing(toggle);
    },
    [isEditing, onChange, value]
  );
  const fullWidthClass = fullWidth ? "full-width" : "";
  return /* @__PURE__ */ jsx("div", { className: "flexbox", style: { alignItems: "end" }, children: isEditing ? /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      TextField,
      {
        className: `margin-right ${fullWidthClass}`,
        multiline: true,
        onChange: onEdit,
        onKeyDown: onToggleEditing,
        placeholder,
        value
      }
    ),
    /* @__PURE__ */ jsx(ConfirmationButtons, { onCancel: onCancelClick, onConfirm: onToggleEditing })
  ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      ExpandableAttribute_default,
      {
        className: `${fullWidthClass} margin-right ${classes.notesWrapper}`,
        component: "div",
        dense: true,
        disableGutters: true,
        primary: "",
        secondary: original || value || contentFallback,
        textClasses: { secondary: classes.notes }
      }
    ),
    /* @__PURE__ */ jsx(EditButton, { onClick: onEditClick })
  ] }) });
};

export {
  EditableLongText
};
//# sourceMappingURL=chunk-5BJYD4DO.js.map