import {
  BaseDialog
} from "./chunk-G4SBL2PI.js";

// src/dialogs/ConfirmDismissHelpTips.tsx
import { Button, DialogActions, DialogContent } from "@mui/material";
import storeActions from "@northern.tech/store/actions";
import { useAppDispatch } from "@northern.tech/store/store";
import { setOnboardingCanceled } from "@northern.tech/store/thunks";
import { jsx, jsxs } from "react/jsx-runtime";
var { setShowDismissOnboardingTipsDialog } = storeActions;
var ConfirmDismissHelptips = () => {
  const dispatch = useAppDispatch();
  const onClose = () => dispatch(setOnboardingCanceled());
  return /* @__PURE__ */ jsxs(BaseDialog, { open: true, title: "Dismiss the Getting Started help?", onClose, children: [
    /* @__PURE__ */ jsx(DialogContent, { children: "Hide the help tips? You haven't finished your first update yet." }),
    /* @__PURE__ */ jsxs(DialogActions, { className: "flexbox space-between", children: [
      /* @__PURE__ */ jsx(Button, { onClick: () => dispatch(setShowDismissOnboardingTipsDialog(false)), children: "Cancel" }),
      /* @__PURE__ */ jsx(Button, { variant: "contained", color: "secondary", onClick: onClose, children: "Yes, hide the help" })
    ] })
  ] });
};
var ConfirmDismissHelpTips_default = ConfirmDismissHelptips;

export {
  ConfirmDismissHelptips,
  ConfirmDismissHelpTips_default
};
//# sourceMappingURL=chunk-MSNHAE4Q.js.map