// src/Time.tsx
import { useEffect, useState } from "react";
import { Tooltip } from "@mui/material";
import dayjs from "dayjs";
import relativeTime from "dayjs/plugin/relativeTime.js";
import pluralize from "pluralize";
import { jsx } from "react/jsx-runtime";
var defaultDateFormat = "YYYY-MM-DD";
var defaultTimeFormat = `${defaultDateFormat} HH:mm`;
dayjs.extend(relativeTime);
var Time = ({ value, relative, format = defaultTimeFormat, valueFormat, titleFormat = defaultTimeFormat, Component = "time", ...remainingProps }) => {
  if (!value) {
    value = dayjs();
  }
  value = dayjs(value, valueFormat, true);
  const machineReadable = value.format("YYYY-MM-DDTHH:mm:ssZ");
  const humanReadable = relative ? value.fromNow() : value.format(format);
  return /* @__PURE__ */ jsx(Component, { title: relative ? value.format(titleFormat) : null, ...remainingProps, dateTime: machineReadable, children: humanReadable });
};
var MaybeTime = ({ className = "", value, ...remainingProps }) => value ? /* @__PURE__ */ jsx(Time, { value, ...remainingProps }) : /* @__PURE__ */ jsx("div", { className, children: "-" });
var cutoff = -5 * 60;
var RelativeTime = ({ className, shouldCount = "both", updateTime }) => {
  const [updatedTime, setUpdatedTime] = useState();
  useEffect(() => {
    setUpdatedTime((updatedTime2) => updateTime !== updatedTime2 ? dayjs(updateTime) : updatedTime2);
  }, [updateTime]);
  let timeDisplay = /* @__PURE__ */ jsx(MaybeTime, { className, value: updatedTime });
  const diffSeconds = updatedTime ? updatedTime.diff(dayjs(), "seconds") : 0;
  if (updatedTime && diffSeconds > cutoff && (shouldCount === "both" || shouldCount === "up" && diffSeconds > 0 || shouldCount === "down" && diffSeconds < 0)) {
    timeDisplay = /* @__PURE__ */ jsx("time", { className, dateTime: updatedTime, children: updatedTime.fromNow() });
  }
  return /* @__PURE__ */ jsx(Tooltip, { title: updatedTime ? updatedTime.toDate().toString().slice(0, 33) : "", arrow: true, enterDelay: 500, children: /* @__PURE__ */ jsx("span", { children: timeDisplay }) });
};
var cutoffDays = 14;
var ApproximateRelativeDate = ({ className, updateTime }) => {
  const [updatedTime, setUpdatedTime] = useState();
  useEffect(() => {
    setUpdatedTime((updatedTime2) => updateTime !== updatedTime2 ? dayjs(updateTime) : updatedTime2);
  }, [updateTime]);
  const diff = updatedTime ? Math.abs(updatedTime.diff(dayjs(), "days")) : 0;
  if (updatedTime && diff <= cutoffDays) {
    return /* @__PURE__ */ jsx("time", { className, dateTime: updatedTime.format(defaultDateFormat), children: diff !== 0 ? `${diff} ${pluralize("day", diff)} ago` : "today" });
  }
  return /* @__PURE__ */ jsx(MaybeTime, { className, value: updatedTime, format: defaultDateFormat, titleFormat: defaultDateFormat });
};
var Time_default = Time;

export {
  Time,
  MaybeTime,
  RelativeTime,
  ApproximateRelativeDate,
  Time_default
};
//# sourceMappingURL=chunk-W2WUSAVK.js.map