import {
  __export,
  __reExport
} from "../chunk-424PT5DM.js";

// src/forms/helpers.tsx
import { FormProvider, useForm } from "react-hook-form";

// testUtils.ts
var testUtils_exports = {};
__export(testUtils_exports, {
  defaultState: () => defaultState,
  render: () => customRender
});
__reExport(testUtils_exports, setupTests_star);
import { mockState as appMockState } from "@northern.tech/store/appSlice/mocks";
import { mockState as deploymentsMockState } from "@northern.tech/store/deploymentsSlice/mocks";
import { mockState as devicesMockState } from "@northern.tech/store/devicesSlice/mocks";
import { mockState as monitorMockState } from "@northern.tech/store/monitorSlice/mocks";
import { mockState as onboardingMockState } from "@northern.tech/store/onboardingSlice/mocks";
import { mockState as organizationMockState } from "@northern.tech/store/organizationSlice/mocks";
import { mockState as releasesMockState } from "@northern.tech/store/releasesSlice/mocks";
import { getConfiguredStore } from "@northern.tech/store/store";
import { mockState as usersMockState } from "@northern.tech/store/usersSlice/mocks";
import { token as mockToken } from "@northern.tech/testing/mockData";
import { render } from "@northern.tech/testing/setupTests";
import * as setupTests_star from "@northern.tech/testing/setupTests";
var defaultState = {
  app: { ...appMockState },
  deployments: { ...deploymentsMockState },
  devices: { ...devicesMockState },
  monitor: { ...monitorMockState },
  onboarding: { ...onboardingMockState },
  organization: { ...organizationMockState },
  releases: { ...releasesMockState },
  users: { ...usersMockState }
};
var customRender = (ui, options = {}) => {
  const {
    preloadedState = { ...defaultState, users: { ...defaultState.users, currentSession: { token: mockToken, expiresAt: void 0 } } },
    store = getConfiguredStore({ preloadedState }),
    ...remainder
  } = options;
  return { store, ...render(ui, { preloadedState, store, ...remainder }) };
};

// src/forms/helpers.tsx
import { jsx } from "react/jsx-runtime";
var formRenderWrapper = (ui) => {
  const Wrapper = ({ children }) => {
    const methods = useForm();
    return /* @__PURE__ */ jsx(FormProvider, { ...methods, children });
  };
  return customRender(/* @__PURE__ */ jsx(Wrapper, { children: ui }));
};
export {
  formRenderWrapper
};
//# sourceMappingURL=helpers.js.map