// src/auditlogs/EventDetailsDrawer.tsx
import { Divider, Drawer } from "@mui/material";
import { useTheme } from "@mui/material/styles";
import { DrawerTitle } from "@northern.tech/common-ui/DrawerTitle";
import { jsx, jsxs } from "react/jsx-runtime";
var EventDetailsDrawer = ({ eventItem = {}, onClose, open, mapChangeToContent, fallbackComponent }) => {
  const theme = useTheme();
  const { title, content: Component } = mapChangeToContent(eventItem, fallbackComponent);
  return /* @__PURE__ */ jsxs(Drawer, { className: `${open ? "fadeIn" : "fadeOut"}`, anchor: "right", open, onClose, children: [
    /* @__PURE__ */ jsx(DrawerTitle, { title: /* @__PURE__ */ jsx("div", { className: "capitalized-start", children: title }), onClose }),
    /* @__PURE__ */ jsx(Divider, {}),
    /* @__PURE__ */ jsx(Component, { item: eventItem, onClose }),
    /* @__PURE__ */ jsx(Divider, { light: true, style: { marginTop: theme.spacing(2) } })
  ] });
};
var EventDetailsDrawer_default = EventDetailsDrawer;

export {
  EventDetailsDrawer,
  EventDetailsDrawer_default
};
//# sourceMappingURL=chunk-27FPFGHG.js.map