// src/auditlogs/AuditlogsView.tsx
import { Button } from "@mui/material";
import { InfoHintContainer } from "@northern.tech/common-ui/InfoHint";
import Loader from "@northern.tech/common-ui/Loader";
import { jsx, jsxs } from "react/jsx-runtime";
var AuditlogsView = ({ total, csvLoading, createCsvDownload, infoHintComponent = null, auditLogsFilter, children }) => /* @__PURE__ */ jsxs("div", { className: "fadeIn margin-left flexbox column", style: { marginRight: "5%" }, children: [
  /* @__PURE__ */ jsxs("div", { className: "flexbox center-aligned", children: [
    /* @__PURE__ */ jsx("h3", { className: "margin-right-small", children: "Audit log" }),
    /* @__PURE__ */ jsx(InfoHintContainer, { children: infoHintComponent })
  ] }),
  auditLogsFilter,
  /* @__PURE__ */ jsxs("div", { className: "flexbox center-aligned", style: { justifyContent: "flex-end" }, children: [
    /* @__PURE__ */ jsx(Loader, { show: csvLoading }),
    /* @__PURE__ */ jsx(Button, { variant: "contained", color: "secondary", disabled: csvLoading || !total, onClick: createCsvDownload, style: { marginLeft: 15 }, children: "Download results as csv" })
  ] }),
  children
] });
var AuditlogsView_default = AuditlogsView;

export {
  AuditlogsView,
  AuditlogsView_default
};
//# sourceMappingURL=chunk-OOY4IOLD.js.map