import {
  DEPLOYMENT_STATES
} from "./chunk-7C4SQBEE.js";

// src/deploymentsSlice/selectors.ts
import { createSelector } from "@reduxjs/toolkit";
var getDeploymentsById = (state) => state.deployments.byId;
var getDeploymentsByStatus = (state) => state.deployments.byStatus;
var getSelectedDeploymentDeviceIds = (state) => state.deployments.selectedDeviceIds;
var getDeploymentsSelectionState = (state) => state.deployments.selectionState;
var getMappedDeploymentSelection = createSelector(
  [getDeploymentsSelectionState, (_, deploymentsState) => deploymentsState, getDeploymentsById],
  (selectionState, deploymentsState, deploymentsById) => {
    const { selection = [] } = selectionState[deploymentsState] ?? {};
    return selection.reduce((accu, id) => {
      if (deploymentsById[id]) {
        accu.push(deploymentsById[id]);
      }
      return accu;
    }, []);
  }
);
var relevantDeploymentStates = [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.finished];
var DEPLOYMENT_CUTOFF = 3;
var getRecentDeployments = createSelector(
  [getDeploymentsById, getDeploymentsByStatus],
  (deploymentsById, deploymentsByStatus) => Object.entries(deploymentsByStatus).reduce(
    (accu, [state, byStatus]) => {
      if (!relevantDeploymentStates.includes(state) || !byStatus.deploymentIds.length) {
        return accu;
      }
      accu[state] = byStatus.deploymentIds.reduce((accu2, id) => {
        if (deploymentsById[id]) {
          accu2.push(deploymentsById[id]);
        }
        return accu2;
      }, []).slice(0, DEPLOYMENT_CUTOFF);
      accu.total += byStatus.total;
      return accu;
    },
    { total: 0 }
  )
);

export {
  getDeploymentsById,
  getDeploymentsByStatus,
  getSelectedDeploymentDeviceIds,
  getDeploymentsSelectionState,
  getMappedDeploymentSelection,
  DEPLOYMENT_CUTOFF,
  getRecentDeployments
};
//# sourceMappingURL=chunk-JXQUFKID.js.map