import { DeviceAttributeProjection } from './DeviceAttributeProjection.cjs';
import { DeviceFilterTerm } from './DeviceFilterTerm.cjs';
import { DeviceSortTerm } from './DeviceSortTerm.cjs';
import { GeoBoundingBoxFilter } from './GeoBoundingBoxFilter.cjs';
import { GeoDistanceFilter } from './GeoDistanceFilter.cjs';
import './GeoDistance.cjs';
import './GeoPoint.cjs';

type DeviceSearchTerms = {
    /**
     * Pagination parameter for iterating search results.
     */
    page?: number;
    /**
     * Number of devices returned per page.
     */
    per_page?: number;
    /**
     * Filtering terms.
     */
    filters?: Array<DeviceFilterTerm>;
    geo_distance_filter?: GeoDistanceFilter;
    geo_bounding_box_filter?: GeoBoundingBoxFilter;
    /**
     * Attribute keys to sort by.
     */
    sort?: Array<DeviceSortTerm>;
    /**
     * Restrict the attribute result to the selected attributes.
     */
    attributes?: Array<DeviceAttributeProjection>;
    /**
     * Restrict the result to the given device IDs.
     */
    device_ids?: Array<string>;
};

export type { DeviceSearchTerms };
