import { FilterPredicate } from './FilterPredicate.cjs';

/**
 * Filter definition
 */
type FilterDefinition = {
    /**
     * Name of the filter, must be unique.
     */
    name?: string;
    /**
     * List of filter predicates, chained with boolean AND operators to build the search condition definition.
     */
    terms?: Array<FilterPredicate>;
};

export type { FilterDefinition };
