import * as react_jsx_runtime from 'react/jsx-runtime';
import { ReactNode, CSSProperties, Ref } from 'react';

interface SortParams {
    direction?: 'asc' | 'desc';
    key?: string;
}
interface ColumnDefinition {
    defaultSortDirection?: 'asc' | 'desc';
    extras?: any;
    key: string;
    render: (item: any, extras: any) => ReactNode;
    renderTitle?: (extras: any) => ReactNode;
    sortable?: boolean;
    title: string;
}
interface DetailsTableProps {
    className?: string;
    columns: ColumnDefinition[];
    items: any[];
    onChangeSorting: (sortKey: string) => void;
    onItemClick?: (item: any) => void;
    onRowSelected?: (rowNumber: number[]) => void;
    selectedRows?: number[];
    sort?: SortParams;
    style?: CSSProperties;
    tableRef: Ref<HTMLTableElement>;
}
declare const DetailsTable: ({ className, columns, items, onChangeSorting, onItemClick, sort, style, tableRef, onRowSelected, selectedRows }: DetailsTableProps) => react_jsx_runtime.JSX.Element;

export { DetailsTable, DetailsTable as default };
