// src/dialogs/Feedback.tsx
import { useEffect, useRef, useState } from "react";
import { useDispatch } from "react-redux";
import {
  Close as CloseIcon,
  SentimentVeryDissatisfied as DissatisfiedIcon,
  SentimentNeutral as NeutralIcon,
  SentimentSatisfiedAlt as SatisfiedIcon,
  SentimentVeryDissatisfiedOutlined as VeryDissatisfiedIcon,
  SentimentVerySatisfiedOutlined as VerySatisfiedIcon
} from "@mui/icons-material";
import {
  Button,
  Dialog,
  DialogContent,
  DialogTitle,
  IconButton,
  TextField,
  darken,
  dialogClasses,
  dialogTitleClasses,
  iconButtonClasses,
  lighten,
  textFieldClasses
} from "@mui/material";
import { makeStyles } from "tss-react/mui";
import actions from "@northern.tech/store/actions";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { submitFeedback } from "@northern.tech/store/thunks";
import { isDarkMode } from "@northern.tech/store/utils";
import { jsx, jsxs } from "react/jsx-runtime";
var { setShowFeedbackDialog } = actions;
var useStyles = makeStyles()((theme) => ({
  root: {
    pointerEvents: "none",
    [`.${dialogClasses.paper}`]: { width: 350, bottom: 0, right: 0, position: "absolute" },
    [`.${dialogTitleClasses.root}`]: {
      alignSelf: "flex-end",
      padding: 0,
      [`.${iconButtonClasses.root}`]: { marginBottom: theme.spacing(-1) }
    },
    ".title": {
      color: isDarkMode(theme.palette.mode) ? lighten(theme.palette.primary.main, 0.85) : "inherit"
    }
  },
  columns: { gap: theme.spacing(2) },
  rating: {
    [`.${iconButtonClasses.root}`]: {
      borderRadius: theme.shape.borderRadius,
      height: theme.spacing(6),
      width: theme.spacing(6),
      backgroundColor: isDarkMode(theme.palette.mode) ? darken(theme.palette.primary.main, 0.45) : lighten(theme.palette.primary.main, 0.85),
      color: theme.palette.primary.main,
      "&:hover": {
        backgroundColor: theme.palette.primary.main,
        color: lighten(theme.palette.primary.main, 0.85)
      }
    }
  },
  text: { [`.${textFieldClasses.root}`]: { marginTop: 0 }, ".submitButton": { alignSelf: "start" } }
}));
var satisfactionLevels = [
  { Icon: VeryDissatisfiedIcon, title: "Very Dissatisfied" },
  { Icon: DissatisfiedIcon, title: "Dissatisfied" },
  { Icon: NeutralIcon, title: "Neutral" },
  { Icon: SatisfiedIcon, title: "Satisfied" },
  { Icon: VerySatisfiedIcon, title: "Very Satisfied" }
];
var explanations = ["Very unsatisfied", "Very satisfied"];
var SatisfactionGauge = ({ classes, setSatisfaction }) => /* @__PURE__ */ jsxs("div", { className: `flexbox column ${classes.columns}`, children: [
  /* @__PURE__ */ jsx("div", { className: "title", children: "How satisfied are you with Mender?" }),
  /* @__PURE__ */ jsx("div", { className: `flexbox space-between ${classes.rating}`, children: satisfactionLevels.map(({ Icon, title }, index) => /* @__PURE__ */ jsx(IconButton, { onClick: () => setSatisfaction(index), title, children: /* @__PURE__ */ jsx(Icon, { fontSize: "large" }) }, `satisfaction-${index}`)) }),
  /* @__PURE__ */ jsx("div", { className: "flexbox space-between muted", children: explanations.map((explanation, index) => /* @__PURE__ */ jsx("div", { className: "slightly-smaller", children: explanation }, `explanation-${index}`)) })
] });
var TextEntry = ({ classes, feedback, onChangeFeedback, onSubmit }) => /* @__PURE__ */ jsxs("div", { className: `flexbox column ${classes.columns} ${classes.text}`, children: [
  /* @__PURE__ */ jsx("div", { className: "title", children: "What do you think is the most important thing to improve in Mender? (optional)" }),
  /* @__PURE__ */ jsx(
    TextField,
    {
      placeholder: "Your feedback",
      multiline: true,
      minRows: 4,
      onChange: ({ target: { value } }) => onChangeFeedback(value),
      value: feedback,
      variant: "outlined"
    }
  ),
  /* @__PURE__ */ jsx(Button, { className: "submitButton", variant: "contained", onClick: onSubmit, children: "Submit Feedback" })
] });
var AppreciationNote = () => /* @__PURE__ */ jsx("p", { className: "margin-top-none align-center title", children: "Thank you for taking the time to share your thoughts!" });
var progressionLevels = [SatisfactionGauge, TextEntry, AppreciationNote];
var FeedbackDialog = () => {
  const [progress, setProgress] = useState(0);
  const [satisfaction, setSatisfaction] = useState(-1);
  const [feedback, setFeedback] = useState("");
  const dispatch = useDispatch();
  const isInitialized = useRef(false);
  const { classes } = useStyles();
  useEffect(() => {
    if (!isInitialized.current) {
      return;
    }
    setProgress((current) => current + 1);
  }, [satisfaction]);
  useEffect(() => {
    setTimeout(() => isInitialized.current = true, TIMEOUTS.oneSecond);
  }, []);
  const onCloseClick = () => dispatch(setShowFeedbackDialog(false));
  const onSubmit = () => {
    setProgress(progress + 1);
    dispatch(submitFeedback({ satisfaction: satisfactionLevels[satisfaction].title, feedback }));
  };
  const Component = progressionLevels[progress];
  return /* @__PURE__ */ jsxs(Dialog, { className: classes.root, open: true, hideBackdrop: true, disableEnforceFocus: true, PaperProps: { style: { pointerEvents: "auto" } }, children: [
    /* @__PURE__ */ jsx(DialogTitle, { children: /* @__PURE__ */ jsx(IconButton, { onClick: onCloseClick, "aria-label": "close", size: "small", children: /* @__PURE__ */ jsx(CloseIcon, {}) }) }),
    /* @__PURE__ */ jsx(DialogContent, { children: /* @__PURE__ */ jsx(Component, { classes, feedback, setSatisfaction, onChangeFeedback: setFeedback, onSubmit }) })
  ] });
};
var Feedback_default = FeedbackDialog;

export {
  FeedbackDialog,
  Feedback_default
};
//# sourceMappingURL=chunk-A34YTVID.js.map