// src/LinedHeader.tsx
import { makeStyles } from "tss-react/mui";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  border: {
    borderBottom: `1px solid ${theme.palette.grey[50]}`,
    span: {
      background: theme.palette.background.default
    }
  },
  groupBorder: {
    background: theme.palette.grey[50]
  },
  groupHeading: {
    background: theme.palette.background.default
  }
}));
var LinedHeader = ({ className = "", heading, innerStyle = {}, innerRef, style = {} }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ jsx("h4", { className: `dashboard-header ${classes.border} ${className}`, ref: innerRef, style, children: /* @__PURE__ */ jsx("span", { style: innerStyle, children: heading }) });
};
var LinedGroupHeader = ({ heading }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("span", { className: classes.groupHeading, children: heading }),
    /* @__PURE__ */ jsx("div", { className: classes.groupBorder })
  ] });
};
var LinedHeader_default = LinedHeader;

export {
  LinedGroupHeader,
  LinedHeader_default
};
//# sourceMappingURL=chunk-JY6EG3GA.js.map