import "../chunk-424PT5DM.js";

// src/forms/AddonSelect.tsx
import { useState } from "react";
import { Checkbox, FormControl, FormHelperText, InputLabel, MenuItem, Select } from "@mui/material";
import { ADDONS } from "@northern.tech/store/constants";
import { jsx, jsxs } from "react/jsx-runtime";
var AddonSelect = (props) => {
  const { onChange, initialState } = props;
  const [selectedAddons, setSelectedAddons] = useState(initialState);
  const onSelectedChange = ({ target: { value } }) => {
    setSelectedAddons(value);
    onChange(value);
  };
  return /* @__PURE__ */ jsxs(FormControl, { id: "addons-form", style: { maxWidth: 330 }, children: [
    /* @__PURE__ */ jsx(InputLabel, { id: "addons-selection-label", children: "Select Addons" }),
    /* @__PURE__ */ jsx(
      Select,
      {
        multiple: true,
        label: "Select Addons",
        labelId: "addons-selection-label",
        value: selectedAddons,
        onChange: onSelectedChange,
        renderValue: (selected) => selected.map((role) => "Mender " + ADDONS[role].title).join(", "),
        children: Object.values(ADDONS).map((addon) => /* @__PURE__ */ jsxs(MenuItem, { id: addon.id, value: addon.id, children: [
          /* @__PURE__ */ jsx(Checkbox, { id: `${addon.id}-checkbox`, checked: selectedAddons.includes(addon.id) }),
          "Mender ",
          addon.title
        ] }, addon.id))
      }
    ),
    /* @__PURE__ */ jsx(FormHelperText, { className: "info", children: "Select any add-ons you are interested in adding to your plan." })
  ] });
};
export {
  AddonSelect
};
//# sourceMappingURL=AddonSelect.js.map