"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/index.ts
var forms_exports = {};
__export(forms_exports, {
  ClickFilter: () => ClickFilter,
  ControlledAutoComplete: () => ControlledAutoComplete,
  FileUpload: () => FileUpload,
  Filters: () => Filters,
  Form: () => Form,
  FormCheckbox: () => FormCheckbox,
  KeyValueEditor: () => KeyValueEditor,
  PasswordInput: () => PasswordInput,
  TextInput: () => TextInput,
  TimeframePicker: () => TimeframePicker,
  runValidations: () => runValidations
});
module.exports = __toCommonJS(forms_exports);

// src/forms/Autocomplete.tsx
var import_react_hook_form = require("react-hook-form");
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var ControlledAutoComplete = ({ freeSolo, name, onChange, onInputChange, ...remainder }) => {
  const { control } = (0, import_react_hook_form.useFormContext)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_react_hook_form.Controller,
    {
      control,
      name,
      render: ({ field: { onChange: formOnChange, ...props } }) => {
        const onChangeHandler = (e, data) => formOnChange(data);
        return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Autocomplete, { ...freeSolo ? { freeSolo, onInputChange: onChangeHandler } : { onChange: onChangeHandler }, ...props, ...remainder });
      }
    }
  );
};

// src/forms/ClickFilter.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var ClickFilter = ({ disabled = false, children }) => disabled ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { style: { pointerEvents: "none" }, children }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_jsx_runtime2.Fragment, { children });

// src/forms/FileUpload.tsx
var import_react = require("react");
var import_react_dropzone = __toESM(require("react-dropzone"), 1);
var import_react_redux = require("react-redux");
var import_icons_material = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_actions = __toESM(require("@northern.tech/store/actions"), 1);
var import_jsx_runtime3 = require("react/jsx-runtime");
var { setSnackbar } = import_actions.default;
var FileUpload = ({ enableContentReading = true, fileNameSelection, onFileChange, onFileSelect = () => void 0, placeholder, style = {} }) => {
  const [filename, setFilename] = (0, import_react.useState)(fileNameSelection);
  const dispatch = (0, import_react_redux.useDispatch)();
  const onDrop = (acceptedFiles, rejectedFiles) => {
    if (acceptedFiles.length) {
      if (enableContentReading) {
        const reader = new FileReader();
        reader.readAsBinaryString(acceptedFiles[0]);
        reader.fileName = acceptedFiles[0].name;
        reader.onload = () => {
          const str = reader.result.replace(/\n|\r/g, "\n");
          onFileChange(str);
        };
        reader.onerror = (error) => {
          console.log("Error: ", error);
          setFilename();
        };
      }
      setFilename(acceptedFiles[0].name);
      onFileSelect(acceptedFiles[0]);
    }
    if (rejectedFiles.length) {
      dispatch(setSnackbar(`File '${rejectedFiles[0].name}' was rejected.`));
    }
  };
  const onClear = () => {
    onFileChange();
    onFileSelect();
    setFilename();
  };
  return filename ? /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { style, children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.TextField, { id: "keyfile", value: filename, disabled: true, style: { color: "rgba(0, 0, 0, 0.8)", borderBottom: "1px solid rgb(224, 224, 224)" } }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.IconButton, { style: { top: "6px" }, onClick: onClear, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_icons_material.Clear, {}) })
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { style, children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_react_dropzone.default, { activeClassName: "active", rejectClassName: "active", multiple: false, onDrop, children: ({ getRootProps, getInputProps }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { ...getRootProps(), style: { padding: 15 }, className: "dropzone onboard dashboard-placeholder flexbox centered", children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("input", { ...getInputProps() }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_icons_material.CloudUploadOutlined, { className: "icon", style: { height: 24, width: 24, verticalAlign: "middle", marginTop: "-2px" } }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "margin-left-small", style: { fontSize: "11pt" }, children: placeholder })
  ] }) }) });
};

// src/forms/Filters.tsx
var import_react2 = require("react");
var import_react_hook_form2 = require("react-hook-form");
var import_mui = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_debouncehook = require("@northern.tech/utils/debouncehook");
var import_jsx_runtime4 = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  filters: {
    backgroundColor: theme.palette.background.lightgrey,
    columnGap: theme.spacing(2),
    display: "flex",
    flexWrap: "wrap",
    padding: `10px ${theme.spacing(3)} ${theme.spacing(3)}`,
    rowGap: theme.spacing(2),
    ".filter-item": {
      display: "grid"
    },
    ".filter-item > div": {
      alignSelf: "end"
    }
  },
  filterReset: { right: theme.spacing(3) }
}));
var Filters = ({ className = "", defaultValues, filters = [], initialValues, onChange, fieldResetTrigger = "", dirtyField, clearDirty }) => {
  const { classes } = useStyles();
  const [values, setValues] = (0, import_react2.useState)(initialValues);
  const methods = (0, import_react_hook_form2.useForm)({ mode: "onChange", defaultValues });
  const { formState, reset, resetField, watch, setValue, getValues } = methods;
  const { isDirty } = formState;
  (0, import_react2.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  (0, import_react2.useEffect)(() => {
    if (dirtyField && !formState.isDirty) {
      setValue(dirtyField, getValues(dirtyField), { shouldDirty: true });
      clearDirty("");
    }
  }, [clearDirty, dirtyField, formState, getValues, setValue]);
  (0, import_react2.useEffect)(() => {
    if (!fieldResetTrigger) {
      return;
    }
    resetField(fieldResetTrigger);
  }, [fieldResetTrigger, resetField]);
  watch(setValues);
  const debouncedValues = (0, import_debouncehook.useDebounce)(values, import_constants.TIMEOUTS.oneSecond);
  (0, import_react2.useEffect)(() => {
    onChange(debouncedValues);
  }, [JSON.stringify(debouncedValues), onChange]);
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react_hook_form2.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("form", { className: `margin-bottom relative margin-top ${classes.filters} ${className}`, noValidate: true, children: [
    filters.map(({ key, title, Component, componentProps }) => /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: "filter-item", children: [
      /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("h5", { className: "margin-top-small margin-bottom-small muted", children: title }),
      /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(Component, { name: key, ...componentProps })
    ] }, key)),
    isDirty && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("span", { className: `link absolute ${classes.filterReset}`, onClick: () => reset(), children: "Clear filter" })
  ] }) });
};

// src/forms/Form.tsx
var import_react3 = require("react");
var import_react_hook_form3 = require("react-hook-form");
var import_material3 = require("@mui/material");
var import_mui2 = require("tss-react/mui");
var import_validator = __toESM(require("validator"), 1);
var import_jsx_runtime5 = require("react/jsx-runtime");
var validationMethods = {
  isAlpha: "This field must contain only letters",
  isAlphanumeric: "This field must contain only letters or numbers",
  isEmail: "Please enter a valid email address",
  isHexadecimal: "The secret has to be entered as a hexadecimal string",
  isNumeric: "Please enter a valid code",
  isURL: "Please enter a valid URL",
  isUUID: "Please enter a valid ID"
};
var getErrorMsg = (validateMethod, args) => {
  if (validationMethods[validateMethod]) {
    return validationMethods[validateMethod];
  }
  switch (validateMethod) {
    case "isLength":
      if (Number(args[0]) === 1) {
        return "This field is required";
      } else if (args[0] > 1) {
        return `Must be at least ${args[0]} characters long`;
      }
      break;
    case "isAlphanumericLocator":
      if (args[0] && import_validator.default.matches(args[0], /^[a-zA-Z0-9_-]+$/)) {
        return "";
      } else {
        return "This please only enter valid characters. Valid characters are a-z, A-Z, 0-9, _ and -";
      }
    case "isNot":
      if (args[0] === args[1]) {
        return `This field should have a value other than ${args[0]}`;
      }
      break;
    default:
      return "There is an error with this field";
  }
};
var tryApplyValidationEntry = (value, validations = [], validationResults = []) => {
  const validation = validations.shift();
  if (!validation) {
    return validationResults.pop();
  }
  let args = validation.split(":");
  const validateMethod = args.shift();
  const tmpArgs = args;
  args = [value].concat(args);
  try {
    if (!import_validator.default[validateMethod](...args)) {
      return tryApplyValidationEntry(value, validations, [...validationResults, { errortext: getErrorMsg(validateMethod, tmpArgs), isValid: false }]);
    }
  } catch {
    const errortext = getErrorMsg(validateMethod, args) || "";
    return tryApplyValidationEntry(value, validations, [...validationResults, { errortext, isValid: !errortext }]);
  }
  return { errortext: "", isValid: true };
};
var tryApplyValidations = (value, validations, initialValidationResult) => validations.split(",").reduce((accu, validation) => {
  if (!accu.isValid || !validation) {
    return accu;
  }
  const alternatives = validation.split("||");
  return tryApplyValidationEntry(value, alternatives, [accu]);
}, initialValidationResult);
var runPasswordValidations = ({ required, value, validations, isValid, errortext }) => {
  if (required && !value) {
    return { isValid: false, errortext: "Password is required" };
  } else if (required || value) {
    const { isValid: validatedIsValid, errortext: validatedErrortext } = tryApplyValidations(value, validations, { isValid, errortext });
    return { isValid: validatedIsValid, errortext: !validatedIsValid ? validatedErrortext ? validatedErrortext : "Password too weak" : errortext };
  }
  return { isValid, errortext };
};
var runValidations = ({ required, value, id, validations, wasMaybeTouched }) => {
  const isValid = true;
  const errortext = "";
  if (id && id.includes("password")) {
    return runPasswordValidations({ required, value, validations, isValid, errortext });
  } else {
    if (value || required || wasMaybeTouched && validations.includes("isLength:1")) {
      return tryApplyValidations(validations.includes("trim") ? value.trim() : value, validations, { isValid, errortext });
    }
  }
  return { isValid, errortext };
};
var useStyles2 = (0, import_mui2.makeStyles)()((theme) => ({
  buttonWrapper: { display: "flex", justifyContent: "flex-end", height: "min-content", marginTop: theme.spacing(4) },
  cancelButton: { marginRight: theme.spacing() }
}));
var Form = ({
  autocomplete,
  buttonColor,
  children,
  className = "",
  classes = { buttonWrapper: "", cancelButton: "" },
  defaultValues = {},
  handleCancel,
  id,
  initialValues = {},
  onSubmit,
  showButtons,
  submitLabel,
  submitRef
}) => {
  const { classes: internalClasses } = useStyles2();
  const methods = (0, import_react_hook_form3.useForm)({ mode: "onChange", defaultValues });
  const {
    handleSubmit,
    formState: { isValid },
    setValue
  } = methods;
  (0, import_react3.useEffect)(() => {
    if (submitRef) {
      submitRef.current = handleSubmit(onSubmit);
    }
  }, [handleSubmit, onSubmit, submitRef]);
  (0, import_react3.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_react_hook_form3.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)("form", { autoComplete: autocomplete, className, id, noValidate: true, onSubmit: handleSubmit(onSubmit), children: [
    children,
    !!showButtons && /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)("div", { className: `button-wrapper ${internalClasses.buttonWrapper} ${classes.buttonWrapper}`, children: [
      !!handleCancel && /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material3.Button, { className: `${internalClasses.cancelButton} ${classes.cancelButton}`, onClick: handleCancel, children: "Cancel" }, "cancel"),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material3.Button, { variant: "contained", type: "submit", disabled: !isValid, color: buttonColor, children: submitLabel })
    ] })
  ] }) });
};
var Form_default = Form;

// src/forms/FormCheckbox.tsx
var import_react_hook_form4 = require("react-hook-form");
var import_material4 = require("@mui/material");
var import_jsx_runtime6 = require("react/jsx-runtime");
var FormCheckbox = ({ className, control, disabled, id, handleClick, style, label, required }) => /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
  import_react_hook_form4.Controller,
  {
    name: id,
    rules: { required },
    control,
    render: ({ field: { value = false, onChange } }) => /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
      import_material4.FormControlLabel,
      {
        className,
        control: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_material4.Checkbox, { name: id, onClick: handleClick, disabled, checked: value, style, color: "primary", onChange: () => onChange(!value) }),
        label
      }
    )
  }
);

// src/forms/KeyValueEditor.tsx
var import_react4 = require("react");
var import_react_hook_form5 = require("react-hook-form");
var import_icons_material2 = require("@mui/icons-material");
var import_material5 = require("@mui/material");
var import_mui3 = require("tss-react/mui");
var import_jsx_runtime7 = require("react/jsx-runtime");
var emptyInput = { helptip: null, key: "", value: "" };
var reducePairs = (pairs) => (pairs || []).reduce((accu, item) => ({ ...accu, ...item.value ? { [item.key]: item.value } : {} }), {});
var useStyles3 = (0, import_mui3.makeStyles)()((theme) => ({
  spacer: { minWidth: theme.spacing(30) },
  helptip: { left: -35, top: 15, position: "absolute" },
  keyValueContainer: {
    display: "grid",
    gridTemplateColumns: "min-content min-content max-content",
    columnGap: theme.spacing(2),
    alignItems: "baseline",
    justifyItems: "baseline",
    "> div": {
      marginTop: 10
    }
  }
}));
var KeyValueFields = ({ disabled, errortext, inputHelpTipsMap, onInputChange }) => {
  const { classes } = useStyles3();
  const {
    control,
    watch,
    setValue,
    formState: { errors },
    trigger
  } = (0, import_react_hook_form5.useFormContext)();
  const { fields, append, remove, replace } = (0, import_react_hook_form5.useFieldArray)({
    control,
    name: "inputs",
    rules: {
      validate: {
        noDuplicates: (inputs2) => {
          const keys = (inputs2 || []).map((item) => item.key).filter(Boolean);
          return new Set(keys).size === keys.length || "Duplicate keys exist, only the last set value will be submitted";
        }
      }
    }
  });
  const inputs = watch("inputs");
  (0, import_react4.useEffect)(() => {
    const inputObject = reducePairs(inputs);
    onInputChange(inputObject);
  }, [JSON.stringify(inputs), onInputChange]);
  const onClearClick = () => replace([{ ...emptyInput }]);
  const addKeyValue = () => append({ ...emptyInput });
  const updateField = (index, field, value) => {
    setValue(`inputs.${index}.${field}`, value);
    if (field === "key") {
      const normalizedKey = value.toLowerCase();
      setValue(`inputs.${index}.helptip`, inputHelpTipsMap[normalizedKey]);
    }
    trigger();
  };
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("div", { children: [
    fields.map((field, index) => {
      const hasError = Boolean(index === fields.length - 1 && (errortext || errors?.inputs?.root?.message));
      const hasRemovalDisabled = !(inputs?.[index]?.key && inputs?.[index]?.value);
      const { component: Helptip = null, props: helptipProps = {} } = inputs[index].helptip ?? {};
      return /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("div", { className: `${classes.keyValueContainer} relative`, children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_material5.FormControl, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
            import_material5.OutlinedInput,
            {
              disabled,
              value: inputs?.[index]?.key || "",
              placeholder: "Key",
              onChange: (e) => updateField(index, "key", e.target.value),
              type: "text"
            }
          ),
          hasError && /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material5.FormHelperText, { children: errortext || errors?.inputs?.root?.message })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material5.FormControl, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
          import_material5.OutlinedInput,
          {
            disabled,
            value: inputs?.[index]?.value || "",
            placeholder: "Value",
            onChange: (e) => updateField(index, "value", e.target.value),
            type: "text"
          }
        ) }),
        fields.length > 1 && !hasRemovalDisabled ? /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material5.IconButton, { disabled, onClick: () => remove(index), size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_icons_material2.Clear, { fontSize: "small" }) }) : /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("span", {}),
        Helptip && /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(Helptip, { className: classes.helptip, ...helptipProps })
      ] }, field.id);
    }),
    /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("div", { className: classes.keyValueContainer, children: [
      /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("div", { className: classes.spacer, children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
        import_material5.Fab,
        {
          disabled: disabled || !inputs?.[fields.length - 1]?.key || !inputs?.[fields.length - 1]?.value,
          style: { marginBottom: 10 },
          color: "secondary",
          size: "small",
          onClick: addKeyValue,
          children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_icons_material2.Add, {})
        }
      ) }),
      /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("div", { className: classes.spacer }),
      inputs.length > 1 ? /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("a", { onClick: onClearClick, children: "clear all" }) : /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("div", {})
    ] })
  ] });
};
var KeyValueEditor = ({ disabled, errortext, initialInput = {}, inputHelpTipsMap = {}, onInputChange }) => {
  const defaultValues = {
    inputs: Object.keys(initialInput).length ? Object.entries(initialInput).map(([key, value]) => ({ helptip: inputHelpTipsMap[key.toLowerCase()], key, value })) : [{ ...emptyInput }]
  };
  const [initialValues] = (0, import_react4.useState)(defaultValues);
  const onFormSubmit = (data) => onInputChange(reducePairs(data.inputs));
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(Form_default, { autocomplete: "off", defaultValues, id: "key-value-editor", initialValues, onSubmit: onFormSubmit, children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(KeyValueFields, { disabled, errortext, inputHelpTipsMap, onInputChange }) });
};

// src/forms/PasswordInput.tsx
var import_react5 = __toESM(require("react"), 1);
var import_react_hook_form6 = require("react-hook-form");
var import_icons_material3 = require("@mui/icons-material");
var import_material6 = require("@mui/material");
var import_constants2 = require("@northern.tech/store/constants");
var import_helpers = require("@northern.tech/utils/helpers");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"), 1);
var import_generate_password_browser = __toESM(require("generate-password-browser"), 1);
var import_jsx_runtime8 = require("react/jsx-runtime");
var PasswordGenerateButtons = ({ clearPass, edit, generatePass, disabled }) => /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)("div", { className: "pass-buttons", children: [
  /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material6.Button, { color: "primary", onClick: generatePass, disabled, children: "Generate" }),
  edit ? /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material6.Button, { onClick: clearPass, children: "Cancel" }) : null
] });
var SCORE_THRESHOLD = 3;
var PasswordGenerationControls = ({ score, feedback }) => /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(import_jsx_runtime8.Fragment, { children: [
  /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)("div", { className: "help-text", id: "pass-strength", children: [
    "Strength: ",
    /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("meter", { max: 4, min: 0, value: score, high: 3.9, optimum: 4, low: 2.5 }),
    score > SCORE_THRESHOLD ? /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_icons_material3.CheckCircle, { className: "fadeIn green", style: { height: 18, marginTop: -3, marginBottom: -3 } }) : null
  ] }),
  !!feedback.length && /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("p", { className: "help-text", children: feedback.map((message, index) => /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(import_react5.default.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("span", { children: message }),
    /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("br", {})
  ] }, `feedback-${index}`)) })
] });
var PasswordInput = ({
  autocomplete,
  className,
  control,
  create,
  defaultValue,
  disabled,
  edit,
  generate,
  id,
  InputLabelProps = {},
  label,
  onClear,
  placeholder,
  required,
  validations = ""
}) => {
  const [score, setScore] = (0, import_react5.useState)(0);
  const [visible, setVisible] = (0, import_react5.useState)(false);
  const [copied, setCopied] = (0, import_react5.useState)(false);
  const [feedback, setFeedback] = (0, import_react5.useState)([]);
  const [confirmationId] = (0, import_react5.useState)(id.includes("current") ? "" : ["password", "password_confirmation"].find((thing) => thing !== id));
  const timer = (0, import_react5.useRef)();
  const {
    clearErrors,
    formState: { errors },
    setError,
    setValue,
    trigger,
    getValues
  } = (0, import_react_hook_form6.useFormContext)();
  const confirmation = (0, import_react_hook_form6.useWatch)({ name: confirmationId });
  const errorKey = `${id}`;
  const { message } = errors[errorKey] ?? {};
  (0, import_react5.useEffect)(() => {
    if (confirmationId === "password" && !message) {
      trigger(confirmationId);
    }
  }, [confirmationId, message, trigger]);
  (0, import_react5.useEffect)(() => () => {
    clearTimeout(timer.current);
  });
  const clearPassClick = () => {
    setValue(id, "");
    onClear();
    setCopied(false);
  };
  const generatePassClick = () => {
    const password = import_generate_password_browser.default.generate({ length: 16, numbers: true });
    setValue(id, password);
    const form = getValues();
    if (form.hasOwnProperty(`${id}_confirmation`)) {
      setValue(`${id}_confirmation`, password);
    }
    (0, import_copy_to_clipboard.default)(password);
    setCopied(true);
    setVisible(true);
    timer.current = setTimeout(() => setCopied(false), import_constants2.TIMEOUTS.fiveSeconds);
    trigger();
  };
  const validate = async (value = "") => {
    if (disabled) {
      return true;
    }
    let { isValid, errortext } = runValidations({ id, required, validations, value });
    if (confirmation && value !== confirmation) {
      isValid = false;
      errortext = "The passwords you provided do not match, please check again.";
    }
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    const { default: zxcvbn } = await import(
      /* webpackChunkName: "zxcvbn" */
      "zxcvbn"
    );
    const strength = zxcvbn(value);
    const score2 = strength.score;
    setScore(score2);
    if (!create || !required && !value) {
      return isValid || errortext;
    }
    setFeedback(strength.feedback.suggestions || []);
    return score2 > SCORE_THRESHOLD && isValid || errortext;
  };
  const showAsNotched = label && typeof label !== "string" ? { notched: true } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)("div", { className, children: [
    /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)("div", { className: "password-wrapper", children: [
      /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
        import_react_hook_form6.Controller,
        {
          name: id,
          control,
          rules: { required, validate },
          render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(import_material6.FormControl, { className: required ? "required" : "", error: Boolean((error || errors[errorKey])?.message), style: { width: 400 }, children: [
            /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material6.InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
            /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
              import_material6.OutlinedInput,
              {
                autoComplete: autocomplete,
                id,
                label,
                name: id,
                type: visible ? "text" : "password",
                defaultValue,
                placeholder,
                value: value ?? "",
                disabled,
                inputRef: ref,
                required,
                onChange: ({ target: { value: value2 } }) => {
                  setValue(id, value2);
                  onChange(value2);
                },
                onBlur,
                endAdornment: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material6.InputAdornment, { position: "end", children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material6.IconButton, { onClick: () => setVisible(import_helpers.toggle), size: "large", children: visible ? /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_icons_material3.Visibility, {}) : /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_icons_material3.VisibilityOff, {}) }) }),
                ...showAsNotched
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material6.FormHelperText, { children: (errors[errorKey] || error)?.message })
          ] })
        }
      ),
      generate && !required && /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] }),
    copied ? /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("div", { className: "green fadeIn margin-bottom-small", children: "Copied to clipboard" }) : null,
    create && /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(import_jsx_runtime8.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(PasswordGenerationControls, { feedback, score }),
      generate && required && /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] })
  ] });
};

// src/forms/TextInput.tsx
var import_react_hook_form7 = require("react-hook-form");
var import_material7 = require("@mui/material");
var import_jsx_runtime9 = require("react/jsx-runtime");
var TextInput = ({
  autocomplete,
  className = "",
  control,
  controlRef,
  disabled,
  hint,
  id,
  InputLabelProps = {},
  InputProps = {},
  label,
  required,
  type,
  validations = "",
  numericValidations = {},
  value: passedValue = ""
}) => {
  const {
    clearErrors,
    formState: { errors },
    setError
  } = (0, import_react_hook_form7.useFormContext)();
  const errorKey = `${id}-error`;
  const validate = (value) => {
    if (disabled) {
      return true;
    }
    const { isValid, errortext } = runValidations({ id, required, validations, value, wasMaybeTouched: !!errors[id] });
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    return isValid || errortext;
  };
  return /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
    import_react_hook_form7.Controller,
    {
      name: id,
      control,
      rules: { required, validate, ...numericValidations },
      render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(import_material7.FormControl, { className: `${className} ${required ? "required" : ""}`, error: Boolean(error?.message || errors[errorKey]), style: { width: 400 }, children: [
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_material7.InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
          import_material7.OutlinedInput,
          {
            autoComplete: autocomplete,
            id,
            label,
            name: id,
            disabled,
            inputRef: (inputRef) => {
              ref(inputRef);
              if (controlRef) {
                controlRef.current = inputRef;
              }
            },
            value: value ?? passedValue,
            onChange: ({ target: { value: value2 } }) => onChange(value2),
            onBlur,
            placeholder: hint,
            type,
            ...InputProps
          }
        ),
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_material7.FormHelperText, { children: (errors[errorKey] || error)?.message })
      ] })
    }
  );
};

// src/forms/TimeframePicker.tsx
var import_react6 = require("react");
var import_react_hook_form8 = require("react-hook-form");
var import_DatePicker = require("@mui/x-date-pickers/DatePicker");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_jsx_runtime10 = require("react/jsx-runtime");
var ensureStartOfDay = (date) => {
  const momentDate = typeof date === "string" ? (0, import_dayjs.default)(date.replace("Z", "")) : (0, import_dayjs.default)(date);
  return `${momentDate.format().split("T")[0]}T00:00:00.000`;
};
var ensureEndOfDay = (date) => {
  const momentDate = typeof date === "string" ? (0, import_dayjs.default)(date.replace("Z", "")) : (0, import_dayjs.default)(date);
  return `${momentDate.format().split("T")[0]}T23:59:59.999`;
};
var TimeframePicker = ({
  tonight: propsTonight,
  format = "YYYY-MM-DD",
  fromLabel = "From",
  toLabel = "To",
  slotProps = {},
  fallbackValue = (0, import_dayjs.default)()
}) => {
  const [tonight] = (0, import_react6.useState)((0, import_dayjs.default)(propsTonight));
  const [maxStartDate, setMaxStartDate] = (0, import_react6.useState)(tonight);
  const [minEndDate, setMinEndDate] = (0, import_react6.useState)(tonight);
  const { control, setValue, watch, getValues } = (0, import_react_hook_form8.useFormContext)();
  const startDate = watch("startDate");
  const endDate = watch("endDate");
  (0, import_react6.useEffect)(() => {
    const currentEndDate = getValues("endDate");
    const now = (/* @__PURE__ */ new Date()).toISOString().replace("Z", "");
    if (startDate > currentEndDate) {
      setValue("endDate", ensureEndOfDay(startDate));
    } else if (currentEndDate > now) {
      setValue("endDate", now);
    }
    setMinEndDate((0, import_dayjs.default)(startDate));
  }, [startDate, getValues, setValue]);
  (0, import_react6.useEffect)(() => {
    const currentStartDate = getValues("startDate");
    if (endDate < currentStartDate) {
      setValue("startDate", ensureStartOfDay(endDate));
    }
    setMaxStartDate((0, import_dayjs.default)(endDate));
  }, [endDate, getValues, setValue]);
  const handleChangeStartDate = (date) => ensureStartOfDay(date);
  const handleChangeEndDate = (date) => ensureEndOfDay(date);
  return /* @__PURE__ */ (0, import_jsx_runtime10.jsxs)("div", { className: "flexbox", style: { flexWrap: "wrap", gap: 15 }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(
      import_react_hook_form8.Controller,
      {
        name: "startDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(
          import_DatePicker.DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "From"
                }
              })
            },
            yearsOrder: "desc",
            label: fromLabel,
            maxDate: maxStartDate,
            onChange: (e) => onChange(handleChangeStartDate(e)),
            value: value ? (0, import_dayjs.default)(value) : fallbackValue
          }
        )
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(
      import_react_hook_form8.Controller,
      {
        name: "endDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(
          import_DatePicker.DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "To"
                }
              })
            },
            yearsOrder: "desc",
            label: toLabel,
            minDate: minEndDate,
            onChange: (e) => onChange(handleChangeEndDate(e)),
            value: value ? (0, import_dayjs.default)(value) : fallbackValue
          }
        )
      }
    )
  ] });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ClickFilter,
  ControlledAutoComplete,
  FileUpload,
  Filters,
  Form,
  FormCheckbox,
  KeyValueEditor,
  PasswordInput,
  TextInput,
  TimeframePicker,
  runValidations
});
//# sourceMappingURL=index.cjs.map