import {
  listItemMapper
} from "./chunk-UE5N5VO3.js";

// src/releasesSlice/selectors.ts
import { createSelector } from "@reduxjs/toolkit";
var getSelectedReleaseId = (state) => state.releases.selectedRelease;
var getReleasesById = (state) => state.releases.byId;
var getReleaseTags = (state) => state.releases.tags;
var getReleaseListState = (state) => state.releases.releasesList;
var getListedReleases = (state) => state.releases.releasesList.releaseIds;
var getUpdateTypes = (state) => state.releases.updateTypes;
var releaseDefaults = {};
var getReleaseMappingDefaults = () => releaseDefaults;
var getReleasesList = createSelector([getReleasesById, getListedReleases, getReleaseMappingDefaults], listItemMapper);
var getReleaseTagsById = createSelector([getReleaseTags], (releaseTags) => releaseTags.reduce((accu, key) => ({ ...accu, [key]: key }), {}));
var getHasReleases = createSelector(
  [getReleaseListState, getReleasesById],
  ({ searchTotal, total }, byId) => !!(Object.keys(byId).length || total || searchTotal)
);
var getSelectedRelease = createSelector([getReleasesById, getSelectedReleaseId], (byId, id) => byId[id || ""] ?? {});
var getSelectedReleases = createSelector([getReleaseListState, getReleasesList], ({ selection }, releases) => selection.map((index) => releases[index]));

export {
  getReleasesById,
  getReleaseTags,
  getReleaseListState,
  getUpdateTypes,
  getReleasesList,
  getReleaseTagsById,
  getHasReleases,
  getSelectedRelease,
  getSelectedReleases
};
//# sourceMappingURL=chunk-MSOXMRF7.js.map