import {
  isDarkMode
} from "./chunk-UE5N5VO3.js";
import {
  DEVICE_ONLINE_CUTOFF,
  READ_STATES,
  defaultIdAttribute,
  twoFAStates
} from "./chunk-7C4SQBEE.js";

// src/usersSlice/selectors.ts
import { createSelector } from "@reduxjs/toolkit";
var emptyObject = {};
var getRolesById = (state) => state.users.rolesById;
var getTooltipsById = (state) => state.users.tooltips.byId;
var getGlobalSettings = (state) => state.users.globalSettings;
var getUserSettingsInitialized = (state) => state.users.settingsInitialized;
var getCurrentUserId = (state) => state.users.currentUser;
var getUsersById = (state) => state.users.byId;
var getUsersList = createSelector([getUsersById], (usersById) => Object.values(usersById));
var getCurrentUser = createSelector(
  [getUsersById, getCurrentUserId],
  (usersById, userId) => userId ? usersById[userId] ?? emptyObject : emptyObject
);
var getUserSettings = (state) => state.users.userSettings;
var getSelectedDeviceAttribute = createSelector(
  [getUserSettings],
  ({ columnSelection }) => columnSelection.map((attribute) => ({ attribute: attribute.key, scope: attribute.scope }))
);
var getIsDarkMode = createSelector([getUserSettings], ({ mode }) => isDarkMode(mode));
var getReadAllHelptips = createSelector(
  [getTooltipsById],
  (tooltips) => Object.values(tooltips).every(({ readState }) => readState === READ_STATES.read)
);
var getTooltipsState = createSelector(
  [getTooltipsById, getUserSettings],
  (byId, { tooltips = {} }) => Object.entries(byId).reduce(
    (accu, [id, value]) => {
      accu[id] = { ...accu[id], ...value };
      return accu;
    },
    { ...tooltips }
  )
);
var getHas2FA = createSelector(
  [getCurrentUser],
  (currentUser) => currentUser.hasOwnProperty("tfa_status") && currentUser.tfa_status === twoFAStates.enabled
);
var getIdAttribute = createSelector([getGlobalSettings], ({ id_attribute = { ...defaultIdAttribute } }) => id_attribute);
var getOfflineThresholdSettings = createSelector([getGlobalSettings], ({ offlineThreshold }) => ({
  interval: offlineThreshold?.interval || DEVICE_ONLINE_CUTOFF.interval,
  intervalUnit: offlineThreshold?.intervalUnit || DEVICE_ONLINE_CUTOFF.intervalName
}));
var getRolesList = createSelector([getRolesById], (rolesById) => Object.entries(rolesById).map(([value, role]) => ({ value, ...role })));
var getCurrentSession = (state) => state.users.currentSession;
var getRolesInitialized = (state) => state.users.rolesInitialized;

export {
  getRolesById,
  getTooltipsById,
  getGlobalSettings,
  getUserSettingsInitialized,
  getUsersById,
  getUsersList,
  getCurrentUser,
  getUserSettings,
  getSelectedDeviceAttribute,
  getIsDarkMode,
  getReadAllHelptips,
  getTooltipsState,
  getHas2FA,
  getIdAttribute,
  getOfflineThresholdSettings,
  getRolesList,
  getCurrentSession,
  getRolesInitialized
};
//# sourceMappingURL=chunk-R6KRH2IY.js.map