import * as reselect from 'reselect';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { ReadState } from '../usersSlice/constants.cjs';
import { User, UserSession, CustomColumn, GlobalSettings, UserSettings } from '../usersSlice/index.cjs';
import { ReleaseSliceType } from '../releasesSlice/index.cjs';
import { OnboardingApproach } from '../onboardingSlice/index.cjs';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { Deployment, DeploymentByStatus, DeploymentConfig, SelectionState } from '../deploymentsSlice/index.cjs';
import { DeviceSliceType } from '../devicesSlice/index.cjs';
import { SearchState, SentryConfig, SnackbarContent, Upload } from '../appSlice/index.cjs';
import * as _northern_tech_types_Event from '@northern.tech/types/Event';
import * as _northern_tech_types_BillingProfile from '@northern.tech/types/BillingProfile';
import * as _northern_tech_types_AuditLog from '@northern.tech/types/AuditLog';
import * as _northern_tech_types_Integration from '@northern.tech/types/Integration';
import { Organization, AuditLogSelectionState, Subscription, Card, SSOConfig, TenantList, OrganizationState } from './types.cjs';
import { RootState } from '../store.cjs';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '../commonConstants.cjs';
import 'react/jsx-runtime';
import '../devicesSlice/constants.cjs';
import '@mui/material';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import './constants.cjs';
import 'redux-thunk';

declare const getOrganization: (state: RootState) => Partial<Organization>;
declare const getExternalIntegrations: (state: RootState) => _northern_tech_types_Integration.Integration[];
declare const getAuditlogState: (state: RootState) => AuditLogSelectionState;
declare const getAuditLog: (state: RootState) => _northern_tech_types_AuditLog.AuditLog[];
declare const getAuditLogSelectionState: (state: RootState) => AuditLogSelectionState;
declare const getBillingProfile: (state: RootState) => _northern_tech_types_BillingProfile.BillingProfile | undefined;
declare const getSubscription: (state: RootState) => Subscription | undefined;
declare const getCard: (state: RootState) => Card;
declare const getSsoConfig: ({ organization: { ssoConfigs } }: RootState) => SSOConfig;
declare const getTenantsList: (state: RootState) => TenantList;
declare const getWebhookEvents: (state: RootState) => _northern_tech_types_Event.Event[];
declare const getWebhookEventTotal: (state: RootState) => number;
declare const getDeviceTwinIntegrations: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => _northern_tech_types_Integration.Integration[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: _northern_tech_types_Integration.Integration[]) => _northern_tech_types_Integration.Integration[];
    memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_Integration.Integration[]) => _northern_tech_types_Integration.Integration[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => _northern_tech_types_Integration.Integration[];
    dependencies: [(state: RootState) => _northern_tech_types_Integration.Integration[]];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getIsServiceProvider: (state: RootState) => boolean | undefined;
declare const getWebhooks: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => _northern_tech_types_Integration.Integration[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: _northern_tech_types_Integration.Integration[]) => _northern_tech_types_Integration.Integration[];
    memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_Integration.Integration[]) => _northern_tech_types_Integration.Integration[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => _northern_tech_types_Integration.Integration[];
    dependencies: [(state: RootState) => _northern_tech_types_Integration.Integration[]];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getWebhookEventInfo: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    events: _northern_tech_types_Event.Event[];
    eventTotal: number;
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: _northern_tech_types_Integration.Integration[], resultFuncArgs_1: _northern_tech_types_Event.Event[], resultFuncArgs_2: number) => {
        events: _northern_tech_types_Event.Event[];
        eventTotal: number;
    };
    memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_Integration.Integration[], resultFuncArgs_1: _northern_tech_types_Event.Event[], resultFuncArgs_2: number) => {
        events: _northern_tech_types_Event.Event[];
        eventTotal: number;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        events: _northern_tech_types_Event.Event[];
        eventTotal: number;
    };
    dependencies: [((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => _northern_tech_types_Integration.Integration[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: _northern_tech_types_Integration.Integration[]) => _northern_tech_types_Integration.Integration[];
        memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_Integration.Integration[]) => _northern_tech_types_Integration.Integration[]) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => _northern_tech_types_Integration.Integration[];
        dependencies: [(state: RootState) => _northern_tech_types_Integration.Integration[]];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: RootState) => _northern_tech_types_Event.Event[], (state: RootState) => number];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getAuditLogEntry: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => _northern_tech_types_AuditLog.AuditLog | undefined) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: _northern_tech_types_AuditLog.AuditLog[], resultFuncArgs_1: AuditLogSelectionState) => _northern_tech_types_AuditLog.AuditLog | undefined;
    memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_AuditLog.AuditLog[], resultFuncArgs_1: AuditLogSelectionState) => _northern_tech_types_AuditLog.AuditLog | undefined) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => _northern_tech_types_AuditLog.AuditLog | undefined;
    dependencies: [(state: RootState) => _northern_tech_types_AuditLog.AuditLog[], (state: RootState) => AuditLogSelectionState];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getHasCurrentPricing: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => boolean) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Partial<Organization>) => boolean;
    memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => boolean;
    dependencies: [(state: RootState) => Partial<Organization>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};

export { getAuditLog, getAuditLogEntry, getAuditLogSelectionState, getAuditlogState, getBillingProfile, getCard, getDeviceTwinIntegrations, getExternalIntegrations, getHasCurrentPricing, getIsServiceProvider, getOrganization, getSsoConfig, getSubscription, getTenantsList, getWebhookEventInfo, getWebhookEventTotal, getWebhookEvents, getWebhooks };
