import { DeviceAttribute } from '@northern.tech/types/DeviceAttribute';
import { DeviceIssueOptionKey } from '@northern.tech/utils/constants';
import { DeviceFilter, DeviceGroup, InventoryAttributes } from './devicesSlice/index.js';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';
import './commonConstants.js';
import 'react/jsx-runtime';
import './devicesSlice/constants.js';
import './deploymentsSlice/index.js';

declare const mapFiltersToTerms: (filters: any) => any;
declare const mapTermsToFilters: (terms: any) => any;
declare const convertDeviceListStateToFilters: ({ filters, group, groups, offlineThreshold, selectedIssues, status }: {
    filters?: DeviceFilter[];
    group?: string;
    groups?: {
        byId: Record<string, DeviceGroup>;
    };
    offlineThreshold?: string;
    selectedIssues?: DeviceIssueOptionKey[];
    status?: string;
}) => {
    applicableFilters: DeviceFilter[];
    filterTerms: any;
};
declare const filtersFilter: (item: any, index: any, array: any) => boolean;
declare const listItemMapper: <T>(byId: Record<string, T>, ids: string[], { cutOffSize, defaultObject }: {
    cutOffSize?: number;
    defaultObject?: T;
}) => T[];
declare const mergePermissions: (existingPermissions: {
    auditlog: string[];
    deployments?: string[];
    groups: Record<string, string[]>;
    releases: Record<string, string[]>;
    tenantManagement: string[];
    userManagement: string[];
} | undefined, addedPermissions: any) => any;
declare const mapUserRolesToUiPermissions: (userRoles: any, roles: any) => any;
declare const progress: ({ loaded, total }: {
    loaded: any;
    total: any;
}) => number;
declare const extractErrorMessage: (err: any, fallback?: string) => any;
declare const ensureVersionString: (software: any, fallback: any) => any;
declare const getComparisonCompatibleVersion: (version: any) => any;
declare const stringToBoolean: (content: any) => boolean;
declare const groupDeploymentDevicesStats: (deployment: any) => {
    inprogress: unknown;
    paused: unknown;
    pending: unknown;
    successes: unknown;
    failures: unknown;
};
declare const statCollector: (items: any, statistics: any) => any;
declare const groupDeploymentStats: (deployment: any, withSkipped: any) => {};
declare const getDeploymentState: (deployment: any) => any;
declare const generateDeploymentGroupDetails: (filter: any, groupName: any) => any;
declare const mapDeviceAttributes: (attributes?: DeviceAttribute[]) => {
    identity: Record<string, string>;
    inventory: InventoryAttributes;
    monitor: Record<string, string>;
    system: Record<string, string>;
    tags: Record<string, string>;
};
declare const isDarkMode: (mode: any) => boolean;
type Line = {
    addon?: string;
    amount: number;
    currency: string;
    description: string;
    quantity: number;
};
declare const parseSubscriptionPreview: (lines: Line[]) => {
    plan: number;
    addons: {};
};

export { convertDeviceListStateToFilters, ensureVersionString, extractErrorMessage, filtersFilter, generateDeploymentGroupDetails, getComparisonCompatibleVersion, getDeploymentState, groupDeploymentDevicesStats, groupDeploymentStats, isDarkMode, listItemMapper, mapDeviceAttributes, mapFiltersToTerms, mapTermsToFilters, mapUserRolesToUiPermissions, mergePermissions, parseSubscriptionPreview, progress, statCollector, stringToBoolean };
