import { Artifact } from './Artifact.js';
import { Deployment } from './Deployment.js';
import { Device } from './Device.js';
import { Tenant } from './Tenant.js';
import { User } from './User.js';
import './ArtifactInfo.js';
import './Update.js';
import './ArtifactTypeInfo.js';
import './UpdateFile.js';
import './DeploymentPhase.js';
import './DeploymentStatistics.js';
import './DeploymentStatusStatistics.js';
import './Filter.js';
import './FilterPredicate.js';
import './DeviceStatus.js';
import './TenantV1.js';
import './Addon.js';
import './Plan.js';
import './Features.js';
import './TenantAdditionalInfo.js';
import './TenantApiLimits.js';
import './ApiLimits.js';
import './ApiBurst.js';
import './ApiQuota.js';

/**
 * Various types of objects are supported.
 * Depending on the type of object different information will be available.
 */
type AuditLogObject = {
    /**
     * A unique identifier of the object.
     */
    id: string;
    /**
     * The type of the object.
     */
    type: AuditLogObject.type;
    tenant?: Tenant;
    user?: User;
    deployment?: Deployment;
    artifact?: Artifact;
    device?: Device;
};
declare namespace AuditLogObject {
    /**
     * The type of the object.
     */
    enum type {
        TENANT = "tenant",
        USER = "user",
        DEPLOYMENT = "deployment",
        ARTIFACT = "artifact",
        DEVICE = "device"
    }
}

export { AuditLogObject };
