import { SsoObject } from './SsoObject.cjs';

/**
 * New user descriptor.
 */
type UserNew = {
    /**
     * A unique email address. Non-ascii characters are invalid.
     */
    email: string;
    /**
     * Password.
     */
    password?: string;
    /**
     * Alternative login schemes
     */
    login?: Record<string, any>;
    /**
     * SSO login schemes
     */
    sso?: Array<SsoObject>;
};

export type { UserNew };
