"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dialogs/StartupNotification.tsx
var StartupNotification_exports = {};
__export(StartupNotification_exports, {
  StartupNotificationDialog: () => StartupNotificationDialog,
  default: () => StartupNotification_default
});
module.exports = __toCommonJS(StartupNotification_exports);
var import_react = require("react");
var import_react_redux = require("react-redux");
var import_material2 = require("@mui/material");
var import_actions = __toESM(require("@northern.tech/store/actions"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_selectors = require("@northern.tech/store/selectors");
var import_thunks = require("@northern.tech/store/thunks");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// ../../assets/img/headerlogo.png
var headerlogo_default = "../headerlogo-QQW3XP5Y.png";

// ../../assets/img/whiteheaderlogo.png
var whiteheaderlogo_default = "../whiteheaderlogo-76DNCTF3.png";

// src/SupportLink.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var variants = {
  email: "support@mender.io",
  ourTeam: "contact our team",
  support: "contact support",
  salesTeam: "contact our sales team"
};
var SupportLink = ({ className = "", variant }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("a", { className, href: "mailto:support@mender.io", target: "_blank", rel: "noopener noreferrer", children: variants[variant] ?? variant });

// src/dialogs/BaseDialog.tsx
var import_material = require("@mui/material");
var import_jsx_runtime2 = require("react/jsx-runtime");
var BaseDialog = (props) => {
  const { children, onClose, title, ...dialogProps } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material.Dialog, { ...dialogProps, onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material.DialogTitle, { children: title }),
    children
  ] });
};

// src/dialogs/StartupNotification.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var { setShowStartupNotification } = import_actions.default;
var OfflineThresholdContent = () => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_jsx_runtime3.Fragment, { children: [
  "In our continuous efforts to enhance performance and to ensure the stability of our service, we have made adjustments to how granular device connectivity can be checked.",
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("h4", { children: "What's changing:" }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("ul", { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("li", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("i", { children: "Offline threshold" }),
    " setting: if a device no longer connects with the server, it may take up to 1 day until it is shown as an offline device in the UI."
  ] }) }),
  "More granular connectivity information will still be reflected in the device details.",
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("h4", { children: "Why are we changing this:" }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("ul", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("li", { children: "Performance Improvements: Less frequent updates allow us to better optimize the platform and improve overall performance." }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("li", { children: "Stability: This change helps ensure that our backend will remain stable while serving an ever growing number of devices and potential disruptions are minimized." })
  ] }),
  "We appreciate your understanding and cooperation as we implement these improvements. Our commitment to providing you with a reliable and high-performing platform remains our top priority.",
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.Divider, { className: "margin-top-small margin-bottom-small" }),
  "If you have any questions or concerns regarding this change, please do not hesitate to ",
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(SupportLink, { variant: "ourTeam" }),
  "."
] });
var notifications = {
  offlineThreshold: {
    Content: OfflineThresholdContent,
    action: ({ dispatch }) => dispatch((0, import_thunks.saveGlobalSettings)({ offlineThreshold: { interval: 1, intervalUnit: import_constants.DEVICE_ONLINE_CUTOFF.intervalName } }))
  }
};
var StartupNotificationDialog = () => {
  const [isAllowedToClose] = (0, import_react.useState)(false);
  const dispatch = (0, import_react_redux.useDispatch)();
  const isDarkMode = (0, import_react_redux.useSelector)(import_selectors.getIsDarkMode);
  const { action, Content } = notifications.offlineThreshold;
  const debouncedCloseGuard = (0, import_debouncehook.useDebounce)(isAllowedToClose, import_constants.TIMEOUTS.fiveSeconds);
  const onClose = () => {
    action({ dispatch });
    dispatch(setShowStartupNotification(false));
  };
  const headerLogo = isDarkMode ? whiteheaderlogo_default : headerlogo_default;
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(
    BaseDialog,
    {
      open: true,
      slotProps: {
        paper: {
          className: "padding-small",
          sx: { maxWidth: 720 }
        }
      },
      title: /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: "flexbox center-aligned", children: [
        /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("img", { src: headerLogo, style: { maxHeight: 75 } }),
        /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "margin-left-small", children: "Welcome back!" })
      ] }),
      onClose,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.DialogContent, { className: "margin-left-small margin-right-small", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Content, {}) }),
        /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.DialogActions, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.Button, { variant: "contained", disabled: debouncedCloseGuard, onClick: onClose, children: "Close" }) })
      ]
    }
  );
};
var StartupNotification_default = StartupNotificationDialog;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  StartupNotificationDialog
});
//# sourceMappingURL=StartupNotification.cjs.map