"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/xterm.tsx
var xterm_exports = {};
__export(xterm_exports, {
  Xterm: () => Xterm,
  default: () => xterm_default
});
module.exports = __toCommonJS(xterm_exports);
var import_react = require("react");
var import_addon_fit = require("@xterm/addon-fit");
var import_addon_search = require("@xterm/addon-search");
var import_xterm = require("@xterm/xterm");
var import_xterm2 = require("@xterm/xterm/css/xterm.css");
var import_jsx_runtime = require("react/jsx-runtime");
var searchAddon = new import_addon_search.SearchAddon();
var fitAddon = new import_addon_fit.FitAddon();
var addons = [fitAddon, searchAddon];
var defaultOptions = { allowProposedApi: true, scrollback: 5e3 };
var Xterm = ({ className, customKeyEventHandler, options = {}, onResize, style, triggerResize, xtermRef, ...remainingProps }) => {
  (0, import_react.useEffect)(() => {
    const { terminal, terminalRef } = xtermRef.current;
    terminal.current = new import_xterm.Terminal({ ...defaultOptions, ...options });
    addons.forEach((addon) => terminal.current.loadAddon(addon));
    Object.entries(remainingProps).forEach(([key, value]) => value ? terminal.current[key](value) : void 0);
    if (customKeyEventHandler) {
      terminal.current.attachCustomKeyEventHandler(customKeyEventHandler);
    }
    if (terminalRef.current) {
      terminal.current.open(terminalRef.current);
    }
    return () => {
      terminal.current.dispose();
    };
  }, [addons, customKeyEventHandler, JSON.stringify(options), Object.keys(remainingProps).join("")]);
  (0, import_react.useEffect)(() => {
    if (!xtermRef.current.terminalRef.current) {
      return;
    }
    try {
      fitAddon.fit();
      const { rows = 40, cols = 80 } = fitAddon.proposeDimensions() || {};
      if (onResize) {
        onResize({ rows, cols });
      }
    } catch {
    }
  }, [triggerResize]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className, ref: xtermRef.current.terminalRef, style });
};
var xterm_default = Xterm;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Xterm
});
//# sourceMappingURL=xterm.cjs.map