"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/auditlogs/AuditLogsFilter.tsx
var AuditLogsFilter_exports = {};
__export(AuditLogsFilter_exports, {
  AuditLogsFilter: () => AuditLogsFilter,
  default: () => AuditLogsFilter_default
});
module.exports = __toCommonJS(AuditLogsFilter_exports);
var import_react = require("react");
var import_material = require("@mui/material");
var import_Autocomplete = require("@northern.tech/common-ui/forms/Autocomplete");
var import_ClickFilter = __toESM(require("@northern.tech/common-ui/forms/ClickFilter"), 1);
var import_Filters = __toESM(require("@northern.tech/common-ui/forms/Filters"), 1);
var import_TimeframePicker = __toESM(require("@northern.tech/common-ui/forms/TimeframePicker"), 1);
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var detailsMap = {
  Deployment: "to device group",
  User: "email"
};
var getOptionLabel = (option) => option.title ?? option.email ?? option;
var renderOption = (props, option) => {
  const { key, ...rest } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("li", { ...rest, children: getOptionLabel(option) }, key);
};
var isUserOptionEqualToValue = ({ email, id }, value) => id === value || email === value || email === value?.email;
var autoSelectProps = {
  autoSelect: true,
  filterSelectedOptions: true,
  getOptionLabel,
  handleHomeEndKeys: true,
  renderOption
};
var AuditLogsFilter = ({ groups, users, selectionState, disabled, onFiltersChange, detailsReset, auditLogsTypes, dirtyField, setDirtyField }) => {
  const { detail, endDate, user, startDate, type } = selectionState;
  const [date] = (0, import_react.useState)((0, import_helpers.getISOStringBoundaries)(/* @__PURE__ */ new Date()));
  const { start: today, end: tonight } = date;
  const typeOptionsMap = {
    Deployment: groups,
    User: Object.values(users)
  };
  const detailOptions = typeOptionsMap[type?.title] ?? [];
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ClickFilter.default, { disabled, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_Filters.default,
    {
      initialValues: { startDate, endDate, user, type, detail },
      defaultValues: { startDate: today, endDate: tonight, user: "", type: null, detail: "" },
      fieldResetTrigger: detailsReset,
      dirtyField,
      clearDirty: setDirtyField,
      filters: [
        {
          key: "user",
          title: "Performed by",
          Component: import_Autocomplete.ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            freeSolo: true,
            isOptionEqualToValue: isUserOptionEqualToValue,
            options: Object.values(users),
            renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, placeholder: "Select a user", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "type",
          title: "Filter by changes",
          Component: import_Autocomplete.ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            options: auditLogsTypes,
            isOptionEqualToValue: (option, value) => option.value === value.value && option.object_type === value.object_type,
            renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, placeholder: "Type", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "detail",
          title: "",
          Component: import_Autocomplete.ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            freeSolo: true,
            options: detailOptions,
            disabled: !type,
            renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { ...params, placeholder: detailsMap[type] || "-", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "timeframe",
          title: "Start time",
          Component: import_TimeframePicker.default,
          componentProps: {
            tonight
          }
        }
      ],
      onChange: onFiltersChange
    }
  ) });
};
var AuditLogsFilter_default = AuditLogsFilter;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AuditLogsFilter
});
//# sourceMappingURL=AuditLogsFilter.cjs.map