"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/auditlogs/eventdetails/PortForward.tsx
var PortForward_exports = {};
__export(PortForward_exports, {
  PortForward: () => PortForward,
  default: () => PortForward_default
});
module.exports = __toCommonJS(PortForward_exports);
var import_react = require("react");
var import_react_redux = require("react-redux");
var import_styles = require("@mui/material/styles");
var import_Loader = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_Time = __toESM(require("@northern.tech/common-ui/Time"), 1);
var import_selectors = require("@northern.tech/store/selectors");
var import_thunks = require("@northern.tech/store/thunks");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_duration = __toESM(require("dayjs/plugin/duration.js"), 1);

// src/auditlogs/eventdetails/DeviceDetails.tsx
var import_react_router_dom = require("react-router-dom");
var import_icons_material = require("@mui/icons-material");
var import_mui = require("tss-react/mui");
var import_ConfigurationObject = require("@northern.tech/common-ui/ConfigurationObject");
var import_DeviceIdentity = __toESM(require("@northern.tech/common-ui/DeviceIdentity"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_locationutils = require("@northern.tech/store/locationutils");
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  eventDetails: { gridTemplateColumns: "minmax(max-content, 150px) max-content", rowGap: theme.spacing(2.5) },
  deviceLink: { color: theme.palette.text.secondary, fontWeight: "initial" }
}));
var DetailInformation = ({ title, details }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox column margin-top-small", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("b", { className: "margin-bottom-small capitalized-start", children: [
      title,
      " details"
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ConfigurationObject.TwoColumns, { className: classes.eventDetails, items: details })
  ] }, `${title}-details`);
};
var deviceAuditlogType = import_constants.AUDIT_LOGS_TYPES.find((type) => type.value === "device");
var DeviceDetails = ({ device, idAttribute, onClose }) => {
  const { classes } = useStyles();
  const { attributes, id: deviceId } = device;
  const { name, device_type: deviceTypes, artifact_name } = attributes || {};
  const { attribute } = idAttribute;
  const usesId = attribute === "id" || attribute === "Device ID";
  const nameContainer = name ? { Name: name } : {};
  const deviceDetails = {
    ...nameContainer,
    [usesId ? "Device ID" : attribute]: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_react_router_dom.Link, { className: `flexbox center-aligned ${classes.deviceLink}`, to: `/devices?id=${deviceId}`, children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_DeviceIdentity.default, { device, isEditable: false }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Launch, { className: "margin-left-small link-color", fontSize: "small" })
    ] }),
    "Device type": deviceTypes,
    "Operating system version": device[import_constants.rootfsImageVersion] || artifact_name || "-",
    " ": /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_react_router_dom.Link,
      {
        to: `/auditlog?${(0, import_locationutils.formatAuditlogs)({ pageState: { type: deviceAuditlogType, detail: deviceId, startDate: import_constants.BEGINNING_OF_TIME } }, {})}`,
        onClick: onClose,
        children: "List all log entries for this device"
      }
    )
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DetailInformation, { title: "device", details: deviceDetails });
};
var DeviceDetails_default = DeviceDetails;

// src/auditlogs/eventdetails/PortForward.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
import_dayjs.default.extend(import_duration.default);
var PortForward = ({ item, onClose }) => {
  const theme = (0, import_styles.useTheme)();
  const [sessionDetails, setSessionDetails] = (0, import_react.useState)();
  const dispatch = (0, import_react_redux.useDispatch)();
  const { action, actor, meta, object = {}, time } = item;
  const { canReadDevices } = (0, import_react_redux.useSelector)(import_selectors.getUserCapabilities);
  const device = (0, import_react_redux.useSelector)(import_selectors.getAuditlogDevice);
  const idAttribute = (0, import_react_redux.useSelector)(import_selectors.getIdAttribute);
  (0, import_react.useEffect)(() => {
    if (canReadDevices) {
      dispatch((0, import_thunks.getDeviceById)(object.id));
    }
    dispatch(
      (0, import_thunks.getSessionDetails)({
        sessionId: meta.session_id[0],
        deviceId: object.id,
        userId: actor.id,
        startDate: action.startsWith("open") ? time : void 0,
        endDate: action.startsWith("close") ? time : void 0
      })
    ).unwrap().then(setSessionDetails);
  }, [action, actor.id, canReadDevices, dispatch, meta.session_id, object.id, time]);
  if (!sessionDetails || canReadDevices && !device) {
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_Loader.default, { show: true });
  }
  const sessionMeta = {
    "Session ID": item.meta.session_id[0],
    "Start time": /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_Time.default, { value: sessionDetails.start }),
    "End time": /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_Time.default, { value: sessionDetails.end }),
    "Duration": import_dayjs.default.duration((0, import_dayjs.default)(sessionDetails.end).diff(sessionDetails.start)).format("HH:mm:ss:SSS"),
    User: item.actor.email
  };
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(DetailInformation, { title: "port forwarding", details: sessionMeta })
  ] });
};
var PortForward_default = PortForward;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  PortForward
});
//# sourceMappingURL=PortForward.cjs.map