// src/auditlogs/AuditLogsList.tsx
import { Sort as SortIcon } from "@mui/icons-material";
import { makeStyles } from "tss-react/mui";
import DetailsIndicator from "@northern.tech/common-ui/DetailsIndicator";
import Loader from "@northern.tech/common-ui/Loader";
import Pagination from "@northern.tech/common-ui/Pagination";
import { SORTING_OPTIONS } from "@northern.tech/store/constants";
import { jsx, jsxs } from "react/jsx-runtime";
var defaultRowsPerPage = 20;
var useStyles = makeStyles()((theme) => ({
  auditlogsList: {
    "& .auditlogs-list-item": {
      display: "grid",
      gridTemplateColumns: "2fr 1fr 1fr 2fr 2fr 1.75fr 120px",
      gridColumnGap: theme.spacing(4),
      padding: `5px ${theme.spacing(2)}`,
      borderBottom: `1px solid ${theme.palette.border.main}`,
      height: theme.spacing(6),
      minHeight: theme.spacing(6),
      maxHeight: theme.spacing(6),
      alignItems: "center",
      "&:last-of-type": {
        borderBottom: "transparent"
      },
      "& > *": {
        display: "flex",
        alignItems: "center",
        maxHeight: theme.spacing(6),
        overflow: "hidden"
      },
      "> .text-overflow": {
        display: "block"
      },
      "&.auditlogs-list-item-header": {
        borderBottom: "transparent",
        cursor: "initial",
        padding: `10px ${theme.spacing(2)}`,
        position: "relative"
      }
    }
  }
}));
var AuditLogsList = ({
  items,
  onChangePage,
  onChangeRowsPerPage,
  onChangeSorting,
  selectionState,
  userCapabilities,
  auditLogColumns,
  onIssueSelection
}) => {
  const { page, perPage, sort = {}, total: count, isLoading } = selectionState;
  const { classes } = useStyles();
  return !!items.length && /* @__PURE__ */ jsxs("div", { className: `fadeIn deploy-table-contain auditlogs-list ${classes.auditlogsList}`, children: [
    /* @__PURE__ */ jsxs("div", { className: "auditlogs-list-item auditlogs-list-item-header muted", children: [
      auditLogColumns.map((column, index) => /* @__PURE__ */ jsxs(
        "div",
        {
          className: "columnHeader",
          onClick: () => column.sortable ? onChangeSorting() : null,
          style: column.sortable ? {} : { cursor: "initial" },
          children: [
            column.title,
            column.sortable ? /* @__PURE__ */ jsx(SortIcon, { className: `sortIcon selected ${(sort.direction === SORTING_OPTIONS.desc).toString()}` }) : null
          ]
        },
        `columnHeader-${index}`
      )),
      /* @__PURE__ */ jsx("div", {})
    ] }),
    /* @__PURE__ */ jsx("div", { className: "auditlogs-list", children: items.map((item) => {
      const allowsExpansion = onIssueSelection && (!!item.change || item.action.includes("terminal") || item.action.includes("portforward"));
      return /* @__PURE__ */ jsxs(
        "div",
        {
          className: `auditlogs-list-item ${allowsExpansion ? "clickable" : ""}`,
          onClick: () => onIssueSelection ? onIssueSelection(allowsExpansion ? item : void 0) : null,
          children: [
            auditLogColumns.map((column, index) => column.render(item, index, userCapabilities)),
            allowsExpansion ? /* @__PURE__ */ jsx(DetailsIndicator, {}) : /* @__PURE__ */ jsx("div", {})
          ]
        },
        `event-${item.time}`
      );
    }) }),
    /* @__PURE__ */ jsxs("div", { className: "flexbox margin-top", children: [
      /* @__PURE__ */ jsx(
        Pagination,
        {
          className: "margin-top-none",
          count,
          rowsPerPage: perPage,
          onChangeRowsPerPage,
          page,
          onChangePage
        }
      ),
      /* @__PURE__ */ jsx(Loader, { show: isLoading, small: true })
    ] })
  ] });
};
var AuditLogsList_default = AuditLogsList;

export {
  defaultRowsPerPage,
  AuditLogsList,
  AuditLogsList_default
};
//# sourceMappingURL=chunk-F35TRHF4.js.map