import {
  getDeviceMonitorConfig,
  getLatestDeviceAlerts
} from "./chunk-H5FAPMJJ.js";
import {
  commonErrorFallback,
  commonErrorHandler,
  createAppAsyncThunk
} from "./chunk-V3QEONX7.js";
import {
  users_api_default
} from "./chunk-QHK7GGV4.js";
import {
  general_api_default
} from "./chunk-RS37Y2PQ.js";
import {
  actions_default
} from "./chunk-F26IKSML.js";
import {
  actions as actions6,
  sliceName as sliceName6
} from "./chunk-UGSLGUS6.js";
import {
  actions as actions5,
  sliceName as sliceName5
} from "./chunk-MZNANSS2.js";
import {
  actions as actions4,
  sliceName as sliceName4
} from "./chunk-VANBSJS5.js";
import {
  actions as actions2,
  sliceName as sliceName2
} from "./chunk-VUFRP6P3.js";
import {
  actions,
  sliceName
} from "./chunk-QYLGIR4W.js";
import {
  actions as actions3,
  sliceName as sliceName3
} from "./chunk-ABJLRDCO.js";
import {
  cleanUp,
  getSessionInfo,
  setSessionInfo
} from "./chunk-ZJW3QIPM.js";
import {
  getAttrsEndpoint,
  getDeviceReportsForUser,
  getOnboardingState,
  getSearchEndpoint,
  getTenantCapabilities,
  getUserCapabilities
} from "./chunk-SCZLNFB5.js";
import {
  getCurrentSession,
  getCurrentUser,
  getGlobalSettings,
  getIdAttribute,
  getOfflineThresholdSettings,
  getRolesById,
  getSelectedDeviceAttribute,
  getTooltipsState,
  getUserSettings,
  getUsersById
} from "./chunk-R6KRH2IY.js";
import {
  getAuditlogState,
  getDeviceTwinIntegrations,
  getOrganization,
  getTenantsList
} from "./chunk-YY6SKZDF.js";
import {
  getAcceptedDevices,
  getDeviceById,
  getDeviceFilters,
  getDeviceListState,
  getDeviceReports,
  getDevicesById,
  getGroupsById,
  getSelectedGroup
} from "./chunk-KJNNEDRV.js";
import {
  getDeploymentsById,
  getDeploymentsByStatus
} from "./chunk-JXQUFKID.js";
import {
  getFeatures,
  getSearchState
} from "./chunk-BYUPW7RA.js";
import {
  convertDeviceListStateToFilters,
  extractErrorMessage,
  filtersFilter,
  getComparisonCompatibleVersion,
  mapDeviceAttributes,
  mapFiltersToTerms,
  mapTermsToFilters,
  mergePermissions,
  parseSubscriptionPreview,
  progress
} from "./chunk-UE5N5VO3.js";
import {
  ALL_DEVICE_STATES,
  ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE,
  DEPLOYMENT_ROUTES,
  DEPLOYMENT_STATES,
  DEPLOYMENT_TYPES,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  DEVICE_STATES,
  EXTERNAL_PROVIDER,
  MAX_PAGE_SIZE,
  OWN_USER_ID,
  PermissionTypes,
  READ_STATES,
  SORTING_OPTIONS,
  SSO_TYPES,
  TENANT_LIST_DEFAULT,
  TIMEOUTS,
  UNGROUPED_GROUP,
  USER_LOGOUT,
  apiRoot,
  auditLogsApiUrl,
  defaultPermissionSets,
  deploymentPrototype,
  deploymentsApiUrl,
  deploymentsApiUrlV2,
  deviceAuthV2,
  deviceConfig,
  deviceConnect,
  emptyFilter,
  emptyRole,
  emptyUiPermissions,
  headerNames,
  inventoryApiUrl,
  inventoryApiUrlV2,
  iotManagerBaseURL,
  itemUiPermissionsReducer,
  maxSessionAge,
  rolesById,
  scopedPermissionAreas,
  settingsKeys,
  ssoIdpApiUrlv1,
  tenantadmApiUrlv1,
  tenantadmApiUrlv2,
  twoFAStates,
  uiPermissionsByArea,
  uiPermissionsById,
  useradmApiUrl,
  useradmApiUrlv2
} from "./chunk-7C4SQBEE.js";
import {
  rootfsImageVersion
} from "./chunk-2DYA3X77.js";
import {
  onboardingSteps,
  orderedOnboardingSteps
} from "./chunk-FAJ3I2UQ.js";
import {
  PLANS,
  locations
} from "./chunk-HFOTAPIJ.js";

// src/appSlice/thunks.ts
import { deepCompare as deepCompare4, extractErrorMessage as extractErrorMessage3 } from "@northern.tech/utils/helpers";
import Cookies4 from "universal-cookie";

// src/deploymentsSlice/thunks.ts
import { customSort, deepCompare, isEmpty, standardizePhases } from "@northern.tech/utils/helpers";
import Tracking from "@northern.tech/utils/tracking";
import validator from "validator";
var { isUUID } = validator;
var { receivedDevice, setSnackbar } = actions_default;
var { page: defaultPage, perPage: defaultPerPage } = DEVICE_LIST_DEFAULTS;
var deriveDeploymentGroup = ({ filter, group, groups = [], name }) => group || groups.length === 1 && !isUUID(name) ? groups[0] : filter?.name;
var transformDeployments = (deployments, deploymentsById) => deployments.sort(customSort(true, "created")).reduce(
  (accu, item) => {
    const filter = item.filter;
    let deployment = {
      ...deploymentPrototype,
      ...deploymentsById[item.id],
      ...item,
      filter: filter ? { ...filter, name: filter.name ?? filter.id, filters: mapTermsToFilters(filter.terms) } : void 0,
      name: decodeURIComponent(item.name)
    };
    deployment = { ...deployment, group: deriveDeploymentGroup(deployment) };
    accu.deployments[item.id] = deployment;
    accu.deploymentIds.push(item.id);
    return accu;
  },
  { deployments: {}, deploymentIds: [] }
);
var getDeploymentsByStatus2 = createAppAsyncThunk(
  `${sliceName2}/getDeploymentsByStatus`,
  (options, { dispatch, getState }) => {
    const { status, page = defaultPage, perPage = defaultPerPage, startDate, endDate, group, type, shouldSelect = true, sort = SORTING_OPTIONS.desc } = options;
    const created_after = startDate ? `&created_after=${startDate}` : "";
    const created_before = endDate ? `&created_before=${endDate}` : "";
    const search = group ? `&search=${group}` : "";
    const typeFilter = type ? `&type=${type}` : "";
    return general_api_default.get(
      `${deploymentsApiUrl}/deployments?status=${status}&per_page=${perPage}&page=${page}${created_after}${created_before}${search}${typeFilter}&sort=${sort}`
    ).then((res) => {
      const { deployments, deploymentIds } = transformDeployments(res.data, getState().deployments.byId);
      const total = Number(res.headers[headerNames.total]);
      let tasks = [
        dispatch(actions2.receivedDeployments(deployments)),
        dispatch(
          actions2.receivedDeploymentsForStatus({
            deploymentIds,
            status,
            total: !(startDate || endDate || group || type) ? total : getState().deployments.byStatus[status].total
          })
        )
      ];
      tasks = deploymentIds.reduce((accu, deploymentId) => {
        if (deployments[deploymentId].type === DEPLOYMENT_TYPES.configuration) {
          accu.push(dispatch(getSingleDeployment(deploymentId)));
        }
        return accu;
      }, tasks);
      if (shouldSelect) {
        tasks.push(dispatch(actions2.selectDeploymentsForStatus({ deploymentIds, status, total })));
      }
      tasks.push({ deploymentIds, total });
      return Promise.all(tasks);
    });
  }
);
var isWithinFirstMonth = (expirationDate) => {
  if (!expirationDate) {
    return false;
  }
  const endOfFirstMonth = new Date(expirationDate);
  endOfFirstMonth.setMonth(endOfFirstMonth.getMonth() - 11);
  return endOfFirstMonth > /* @__PURE__ */ new Date();
};
var trackDeploymentCreation = (totalDeploymentCount, hasDeployments, trial_expiration) => {
  Tracking.event({ category: "deployments", action: "create" });
  if (!totalDeploymentCount) {
    if (!hasDeployments) {
      Tracking.event({ category: "deployments", action: "create_initial_deployment" });
      if (isWithinFirstMonth(trial_expiration)) {
        Tracking.event({ category: "deployments", action: "create_initial_deployment_first_month" });
      }
    }
    Tracking.event({ category: "deployments", action: "create_initial_deployment_user" });
  }
};
var MAX_PREVIOUS_PHASES_COUNT = 5;
var createDeployment = createAppAsyncThunk(
  `${sliceName2}/createDeployment`,
  ({
    newDeployment,
    hasNewRetryDefault = false
  }, { dispatch, getState }) => {
    let request;
    if ("filter_id" in newDeployment && newDeployment.filter_id) {
      request = general_api_default.post(`${deploymentsApiUrlV2}/deployments`, newDeployment);
    } else if ("group" in newDeployment && newDeployment.group) {
      request = general_api_default.post(`${deploymentsApiUrl}/deployments/group/${newDeployment.group}`, newDeployment);
    } else {
      request = general_api_default.post(`${deploymentsApiUrl}/deployments`, newDeployment);
    }
    const totalDeploymentCount = Object.values(getDeploymentsByStatus(getState())).reduce(
      (accu, item) => accu + item.total,
      0
    );
    const { hasDeployments } = getGlobalSettings(getState());
    const { trial_expiration } = getOrganization(getState());
    return request.catch((err) => commonErrorHandler(err, "Error creating deployment.", dispatch)).then((data) => {
      const lastslashindex = data.headers.location.lastIndexOf("/");
      const deploymentId = data.headers.location.substring(lastslashindex + 1);
      const deployment = {
        ...newDeployment,
        id: deploymentId,
        devices: "devices" in newDeployment && newDeployment.devices ? newDeployment.devices.map((id) => ({ id, status: "pending" })) : [],
        statistics: { status: {} }
      };
      const tasks = [
        dispatch(actions2.createdDeployment(deployment)),
        dispatch(getSingleDeployment(deploymentId)),
        dispatch(setSnackbar({ message: "Deployment created successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))
      ];
      trackDeploymentCreation(totalDeploymentCount, hasDeployments, trial_expiration);
      const { canManageUsers } = getUserCapabilities(getState());
      if (canManageUsers) {
        const { phases, retries } = newDeployment;
        const { previousPhases = [], retries: previousRetries = 0 } = getGlobalSettings(getState());
        const newSettings = { retries: hasNewRetryDefault ? retries : previousRetries, hasDeployments: true };
        if (phases) {
          const standardPhases = standardizePhases(phases);
          const prevPhases = previousPhases.map(standardizePhases);
          if (!prevPhases.find((previousPhaseList) => previousPhaseList.every((oldPhase) => standardPhases.find((phase) => deepCompare(phase, oldPhase))))) {
            prevPhases.push(standardPhases);
          }
          newSettings.previousPhases = prevPhases.slice(-1 * MAX_PREVIOUS_PHASES_COUNT);
        }
        tasks.push(dispatch(saveGlobalSettings(newSettings)));
      }
      return Promise.all(tasks);
    });
  }
);
var getDeploymentDevices = createAppAsyncThunk(
  `${sliceName2}/getDeploymentDevices`,
  (options, { dispatch, getState }) => {
    const { id, page = defaultPage, perPage = defaultPerPage } = options;
    return general_api_default.get(`${deploymentsApiUrl}/deployments/${id}/devices/list?&page=${page}&per_page=${perPage}`).then((response) => {
      const { devices: deploymentDevices = {} } = getState().deployments.byId[id] || {};
      const devices = response.data.reduce((accu, item) => {
        accu[item.id] = item;
        const log = (deploymentDevices[item.id] || {}).log;
        if (log) {
          accu[item.id].log = log;
        }
        return accu;
      }, {});
      const selectedDeviceIds = Object.keys(devices);
      let tasks = [
        dispatch(
          actions2.receivedDeploymentDevices({
            id,
            devices,
            selectedDeviceIds,
            totalDeviceCount: Number(response.headers[headerNames.total])
          })
        )
      ];
      const devicesById = getDevicesById(getState());
      const lackingData = selectedDeviceIds.reduce((accu, deviceId) => {
        const device = devicesById[deviceId];
        if (!device || !device.identity_data || !device.attributes || Object.keys(device.attributes).length === 0) {
          accu.push(deviceId);
        }
        return accu;
      }, []);
      tasks = lackingData.reduce((accu, deviceId) => [...accu, dispatch(getDeviceById2(deviceId)), dispatch(getDeviceAuth(deviceId))], tasks);
      return Promise.all(tasks);
    });
  }
);
var parseDeviceDeployment = ({
  deployment: { id, artifact_name: release, status: deploymentStatus },
  device: { created, deleted, id: deviceId, finished, status, log }
}) => ({
  id,
  release,
  created,
  deleted,
  deviceId,
  finished,
  status,
  log,
  route: Object.values(DEPLOYMENT_ROUTES).reduce((accu, { key, states }) => {
    if (!accu) {
      return states.includes(deploymentStatus) ? key : accu;
    }
    return accu;
  }, "")
});
var getDeviceDeployments = createAppAsyncThunk(`${sliceName2}/getDeviceDeployments`, (options, { dispatch }) => {
  const { deviceId, filterSelection = [], page = defaultPage, perPage = defaultPerPage } = options;
  const filters = filterSelection.map((item) => `&status=${item}`).join("");
  return general_api_default.get(`${deploymentsApiUrl}/deployments/devices/${deviceId}?page=${page}&per_page=${perPage}${filters}`).then(
    ({ data, headers }) => Promise.resolve(
      dispatch(
        receivedDevice({
          id: deviceId,
          deviceDeployments: data.map(parseDeviceDeployment),
          deploymentsCount: Number(headers[headerNames.total])
        })
      )
    )
  ).catch((err) => commonErrorHandler(err, "There was an error retrieving the device deployment history:", dispatch));
});
var resetDeviceDeployments = createAppAsyncThunk(
  `${sliceName2}/resetDeviceDeployments`,
  (deviceId, { dispatch }) => general_api_default.delete(`${deploymentsApiUrl}/deployments/devices/${deviceId}/history`).then(() => Promise.resolve(dispatch(getDeviceDeployments({ deviceId })))).catch((err) => commonErrorHandler(err, "There was an error resetting the device deployment history:", dispatch))
);
var getSingleDeployment = createAppAsyncThunk(
  `${sliceName2}/getSingleDeployment`,
  (id, { dispatch, getState }) => general_api_default.get(`${deploymentsApiUrl}/deployments/${id}`).then(({ data }) => {
    const { deployments } = transformDeployments([data], getState().deployments.byId);
    return Promise.resolve(dispatch(actions2.receivedDeployment(deployments[id])));
  })
);
var getDeviceLog = createAppAsyncThunk(
  `${sliceName2}/getDeviceLog`,
  ({ deploymentId, deviceId }, { dispatch }) => general_api_default.get(`${deploymentsApiUrl}/deployments/${deploymentId}/devices/${deviceId}/log`).catch((e) => {
    console.log("no log here", e);
    return Promise.reject();
  }).then(
    ({ data: log }) => Promise.all([Promise.resolve(dispatch(actions2.receivedDeploymentDeviceLog({ id: deploymentId, deviceId, log }))), Promise.resolve(log)])
  )
);
var abortDeployment = createAppAsyncThunk(
  `${sliceName2}/abortDeployment`,
  (deploymentId, { dispatch, getState }) => general_api_default.put(`${deploymentsApiUrl}/deployments/${deploymentId}/status`, { status: "aborted" }).then(() => {
    const deploymentsByStatus = getDeploymentsByStatus(getState());
    let status = DEPLOYMENT_STATES.pending;
    let index = deploymentsByStatus.pending.deploymentIds.findIndex((id) => id === deploymentId);
    if (index < 0) {
      status = DEPLOYMENT_STATES.inprogress;
      index = deploymentsByStatus.inprogress.deploymentIds.findIndex((id) => id === deploymentId);
    }
    const deploymentIds = [...deploymentsByStatus[status].deploymentIds.slice(0, index), ...deploymentsByStatus[status].deploymentIds.slice(index + 1)];
    const deploymentsById = getDeploymentsById(getState());
    const deployments = deploymentIds.reduce((accu, id) => {
      accu[id] = deploymentsById[id];
      return accu;
    }, {});
    const total = Math.max(deploymentsByStatus[status].total - 1, 0);
    return Promise.all([
      dispatch(actions2.receivedDeployments(deployments)),
      dispatch(actions2.receivedDeploymentsForStatus({ deploymentIds, status, total })),
      dispatch(actions2.removedDeployment(deploymentId)),
      dispatch(setSnackbar("The deployment was successfully aborted"))
    ]);
  }).catch((err) => commonErrorHandler(err, "There was an error while aborting the deployment:", dispatch))
);
var updateDeploymentControlMap = createAppAsyncThunk(
  `${sliceName2}/updateDeploymentControlMap`,
  ({ deploymentId, updateControlMap }, { dispatch }) => general_api_default.patch(`${deploymentsApiUrl}/deployments/${deploymentId}`, { update_control_map: updateControlMap }).catch((err) => commonErrorHandler(err, "There was an error while updating the deployment status:", dispatch)).then(() => Promise.resolve(dispatch(getSingleDeployment(deploymentId))))
);
var setDeploymentsState = createAppAsyncThunk(`${sliceName2}/setDeploymentsState`, (selection, { dispatch, getState }) => {
  const { page, perPage, ...selectionState } = selection;
  const currentState = getState().deployments.selectionState;
  const nextState = {
    ...currentState,
    ...selectionState,
    ...Object.keys(DEPLOYMENT_STATES).reduce((accu, item) => {
      accu[item] = {
        ...currentState[item],
        ...selectionState[item]
      };
      return accu;
    }, {}),
    general: {
      ...currentState.general,
      ...selectionState.general
    }
  };
  const tasks = [dispatch(actions2.setDeploymentsState(nextState))];
  if (nextState.selectedId && currentState.selectedId !== nextState.selectedId) {
    tasks.push(dispatch(getSingleDeployment(nextState.selectedId)));
  }
  return Promise.all(tasks);
});
var deltaAttributeMappings = [
  { here: "compressionLevel", there: "compression_level" },
  { here: "disableChecksum", there: "disable_checksum" },
  { here: "disableDecompression", there: "disable_external_decompression" },
  { here: "sourceWindow", there: "source_window_size" },
  { here: "inputWindow", there: "input_window_size" },
  { here: "duplicatesWindow", there: "compression_duplicates_window" },
  { here: "instructionBuffer", there: "instruction_buffer_size" }
];
var mapExternalDeltaConfig = (config = {}) => deltaAttributeMappings.reduce((accu, { here, there }) => {
  if (config[there] !== void 0) {
    accu[here] = config[there];
  }
  return accu;
}, {});
var getDeploymentsConfig = createAppAsyncThunk(
  `${sliceName2}/getDeploymentsConfig`,
  (_, { dispatch, getState }) => general_api_default.get(`${deploymentsApiUrl}/config`).then(({ data }) => {
    const oldConfig = getState().deployments.config;
    const { delta = {} } = data;
    const { binary_delta = {}, binary_delta_limits = {} } = delta;
    const { xdelta_args = {} } = binary_delta;
    const { xdelta_args_limits = {} } = binary_delta_limits;
    const config = {
      ...oldConfig,
      hasDelta: Boolean(delta.enabled),
      binaryDelta: {
        ...oldConfig.binaryDelta,
        ...mapExternalDeltaConfig(xdelta_args)
      },
      binaryDeltaLimits: {
        ...oldConfig.binaryDeltaLimits,
        ...mapExternalDeltaConfig(xdelta_args_limits)
      }
    };
    return Promise.resolve(dispatch(actions2.setDeploymentsConfig(config)));
  })
);
var deepClean = (source) => Object.entries(source).reduce((accu, [key, value]) => {
  if (value !== void 0) {
    const cleanedValue = typeof value === "object" ? deepClean(value) : value;
    if (cleanedValue === void 0 || typeof cleanedValue === "object" && isEmpty(cleanedValue)) {
      return accu;
    }
    accu = { ...accu ?? {}, [key]: cleanedValue };
  }
  return accu;
}, void 0);
var saveDeltaDeploymentsConfig = createAppAsyncThunk(
  `${sliceName2}/saveDeltaDeploymentsConfig`,
  (config, { dispatch, getState }) => {
    const configChange = {
      xdelta_args: deltaAttributeMappings.reduce((accu, { here, there }) => {
        if (config[here] !== void 0) {
          accu[there] = config[here];
        }
        return accu;
      }, {})
    };
    const result = deepClean(configChange);
    if (!result) {
      return Promise.resolve();
    }
    return general_api_default.put(`${deploymentsApiUrl}/config/binary_delta`, result).catch((err) => commonErrorHandler(err, "There was a problem storing your delta artifact generation configuration.", dispatch)).then(() => {
      const oldConfig = getState().deployments.config;
      const newConfig = {
        ...oldConfig,
        binaryDelta: {
          ...oldConfig.binaryDelta,
          ...config
        }
      };
      return Promise.all([dispatch(actions2.setDeploymentsConfig(newConfig)), dispatch(setSnackbar("Settings saved successfully"))]);
    });
  }
);

// src/devicesSlice/thunks.tsx
import { Link } from "react-router-dom";
import { attributeDuplicateFilter, dateRangeToUnix, deepCompare as deepCompare2, getSnackbarMessage } from "@northern.tech/utils/helpers";
import { isCancel } from "axios";
import pluralize from "pluralize";
import { v4 as uuid } from "uuid";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var { cleanUpUpload, initUpload, setSnackbar: setSnackbar2, uploadProgress } = actions_default;
var { page: defaultPage2, perPage: defaultPerPage2 } = DEVICE_LIST_DEFAULTS;
var defaultAttributes = [
  { scope: "identity", attribute: "status" },
  { scope: "inventory", attribute: "artifact_name" },
  { scope: "inventory", attribute: "device_type" },
  { scope: "inventory", attribute: "mender_is_gateway" },
  { scope: "inventory", attribute: "mender_gateway_system_id" },
  { scope: "inventory", attribute: rootfsImageVersion },
  { scope: "monitor", attribute: "alerts" },
  { scope: "system", attribute: "created_ts" },
  { scope: "system", attribute: "updated_ts" },
  { scope: "system", attribute: "check_in_time" },
  { scope: "system", attribute: "group" },
  { scope: "tags", attribute: "name" }
];
var getGroups = createAppAsyncThunk(
  `${sliceName3}/getGroups`,
  (_, { dispatch, getState }) => general_api_default.get(`${inventoryApiUrl}/groups`).then((res) => {
    const state = getGroupsById(getState());
    const dynamicGroups = Object.entries(state).reduce((accu, [id, group]) => {
      if (group.id || group.filters?.length && id !== UNGROUPED_GROUP.id) {
        accu[id] = group;
      }
      return accu;
    }, {});
    const groups = res.data.reduce((accu, group) => {
      accu[group] = { deviceIds: [], filters: [], total: 0, ...state[group] };
      return accu;
    }, dynamicGroups);
    const filters = [{ key: "group", value: res.data, operator: DEVICE_FILTERING_OPTIONS.$nin.key, scope: "system" }];
    return Promise.all([
      dispatch(actions3.receivedGroups(groups)),
      dispatch(getDevicesByStatus({ filterSelection: filters, group: "", page: 1, perPage: 1, status: void 0 }))
    ]).then((promises) => {
      const devicesRetrieval = promises[promises.length - 1] || [];
      const { payload } = devicesRetrieval || {};
      const result = payload[payload.length - 1] || {};
      if (!result.total) {
        return Promise.resolve();
      }
      return Promise.resolve(
        dispatch(
          actions3.addGroup({
            groupName: UNGROUPED_GROUP.id,
            group: { filters: [{ key: "group", value: res.data, operator: DEVICE_FILTERING_OPTIONS.$nin.key, scope: "system" }] }
          })
        )
      );
    });
  })
);
var addDevicesToGroup = createAppAsyncThunk(
  `${sliceName3}/addDevicesToGroup`,
  ({ group, deviceIds, isCreation }, { dispatch }) => general_api_default.patch(`${inventoryApiUrl}/groups/${group}/devices`, deviceIds).then(() => dispatch(actions3.addToGroup({ group, deviceIds }))).finally(() => isCreation ? Promise.resolve(dispatch(getGroups())) : {})
);
var removeDevicesFromGroup = createAppAsyncThunk(
  `${sliceName3}/removeDevicesFromGroup`,
  ({ group, deviceIds }, { dispatch }) => general_api_default.delete(`${inventoryApiUrl}/groups/${group}/devices`, deviceIds).then(
    () => Promise.all([
      dispatch(actions3.removeFromGroup({ group, deviceIds })),
      dispatch(
        setSnackbar2({
          message: `The ${pluralize("devices", deviceIds.length)} ${pluralize("were", deviceIds.length)} removed from the group`,
          autoHideDuration: TIMEOUTS.fiveSeconds
        })
      )
    ])
  )
);
var getGroupNotification = (newGroup, selectedGroup) => {
  const successMessage2 = "The group was updated successfully";
  if (newGroup === selectedGroup) {
    return { message: successMessage2, autoHideDuration: TIMEOUTS.fiveSeconds };
  }
  return {
    action: "",
    autoHideDuration: TIMEOUTS.fiveSeconds,
    message: /* @__PURE__ */ jsxs(Fragment, { children: [
      successMessage2,
      " - ",
      /* @__PURE__ */ jsx(Link, { to: `/devices?inventory=group:eq:${newGroup}`, children: "click here" }),
      " to see it."
    ] }),
    preventClickToCopy: true
  };
};
var addStaticGroup = createAppAsyncThunk(
  `${sliceName3}/addStaticGroup`,
  ({ group, devices }, { dispatch, getState }) => Promise.resolve(dispatch(addDevicesToGroup({ group, deviceIds: devices.map(({ id }) => id), isCreation: true }))).then(
    () => Promise.resolve(
      dispatch(
        actions3.addGroup({
          group: { deviceIds: [], total: 0, filters: [], ...getState().devices.groups.byId[group] },
          groupName: group
        })
      )
    ).then(
      () => Promise.all([
        dispatch(setDeviceListState({ setOnly: true })),
        dispatch(getGroups()),
        dispatch(setSnackbar2(getGroupNotification(group, getState().devices.groups.selectedGroup)))
      ])
    )
  ).catch((err) => commonErrorHandler(err, `Group could not be updated:`, dispatch))
);
var removeStaticGroup = createAppAsyncThunk(
  `${sliceName3}/removeStaticGroup`,
  (groupName, { dispatch }) => general_api_default.delete(`${inventoryApiUrl}/groups/${groupName}`).then(
    () => Promise.all([
      dispatch(actions3.removeGroup(groupName)),
      dispatch(getGroups()),
      dispatch(setSnackbar2({ message: "Group was removed successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))
    ])
  )
);
var getDynamicGroups = createAppAsyncThunk(
  `${sliceName3}/getDynamicGroups`,
  (_, { dispatch, getState }) => general_api_default.get(`${inventoryApiUrlV2}/filters?per_page=${MAX_PAGE_SIZE}`).then(({ data: filters }) => {
    const state = getGroupsById(getState());
    const staticGroups = Object.entries(state).reduce((accu, [id, group]) => {
      if (!(group.id || group.filters?.length)) {
        accu[id] = group;
      }
      return accu;
    }, {});
    const groups = (filters || []).reduce((accu, filter) => {
      accu[filter.name] = {
        deviceIds: [],
        total: 0,
        ...state[filter.name],
        id: filter.id,
        filters: mapTermsToFilters(filter.terms)
      };
      return accu;
    }, staticGroups);
    return Promise.resolve(dispatch(actions3.receivedGroups(groups)));
  }).catch(() => console.log("Dynamic group retrieval failed - likely accessing a non-enterprise backend"))
);
var addDynamicGroup = createAppAsyncThunk(
  `${sliceName3}/addDynamicGroup`,
  ({ groupName, filterPredicates }, { dispatch, getState }) => general_api_default.post(`${inventoryApiUrlV2}/filters`, { name: groupName, terms: mapFiltersToTerms(filterPredicates) }).then(
    (res) => Promise.resolve(
      dispatch(
        actions3.addGroup({
          groupName,
          group: {
            id: res.headers[headerNames.location].substring(res.headers[headerNames.location].lastIndexOf("/") + 1),
            filters: filterPredicates
          }
        })
      )
    ).then(() => {
      const { cleanedFilters } = getGroupFilters(groupName, getState().devices.groups);
      return Promise.all([
        dispatch(actions3.setDeviceFilters(cleanedFilters)),
        dispatch(setSnackbar2(getGroupNotification(groupName, getState().devices.groups.selectedGroup))),
        dispatch(getDynamicGroups())
      ]);
    })
  ).catch((err) => commonErrorHandler(err, `Group could not be updated:`, dispatch))
);
var updateDynamicGroup = createAppAsyncThunk(
  `${sliceName3}/updateDynamicGroup`,
  ({ groupName, filterPredicates }, { dispatch, getState }) => {
    const filterId = getState().devices.groups.byId[groupName].id;
    return general_api_default.delete(`${inventoryApiUrlV2}/filters/${filterId}`).then(
      () => Promise.resolve(dispatch(addDynamicGroup({ groupName, filterPredicates })))
    );
  }
);
var removeDynamicGroup = createAppAsyncThunk(`${sliceName3}/removeDynamicGroup`, (groupName, { dispatch, getState }) => {
  const filterId = getState().devices.groups.byId[groupName].id;
  return general_api_default.delete(`${inventoryApiUrlV2}/filters/${filterId}`).then(
    () => Promise.all([
      dispatch(actions3.removeGroup(groupName)),
      dispatch(setSnackbar2({ message: "Group was removed successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))
    ])
  );
});
var getGroupFilters = (group, groupsState, filters = []) => {
  const groupName = group === UNGROUPED_GROUP.id || group === UNGROUPED_GROUP.name ? UNGROUPED_GROUP.id : group;
  const selectedGroup = groupsState.byId[groupName];
  const groupFilterLength = selectedGroup?.filters?.length || 0;
  const cleanedFilters = groupFilterLength ? [...filters, ...selectedGroup.filters || []].filter(filtersFilter) : filters;
  return { cleanedFilters, groupName, selectedGroup, groupFilterLength };
};
var selectGroup = createAppAsyncThunk(
  `${sliceName3}/selectGroup`,
  ({ group, filters = [] }, { dispatch, getState }) => {
    const { cleanedFilters, groupName, selectedGroup, groupFilterLength } = getGroupFilters(group, getState().devices.groups, filters);
    if (getSelectedGroup(getState()) === groupName && (filters.length === 0 && !groupFilterLength || filters.length === cleanedFilters.length)) {
      return Promise.resolve();
    }
    const tasks = [];
    if (groupFilterLength) {
      tasks.push(dispatch(actions3.setDeviceFilters(cleanedFilters)));
    } else {
      tasks.push(dispatch(actions3.setDeviceFilters(filters)));
      tasks.push(dispatch(getGroupDevices({ group: groupName, perPage: 1, shouldIncludeAllStates: true })));
    }
    const selectedGroupName = selectedGroup || !Object.keys(getGroupsById(getState())).length ? groupName : void 0;
    tasks.push(dispatch(actions3.selectGroup(selectedGroupName)));
    return Promise.all(tasks);
  }
);
var getEarliestTs = (dateA = "", dateB = "") => !dateA || !dateB ? dateA || dateB : dateA < dateB ? dateA : dateB;
var reduceReceivedDevices = (devices, ids, state, status) => devices.reduce(
  (accu, device) => {
    const stateDevice = getDeviceById(state, device.id);
    const {
      attributes: storedAttributes = {},
      identity_data: storedIdentity = {},
      monitor: storedMonitor = {},
      tags: storedTags = {},
      group: storedGroup
    } = stateDevice;
    const { identity, inventory, monitor, system = {}, tags } = mapDeviceAttributes(device.attributes);
    device.tags = { ...storedTags, ...tags };
    device.group = system.group ?? storedGroup;
    device.monitor = { ...storedMonitor, ...monitor };
    device.identity_data = { ...storedIdentity, ...identity, ...device.identity_data ? device.identity_data : {} };
    device.status = status ? status : device.status || identity.status;
    device.check_in_time_rounded = system.check_in_time ?? stateDevice.check_in_time_rounded;
    device.check_in_time_exact = device.check_in_time ?? stateDevice.check_in_time_exact;
    device.created_ts = getEarliestTs(getEarliestTs(system.created_ts, device.created_ts), stateDevice.created_ts);
    device.updated_ts = device.attributes ? device.updated_ts : stateDevice.updated_ts;
    device.isNew = new Date(device.created_ts) > new Date(state.app.newThreshold);
    device.isOffline = new Date(device.check_in_time_rounded) < new Date(state.app.offlineThreshold) || device.check_in_time_rounded === void 0;
    device.attributes = device.attributes ? { ...storedAttributes, ...inventory } : storedAttributes;
    accu.devicesById[device.id] = { ...stateDevice, ...device };
    accu.ids.push(device.id);
    return accu;
  },
  { ids, devicesById: {} }
);
var getGroupDevices = createAppAsyncThunk(`${sliceName3}/getGroupDevices`, (options, { dispatch, getState }) => {
  const { group, shouldIncludeAllStates, ...remainder } = options;
  const { cleanedFilters: filterSelection } = getGroupFilters(group, getState().devices.groups);
  return dispatch(
    getDevicesByStatus({
      ...remainder,
      filterSelection,
      group,
      status: shouldIncludeAllStates ? void 0 : DEVICE_STATES.accepted
    })
  ).unwrap().then((results) => {
    if (!group) {
      return Promise.resolve();
    }
    const { deviceAccu, total } = results[results.length - 1];
    const stateGroup = getState().devices.groups.byId[group];
    if (!stateGroup && !total && !deviceAccu.ids.length) {
      return Promise.resolve();
    }
    return Promise.resolve(
      dispatch(
        actions3.addGroup({
          group: {
            deviceIds: deviceAccu.ids.length === total || stateGroup && stateGroup.deviceIds && deviceAccu.ids.length > stateGroup.deviceIds ? deviceAccu.ids : stateGroup.deviceIds,
            total
          },
          groupName: group
        })
      )
    );
  });
});
var getAllGroupDevices = createAppAsyncThunk(
  `${sliceName3}/getAllGroupDevices`,
  ({ group, attribute }, { dispatch, getState }) => {
    if (!group || !!group && (!getGroupsById(getState())[group] || getGroupsById(getState())[group].filters.length)) {
      return Promise.resolve();
    }
    const { attributes, filterTerms } = prepareSearchArguments({
      filters: [],
      group,
      state: getState(),
      status: DEVICE_STATES.accepted
    });
    const getAllDevices = (perPage = MAX_PAGE_SIZE, page = defaultPage2, devices = []) => general_api_default.post(getSearchEndpoint(getState()), {
      page,
      per_page: perPage,
      filters: filterTerms,
      attributes: [...attributes, { scope: "inventory", attribute }]
    }).then((res) => {
      const state = getState();
      const deviceAccu = reduceReceivedDevices(res.data, devices, state);
      dispatch(actions3.receivedDevices(deviceAccu.devicesById));
      const total = Number(res.headers[headerNames.total]);
      if (total > perPage * page) {
        return getAllDevices(perPage, page + 1, deviceAccu.ids);
      }
      return Promise.resolve(dispatch(actions3.addGroup({ group: { deviceIds: deviceAccu.ids, total: deviceAccu.ids.length }, groupName: group })));
    });
    return getAllDevices();
  }
);
var getAllDynamicGroupDevices = createAppAsyncThunk(
  `${sliceName3}/getAllDynamicGroupDevices`,
  ({ group, attribute }, { dispatch, getState }) => {
    if (!!group && (!getGroupsById(getState())[group] || !getGroupsById(getState())[group].filters.length)) {
      return Promise.resolve();
    }
    const { attributes, filterTerms: filters } = prepareSearchArguments({
      filters: getState().devices.groups.byId[group].filters,
      state: getState(),
      status: DEVICE_STATES.accepted
    });
    const getAllDevices = (perPage = MAX_PAGE_SIZE, page = defaultPage2, devices = []) => general_api_default.post(getSearchEndpoint(getState()), { page, per_page: perPage, filters, attributes: [...attributes, { scope: "inventory", attribute }] }).then(
      (res) => {
        const state = getState();
        const deviceAccu = reduceReceivedDevices(res.data, devices, state);
        dispatch(actions3.receivedDevices(deviceAccu.devicesById));
        const total = Number(res.headers[headerNames.total]);
        if (total > deviceAccu.ids.length) {
          return getAllDevices(perPage, page + 1, deviceAccu.ids);
        }
        return Promise.resolve(dispatch(actions3.addGroup({ group: { deviceIds: deviceAccu.ids, total }, groupName: group })));
      }
    );
    return getAllDevices();
  }
);
var getDeviceById2 = createAppAsyncThunk(
  `${sliceName3}/getDeviceById`,
  (id, { dispatch, getState }) => general_api_default.get(`${inventoryApiUrl}/devices/${id}`).then((res) => {
    const device = reduceReceivedDevices([res.data], [], getState()).devicesById[id];
    device.etag = res.headers.etag;
    dispatch(actions3.receivedDevice(device));
    return Promise.resolve(device);
  }).catch((err) => {
    const errMsg = extractErrorMessage(err);
    if (errMsg.includes("Not Found")) {
      console.log(`${id} does not have any inventory information`);
      const device = reduceReceivedDevices(
        [
          {
            id,
            attributes: [
              { name: "status", value: "decomissioned", scope: "identity" },
              { name: "decomissioned", value: "true", scope: "inventory" }
            ],
            log: false
          }
        ],
        [],
        getState()
      ).devicesById[id];
      dispatch(actions3.receivedDevice(device));
    }
  })
);
var getDeviceInfo = createAppAsyncThunk(`${sliceName3}/getDeviceInfo`, (deviceId, { dispatch, getState }) => {
  const device = getDeviceById(getState(), deviceId);
  const { hasDeviceConfig, hasDeviceConnect, hasMonitor } = getTenantCapabilities(getState());
  const { canConfigure } = getUserCapabilities(getState());
  const integrations = getDeviceTwinIntegrations(getState());
  const tasks = [
    dispatch(getDeviceAuth(deviceId)),
    dispatch(getDeviceById2(deviceId)),
    ...integrations.map((integration) => dispatch(getDeviceTwin({ deviceId, integration })))
  ];
  if (hasDeviceConfig && canConfigure && (device.status === DEVICE_STATES.accepted || device.status === DEVICE_STATES.preauth)) {
    tasks.push(dispatch(getDeviceConfig(deviceId)));
  }
  if (device.status === DEVICE_STATES.accepted) {
    if (hasDeviceConnect) {
      tasks.push(dispatch(getDeviceConnect(deviceId)));
    }
    if (hasMonitor) {
      tasks.push(dispatch(getLatestDeviceAlerts({ id: deviceId })));
      tasks.push(dispatch(getDeviceMonitorConfig(deviceId)));
    }
  }
  return Promise.all(tasks);
});
var getDeviceCount = createAppAsyncThunk(
  `${sliceName3}/getDeviceCount`,
  (status, { dispatch, getState }) => general_api_default.post(getSearchEndpoint(getState()), {
    page: 1,
    per_page: 1,
    filters: mapFiltersToTerms([{ key: "status", value: status, operator: DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }]),
    attributes: defaultAttributes
  }).then((response) => {
    const count = Number(response.headers[headerNames.total]);
    return dispatch(actions3.setDevicesCountByStatus({ count, status }));
  })
);
var getAllDeviceCounts = createAppAsyncThunk(
  `${sliceName3}/getAllDeviceCounts`,
  (_, { dispatch }) => Promise.all([DEVICE_STATES.accepted, DEVICE_STATES.pending].map((status) => dispatch(getDeviceCount(status))))
);
var getDeviceLimit = createAppAsyncThunk(
  `${sliceName3}/getDeviceLimit`,
  (_, { dispatch }) => general_api_default.get(`${deviceAuthV2}/limits/max_devices`).then((res) => dispatch(actions3.setDeviceLimit(res.data.limit)))
);
var setDeviceListState = createAppAsyncThunk(
  `${sliceName3}/setDeviceListState`,
  ({ shouldSelectDevices = true, forceRefresh, fetchAuth = true, ...selectionState }, { dispatch, getState }) => {
    const currentState = getDeviceListState(getState());
    const refreshTrigger = forceRefresh ? !currentState.refreshTrigger : selectionState.refreshTrigger;
    const nextState = {
      ...currentState,
      setOnly: false,
      refreshTrigger,
      ...selectionState,
      sort: { ...currentState.sort, ...selectionState.sort }
    };
    const tasks = [];
    const { isLoading: currentLoading, deviceIds: currentDevices, selection: currentSelection, ...currentRequestState } = currentState;
    const { isLoading: nextLoading, deviceIds: nextDevices, selection: nextSelection, ...nextRequestState } = nextState;
    if (!nextState.setOnly && !deepCompare2(currentRequestState, nextRequestState)) {
      const { direction: sortDown = SORTING_OPTIONS.desc, key: sortCol, scope: sortScope = "" } = nextState.sort ?? {};
      const sortBy = sortCol ? [{ attribute: sortCol, order: sortDown, scope: sortScope }] : void 0;
      const applicableSelectedState = nextState.state === ALL_DEVICE_STATES ? void 0 : nextState.state;
      nextState.isLoading = true;
      tasks.push(
        dispatch(getDevicesByStatus({ ...nextState, status: applicableSelectedState, sortOptions: sortBy, fetchAuth })).unwrap().then((results) => {
          const { deviceAccu, total } = results[results.length - 1];
          const devicesState = shouldSelectDevices ? { deviceIds: deviceAccu.ids, total, isLoading: false } : { isLoading: false };
          return Promise.resolve(dispatch(actions3.setDeviceListState(devicesState)));
        }).catch(() => Promise.resolve({ isLoading: false }))
      );
    }
    tasks.push(dispatch(actions3.setDeviceListState(nextState)));
    return Promise.all(tasks);
  }
);
var getDevicesByStatus = createAppAsyncThunk(
  `${sliceName3}/getDevicesByStatus`,
  (options, { dispatch, getState }) => {
    const {
      status,
      fetchAuth = true,
      filterSelection,
      group,
      selectedIssues = [],
      page = defaultPage2,
      perPage = defaultPerPage2,
      sortOptions = [],
      selectedAttributes = getSelectedDeviceAttribute(getState())
    } = options;
    const state = getState();
    const { applicableFilters, filterTerms } = convertDeviceListStateToFilters({
      filters: filterSelection ?? getDeviceFilters(state),
      group: group ?? getSelectedGroup(state),
      groups: state.devices.groups,
      offlineThreshold: state.app.offlineThreshold,
      selectedIssues,
      status
    });
    const attributes = [...defaultAttributes, getIdAttribute(getState()), ...selectedAttributes];
    return general_api_default.post(getSearchEndpoint(getState()), {
      page,
      per_page: perPage,
      filters: filterTerms,
      sort: sortOptions,
      attributes
    }).then((response) => {
      const state2 = getState();
      const deviceAccu = reduceReceivedDevices(response.data, [], state2, status);
      let total = !applicableFilters.length ? Number(response.headers[headerNames.total]) : 0;
      if (status && state2.devices.byStatus[status].total === deviceAccu.ids.length) {
        total = deviceAccu.ids.length;
      }
      const tasks = [dispatch(actions3.receivedDevices(deviceAccu.devicesById))];
      if (status) {
        tasks.push(dispatch(actions3.setDevicesByStatus({ deviceIds: deviceAccu.ids, status, total })));
      }
      const receivedDevices = Object.values(deviceAccu.devicesById);
      if (receivedDevices.length && fetchAuth) {
        tasks.push(dispatch(getDevicesWithAuth(receivedDevices)));
      }
      tasks.push(Promise.resolve({ deviceAccu, total: Number(response.headers[headerNames.total]) }));
      return Promise.all(tasks);
    }).catch((err) => commonErrorHandler(err, `${status} devices couldn't be loaded.`, dispatch, commonErrorFallback));
  }
);
var getAllDevicesByStatus = createAppAsyncThunk(
  `${sliceName3}/getAllDevicesByStatus`,
  ({ status, attribute }, { dispatch, getState }) => {
    const attributes = [...defaultAttributes, getIdAttribute(getState())];
    const getAllDevices = (perPage = MAX_PAGE_SIZE, page = 1, devices = []) => general_api_default.post(getSearchEndpoint(getState()), {
      page,
      per_page: perPage,
      filters: mapFiltersToTerms([{ key: "status", value: status, operator: DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }]),
      attributes: [...attributes, { scope: "inventory", attribute }]
    }).then((res) => {
      const state = getState();
      const deviceAccu = reduceReceivedDevices(res.data, devices, state, status);
      dispatch(actions3.receivedDevices(deviceAccu.devicesById));
      const total = Number(res.headers[headerNames.total]);
      if (total > state.deployments.deploymentDeviceLimit) {
        return Promise.resolve();
      }
      if (total > perPage * page) {
        return getAllDevices(perPage, page + 1, deviceAccu.ids);
      }
      return Promise.resolve();
    });
    return getAllDevices();
  }
);
var searchDevices = createAppAsyncThunk(`${sliceName3}/searchDevices`, (passedOptions = {}, { dispatch, getState }) => {
  const state = getState();
  const options = { ...state.app.searchState, ...passedOptions };
  const { page = defaultPage2, searchTerm, sortOptions = [] } = options;
  const { columnSelection = [] } = getUserSettings(state);
  const selectedAttributes = columnSelection.map((column) => ({ attribute: column.key, scope: column.scope }));
  const attributes = attributeDuplicateFilter([...defaultAttributes, getIdAttribute(state), ...selectedAttributes], "attribute");
  return general_api_default.post(getSearchEndpoint(getState()), {
    page,
    per_page: 10,
    filters: [],
    sort: sortOptions,
    text: searchTerm,
    attributes
  }).then((response) => {
    const deviceAccu = reduceReceivedDevices(response.data, [], getState());
    return Promise.all([
      dispatch(actions3.receivedDevices(deviceAccu.devicesById)),
      Promise.resolve({ deviceIds: deviceAccu.ids, searchTotal: Number(response.headers[headerNames.total]) })
    ]);
  }).catch((err) => commonErrorHandler(err, `devices couldn't be searched.`, dispatch, commonErrorFallback));
});
var ATTRIBUTE_LIST_CUTOFF = 100;
var attributeReducer = (attributes = []) => attributes.slice(0, ATTRIBUTE_LIST_CUTOFF).reduce(
  (accu, { name, scope }) => {
    if (!accu[scope]) {
      accu[scope] = [];
    }
    accu[scope].push(name);
    return accu;
  },
  { identity: [], inventory: [], system: [], tags: [] }
);
var getDeviceAttributes = createAppAsyncThunk(
  `${sliceName3}/getDeviceAttributes`,
  (_, { dispatch, getState }) => general_api_default.get(getAttrsEndpoint(getState())).then(({ data }) => {
    const { identity: identityAttributes, inventory: inventoryAttributes, system: systemAttributes, tags: tagAttributes } = attributeReducer(data || []);
    return dispatch(actions3.setFilterAttributes({ identityAttributes, inventoryAttributes, systemAttributes, tagAttributes }));
  })
);
var initializeDistributionData = (report, groups, devices, totalDeviceCount) => {
  const { attribute, group = "", software = "" } = report;
  const effectiveAttribute = software ? software : attribute;
  const { deviceIds, total = 0 } = groups[group] || {};
  const relevantDevices = deviceIds ? deviceIds.map((id) => devices[id]) : Object.values(devices);
  const distributionByAttribute = relevantDevices.reduce((accu, item) => {
    if (!item.attributes || item.status !== DEVICE_STATES.accepted) return accu;
    const attributeValue = item.attributes[effectiveAttribute];
    if (!accu[attributeValue]) {
      accu[attributeValue] = 0;
    }
    accu[attributeValue] = accu[attributeValue] + 1;
    return accu;
  }, {});
  const distributionByAttributeSorted = Object.entries(distributionByAttribute).sort((pairA, pairB) => pairB[1] - pairA[1]);
  const items = distributionByAttributeSorted.map(([key, count]) => ({ key, count }));
  const dataCount = items.reduce((accu, item) => accu + item.count, 0);
  const otherCount = (groups[group] ? total : totalDeviceCount) - dataCount;
  return { items, otherCount, total: otherCount + dataCount };
};
var updateReportData = createAppAsyncThunk(`${sliceName3}/updateReportData`, (reportIndex, { dispatch, getState }) => {
  const reports = getDeviceReportsForUser(getState());
  const report = reports[reportIndex];
  const { group = "" } = report;
  const devicesById = getDevicesById(getState());
  const groups = getGroupsById(getState());
  const acceptedDevices = getAcceptedDevices(getState());
  const totalDeviceCount = groups[group] ? groups[group].total : acceptedDevices.total;
  const reportsData = getDeviceReports(getState());
  const newReports = [...reportsData];
  newReports[reportIndex] = initializeDistributionData(report, groups, devicesById, totalDeviceCount);
  return Promise.resolve(dispatch(actions3.setDeviceReports(newReports)));
});
var getReportDataWithoutBackendSupport = createAppAsyncThunk(
  `${sliceName3}/getReportDataWithoutBackendSupport`,
  (reportIndex, { dispatch, getState }) => {
    const reports = getDeviceReportsForUser(getState());
    const report = reports[reportIndex];
    if (!report) {
      return;
    }
    const { attribute, group = "", software = "" } = report;
    const effectiveAttribute = software ? software : attribute;
    const devicesById = getDevicesById(getState());
    const acceptedDevices = getAcceptedDevices(getState());
    const groups = getGroupsById(getState());
    const { deviceIds = [], filters = [], total = 0 } = groups[group] || {};
    let groupDevicesRequest = Promise.resolve({
      payload: { groupName: "", group: { deviceIds: Object.keys(devicesById), total: Object.keys(devicesById).length } }
    });
    if (group && (!(deviceIds.length && total) || deviceIds.length !== total || !deviceIds.every((id) => !!devicesById[id]))) {
      groupDevicesRequest = filters.length ? dispatch(getAllDynamicGroupDevices({ group, attribute: effectiveAttribute })).unwrap() : dispatch(getAllGroupDevices({ group, attribute: effectiveAttribute })).unwrap();
    } else if (!group && (acceptedDevices.deviceIds.length !== acceptedDevices.total || !acceptedDevices.deviceIds.every((id) => !!devicesById[id]))) {
      groupDevicesRequest = dispatch(getAllDevicesByStatus({ status: DEVICE_STATES.accepted, attribute: effectiveAttribute })).unwrap();
    }
    return groupDevicesRequest.then(() => dispatch(updateReportData(reportIndex)));
  }
);
var getDeviceConnect = createAppAsyncThunk(
  `${sliceName3}/getDeviceConnect`,
  (id, { dispatch }) => general_api_default.get(`${deviceConnect}/devices/${id}`).then(
    ({ data }) => Promise.all([dispatch(actions3.receivedDevice({ connect_status: data.status, connect_updated_ts: data.updated_ts, id })), Promise.resolve(data)])
  )
);
var updateTypeMap = { deploymentUpdate: "check-update", inventoryUpdate: "send-inventory" };
var triggerDeviceUpdate = createAppAsyncThunk(
  `${sliceName3}/triggerDeviceUpdate`,
  ({ id, type }, { dispatch }) => general_api_default.post(`${deviceConnect}/devices/${id}/${updateTypeMap[type] ?? updateTypeMap.deploymentUpdate}`).then(
    () => new Promise((resolve) => setTimeout(() => resolve(dispatch(getDeviceById2(id))), TIMEOUTS.threeSeconds))
  )
);
var getSessionDetails = createAppAsyncThunk(
  `${sliceName3}/getSessionDetails`,
  ({ sessionId, deviceId, userId, startDate, endDate }) => {
    const { start: startUnix, end: endUnix } = dateRangeToUnix(startDate, endDate);
    const createdAfter = startDate ? `&created_after=${startUnix}` : "";
    const createdBefore = endDate ? `&created_before=${endUnix}` : "";
    const objectSearch = `&object_id=${deviceId}`;
    return general_api_default.get(`${auditLogsApiUrl}/logs?per_page=500${createdAfter}${createdBefore}&actor_id=${userId}${objectSearch}`).then(
      ({ data: auditLogEntries }) => {
        const { start, end } = auditLogEntries.reduce(
          (accu, item) => {
            if (item.meta?.session_id?.includes(sessionId)) {
              accu.start = new Date(item.action.startsWith("open") ? item.time : accu.start);
              accu.end = new Date(item.action.startsWith("close") ? item.time : accu.end);
            }
            return accu;
          },
          { start: startDate || endDate, end: endDate || startDate }
        );
        return Promise.resolve({ start, end });
      }
    );
  }
);
var getDeviceFileDownloadLink = createAppAsyncThunk(
  `${sliceName3}/getDeviceFileDownloadLink`,
  ({ deviceId, path }) => Promise.resolve(`${window.location.origin}${deviceConnect}/devices/${deviceId}/download?path=${encodeURIComponent(path)}`)
);
var deviceFileUpload = createAppAsyncThunk(
  `${sliceName3}/deviceFileUpload`,
  ({ deviceId, path, file }, { dispatch }) => {
    const formData = new FormData();
    formData.append("path", path);
    formData.append("file", file);
    const uploadId = uuid();
    const cancelSource = new AbortController();
    return Promise.all([
      dispatch(setSnackbar2("Uploading file")),
      dispatch(initUpload({ id: uploadId, upload: { progress: 0, cancelSource } })),
      general_api_default.uploadPut(
        `${deviceConnect}/devices/${deviceId}/upload`,
        formData,
        (e) => dispatch(uploadProgress({ id: uploadId, progress: progress(e) })),
        cancelSource.signal
      )
    ]).then(() => Promise.resolve(dispatch(setSnackbar2({ message: "Upload successful", autoHideDuration: TIMEOUTS.fiveSeconds })))).catch((err) => {
      if (isCancel(err)) {
        return dispatch(setSnackbar2({ message: "The upload has been cancelled", autoHideDuration: TIMEOUTS.fiveSeconds }));
      }
      return commonErrorHandler(err, `Error uploading file to device.`, dispatch);
    }).finally(() => dispatch(cleanUpUpload(uploadId)));
  }
);
var getDeviceAuth = createAppAsyncThunk(
  `${sliceName3}/getDeviceAuth`,
  (id, { dispatch }) => dispatch(getDevicesWithAuth([{ id }])).unwrap().then((results) => {
    if (results[results.length - 1]) {
      return Promise.resolve(results[results.length - 1][0]);
    }
    return Promise.resolve();
  })
);
var getDevicesWithAuth = createAppAsyncThunk(
  `${sliceName3}/getDevicesWithAuth`,
  (devices, { dispatch, getState }) => devices.length ? general_api_default.get(`${deviceAuthV2}/devices?id=${devices.map((device) => device.id).join("&id=")}`).then(({ data: receivedDevices }) => {
    const { devicesById } = reduceReceivedDevices(receivedDevices, [], getState());
    return Promise.all([dispatch(actions3.receivedDevices(devicesById)), Promise.resolve(receivedDevices)]);
  }).catch((err) => commonErrorHandler(err, `Error: ${err}`, dispatch)) : Promise.resolve([[], []])
);
var updateDeviceAuth = createAppAsyncThunk(
  `${sliceName3}/updateDeviceAuth`,
  ({ deviceId, authId, status }, { dispatch, getState }) => general_api_default.put(`${deviceAuthV2}/devices/${deviceId}/auth/${authId}/status`, { status }).then(() => Promise.all([dispatch(getDeviceAuth(deviceId)), dispatch(setSnackbar2("Device authorization status was updated successfully"))])).catch((err) => commonErrorHandler(err, "There was a problem updating the device authorization status:", dispatch)).then(() => Promise.resolve(dispatch(actions3.maybeUpdateDevicesByStatus({ deviceId, authId })))).finally(() => dispatch(setDeviceListState({ refreshTrigger: !getDeviceListState(getState()).refreshTrigger })))
);
var updateDevicesAuth = createAppAsyncThunk(
  `${sliceName3}/updateDevicesAuth`,
  ({ deviceIds, status }, { dispatch, getState }) => {
    let devices = getDevicesById(getState());
    const deviceIdsWithoutAuth = deviceIds.reduce((accu, id) => devices[id].auth_sets ? accu : [...accu, { id }], []);
    return dispatch(getDevicesWithAuth(deviceIdsWithoutAuth)).then(() => {
      devices = getDevicesById(getState());
      const deviceAuthUpdates = deviceIds.map((id) => {
        const device = devices[id];
        if (device.auth_sets && device.auth_sets.length !== 1) {
          return Promise.reject();
        }
        return dispatch(updateDeviceAuth({ authId: device.auth_sets[0].id, deviceId: device.id, status })).unwrap().catch((err) => commonErrorHandler(err, "The action was stopped as there was a problem updating a device authorization status: ", dispatch, "", false));
      });
      return Promise.allSettled(deviceAuthUpdates).then((results) => {
        const { skipped, count } = results.reduce(
          (accu, item) => {
            if (item.status === "rejected") {
              accu.skipped = accu.skipped + 1;
            } else {
              accu.count = accu.count + 1;
            }
            return accu;
          },
          { skipped: 0, count: 0 }
        );
        const message = getSnackbarMessage(skipped, count);
        return dispatch(setSnackbar2(message));
      });
    });
  }
);
var deleteAuthset = createAppAsyncThunk(
  `${sliceName3}/deleteAuthset`,
  ({ deviceId, authId }, { dispatch, getState }) => general_api_default.delete(`${deviceAuthV2}/devices/${deviceId}/auth/${authId}`).then(() => Promise.all([dispatch(setSnackbar2("Device authorization status was updated successfully"))])).catch((err) => commonErrorHandler(err, "There was a problem updating the device authorization status:", dispatch)).then(() => Promise.resolve(dispatch(actions3.maybeUpdateDevicesByStatus({ deviceId, authId })))).finally(() => dispatch(setDeviceListState({ refreshTrigger: !getState().devices.deviceList.refreshTrigger })))
);
var preauthDevice = createAppAsyncThunk(
  `${sliceName3}/preauthDevice`,
  (authset, { dispatch, rejectWithValue }) => general_api_default.post(`${deviceAuthV2}/devices`, authset).then(
    () => Promise.resolve(dispatch(setSnackbar2({ message: "Device was successfully added to the preauthorization list", autoHideDuration: TIMEOUTS.fiveSeconds })))
  ).catch((err) => {
    if (err.response.status === 409) {
      return rejectWithValue("A device with a matching identity data set already exists");
    }
    return commonErrorHandler(err, "The device could not be added:", dispatch);
  })
);
var decommissionDevice = createAppAsyncThunk(
  `${sliceName3}/decommissionDevice`,
  ({ deviceId, authId }, { dispatch, getState }) => general_api_default.delete(`${deviceAuthV2}/devices/${deviceId}`).then(() => Promise.resolve(dispatch(setSnackbar2("Device was decommissioned successfully")))).catch((err) => commonErrorHandler(err, "There was a problem decommissioning the device:", dispatch)).then(() => Promise.resolve(dispatch(actions3.maybeUpdateDevicesByStatus({ deviceId, authId })))).finally(() => dispatch(setDeviceListState({ refreshTrigger: !getState().devices.deviceList.refreshTrigger })))
);
var getDeviceConfig = createAppAsyncThunk(
  `${sliceName3}/getDeviceConfig`,
  (deviceId, { dispatch }) => general_api_default.get(`${deviceConfig}/${deviceId}`).then(({ data }) => Promise.all([dispatch(actions3.receivedDevice({ id: deviceId, config: data })), Promise.resolve(data)])).catch((err) => {
    if (err.response?.data?.error.status_code !== 404) {
      return commonErrorHandler(err, `There was an error retrieving the configuration for device ${deviceId}.`, dispatch, commonErrorFallback);
    }
  })
);
var setDeviceConfig = createAppAsyncThunk(
  `${sliceName3}/setDeviceConfig`,
  ({ deviceId, config }, { dispatch }) => general_api_default.put(`${deviceConfig}/${deviceId}`, config).catch((err) => commonErrorHandler(err, `There was an error setting the configuration for device ${deviceId}.`, dispatch, commonErrorFallback)).then(() => Promise.resolve(dispatch(getDeviceConfig(deviceId))))
);
var applyDeviceConfig = createAppAsyncThunk(
  `${sliceName3}/applyDeviceConfig`,
  ({ deviceId, configDeploymentConfiguration, isDefault, config }, { dispatch, getState }) => general_api_default.post(`${deviceConfig}/${deviceId}/deploy`, configDeploymentConfiguration).catch((err) => commonErrorHandler(err, `There was an error deploying the configuration to device ${deviceId}.`, dispatch, commonErrorFallback)).then(({ data }) => {
    const device = getDeviceById(getState(), deviceId);
    const { canManageUsers } = getUserCapabilities(getState());
    const tasks = [
      dispatch(actions3.receivedDevice({ ...device, config: { ...device.config, deployment_id: data.deployment_id } })),
      new Promise((resolve) => setTimeout(() => resolve(dispatch(getSingleDeployment(data.deployment_id))), TIMEOUTS.oneSecond))
    ];
    if (isDefault && canManageUsers) {
      const { previous } = getGlobalSettings(getState()).defaultDeviceConfig ?? {};
      tasks.push(dispatch(saveGlobalSettings({ defaultDeviceConfig: { current: config, previous } })));
    }
    return Promise.all(tasks);
  })
);
var setDeviceTags = createAppAsyncThunk(
  `${sliceName3}/setDeviceTags`,
  ({ deviceId, tags }, { dispatch }) => (
    // to prevent tag set failures, retrieve the device & use the freshest etag we can get
    dispatch(getDeviceById2(deviceId)).unwrap().then((device) => {
      const headers = device.etag ? { "If-Match": device.etag } : {};
      const tagList = Object.entries(tags).map(([name, value]) => ({ name, value }));
      const isNameChange = tagList.some(({ name }) => name === "name");
      return general_api_default.put(`${inventoryApiUrl}/devices/${deviceId}/tags`, tagList, { headers }).catch((err) => commonErrorHandler(err, `There was an error setting tags for device ${deviceId}.`, dispatch, "Please check your connection.")).then(
        () => Promise.all([
          dispatch(actions3.receivedDevice({ ...device, id: deviceId, tags })),
          dispatch(setSnackbar2(`Device ${tagList.length === 1 && isNameChange ? "name" : "tags"} changed`))
        ])
      );
    })
  )
);
var getDeviceTwin = createAppAsyncThunk(`${sliceName3}/getDeviceTwin`, ({ deviceId, integration }, { dispatch, getState }) => {
  let providerResult = {};
  return general_api_default.get(`${iotManagerBaseURL}/devices/${deviceId}/state`).then(({ data }) => {
    providerResult = { ...data, twinError: "" };
  }).catch((err) => {
    providerResult = {
      twinError: `There was an error getting the ${EXTERNAL_PROVIDER[integration.provider].twinTitle.toLowerCase()} for device ${deviceId}. ${err}`
    };
  }).finally(() => {
    const device = getDeviceById(getState(), deviceId);
    Promise.resolve(dispatch(actions3.receivedDevice({ ...device, twinsByIntegration: { ...device.twinsByIntegration, ...providerResult } })));
  });
});
var setDeviceTwin = createAppAsyncThunk(
  `${sliceName3}/setDeviceTwin`,
  ({ deviceId, integration, settings }, { dispatch, getState }) => general_api_default.put(`${iotManagerBaseURL}/devices/${deviceId}/state/${integration.id}`, { desired: settings }).catch(
    (err) => commonErrorHandler(
      err,
      `There was an error updating the ${EXTERNAL_PROVIDER[integration.provider].twinTitle.toLowerCase()} for device ${deviceId}.`,
      dispatch
    )
  ).then(() => {
    const device = getDeviceById(getState(), deviceId);
    const { twinsByIntegration = {} } = device;
    const { [integration.id]: currentState = {} } = twinsByIntegration;
    return Promise.resolve(
      dispatch(
        actions3.receivedDevice({ ...device, twinsByIntegration: { ...twinsByIntegration, [integration.id]: { ...currentState, desired: settings } } })
      )
    );
  })
);
var prepareSearchArguments = ({ filters, group, state, status }) => {
  const { filterTerms } = convertDeviceListStateToFilters({ filters, group, offlineThreshold: state.app.offlineThreshold, selectedIssues: [], status });
  const { columnSelection = [] } = getUserSettings(state);
  const selectedAttributes = columnSelection.map((column) => ({ attribute: column.key, scope: column.scope }));
  const attributes = [...defaultAttributes, getIdAttribute(state), ...selectedAttributes];
  return { attributes, filterTerms };
};
var getSystemDevices = createAppAsyncThunk(`${sliceName3}/getSystemDevices`, (options, { dispatch, getState }) => {
  const { id, page = defaultPage2, perPage = defaultPerPage2, sortOptions = [] } = options;
  const state = getState();
  const { hasFullFiltering } = getTenantCapabilities(state);
  if (!hasFullFiltering) {
    return Promise.resolve();
  }
  const { attributes: deviceAttributes = {} } = getDeviceById(state, id);
  const { mender_gateway_system_id = "" } = deviceAttributes;
  const filters = [
    { ...emptyFilter, key: "mender_is_gateway", operator: DEVICE_FILTERING_OPTIONS.$ne.key, value: "true", scope: "inventory" },
    { ...emptyFilter, key: "mender_gateway_system_id", value: mender_gateway_system_id, scope: "inventory" }
  ];
  const { attributes, filterTerms } = prepareSearchArguments({ filters, state });
  return general_api_default.post(getSearchEndpoint(getState()), {
    page,
    per_page: perPage,
    filters: filterTerms,
    sort: sortOptions,
    attributes
  }).catch((err) => commonErrorHandler(err, `There was an error getting system devices device ${id}.`, dispatch, "Please check your connection.")).then(({ data, headers }) => {
    const state2 = getState();
    const { devicesById, ids } = reduceReceivedDevices(data, [], state2);
    const device = {
      ...getDeviceById(state2, id),
      systemDeviceIds: ids,
      systemDeviceTotal: Number(headers[headerNames.total])
    };
    return Promise.resolve(dispatch(actions3.receivedDevices({ ...devicesById, [id]: device })));
  });
});
var getGatewayDevices = createAppAsyncThunk(`${sliceName3}/getGatewayDevices`, (deviceId, { dispatch, getState }) => {
  const state = getState();
  const { attributes = {} } = getDeviceById(state, deviceId);
  const { mender_gateway_system_id = "" } = attributes;
  const filters = [
    { ...emptyFilter, key: "id", operator: DEVICE_FILTERING_OPTIONS.$ne.key, value: deviceId, scope: "identity" },
    { ...emptyFilter, key: "mender_is_gateway", value: "true", scope: "inventory" },
    { ...emptyFilter, key: "mender_gateway_system_id", value: mender_gateway_system_id, scope: "inventory" }
  ];
  const { attributes: attributeSelection, filterTerms } = prepareSearchArguments({ filters, state });
  return general_api_default.post(getSearchEndpoint(getState()), {
    page: 1,
    per_page: MAX_PAGE_SIZE,
    filters: filterTerms,
    attributes: attributeSelection
  }).then(({ data }) => {
    const { ids } = reduceReceivedDevices(data, [], getState());
    const tasks = ids.map((deviceId2) => dispatch(getDeviceInfo(deviceId2)));
    tasks.push(dispatch(actions3.receivedDevice({ id: deviceId, gatewayIds: ids })));
    return Promise.all(tasks);
  });
});

// src/onboardingSlice/thunks.ts
import { getDemoDeviceAddress } from "@northern.tech/utils/helpers";
import Tracking2 from "@northern.tech/utils/tracking";
import Cookies from "universal-cookie";
var cookies = new Cookies();
var applyOnboardingFallbacks = (progress2) => {
  const step = orderedOnboardingSteps[progress2];
  if (step && step.fallbackStep) {
    return step.fallbackStep;
  }
  return progress2;
};
var determineProgress = (acceptedDevices, pendingDevices, releases, pastDeployments) => {
  const steps = orderedOnboardingSteps;
  let progress2 = -1;
  progress2 = pendingDevices.length > 1 ? steps.findIndex((step) => step === onboardingSteps.DEVICES_PENDING_ACCEPTING_ONBOARDING) : progress2;
  progress2 = acceptedDevices.length >= 1 ? steps.findIndex((step) => step === onboardingSteps.DEVICES_ACCEPTED_ONBOARDING) : progress2;
  progress2 = acceptedDevices.length > 1 && releases.length > 1 && pastDeployments.length > 1 ? steps.findIndex((step) => step === onboardingSteps.DEPLOYMENTS_PAST_COMPLETED) : progress2;
  return steps[progress2];
};
var deductOnboardingState = ({ devicesById, devicesByStatus, onboardingState, pastDeployments, releases, userCapabilities, userId }) => {
  const { canDeploy, canManageDevices, canReadDeployments, canReadDevices, canReadReleases, canUploadReleases } = userCapabilities;
  const userCookie = cookies.get(`${userId}-onboarded`);
  const acceptedDevices = devicesByStatus[DEVICE_STATES.accepted].deviceIds;
  const pendingDevices = devicesByStatus[DEVICE_STATES.pending].deviceIds;
  let deviceType = onboardingState.deviceType ?? [];
  deviceType = !deviceType.length && acceptedDevices.length && devicesById[acceptedDevices[0]].hasOwnProperty("attributes") ? devicesById[acceptedDevices[0]].attributes.device_type : deviceType;
  const progress2 = applyOnboardingFallbacks(onboardingState.progress || determineProgress(acceptedDevices, pendingDevices, releases, pastDeployments));
  return {
    ...onboardingState,
    complete: !!(Boolean(userCookie) || onboardingState.complete || acceptedDevices.length > 1 && pendingDevices.length > 0 && releases.length > 1 && pastDeployments.length > 1 || acceptedDevices.length >= 1 && releases.length >= 2 && pastDeployments.length > 2 || acceptedDevices.length >= 1 && pendingDevices.length > 0 && releases.length >= 2 && pastDeployments.length >= 2 || orderedOnboardingSteps.findIndex((step) => step === progress2) >= orderedOnboardingSteps.length - 1 || onboardingState.disable || ![canDeploy, canManageDevices, canReadDeployments, canReadDevices, canReadReleases, canUploadReleases].every((i) => i)),
    showTips: onboardingState.showTips != null ? onboardingState.showTips : true,
    deviceType,
    approach: onboardingState.approach || (deviceType.some((type) => type.startsWith("qemu")) ? "virtual" : "physical"),
    progress: progress2
  };
};
var getOnboardingState2 = createAppAsyncThunk(`${sliceName4}/getOnboardingState`, (_, { dispatch, getState }) => {
  const state = getState();
  let onboardingState = getOnboardingState(state);
  if (!onboardingState.complete) {
    const userId = state.users.currentUser;
    onboardingState = deductOnboardingState({
      devicesById: state.devices.byId,
      devicesByStatus: state.devices.byStatus,
      onboardingState,
      pastDeployments: state.deployments.byStatus.finished.deploymentIds,
      releases: Object.values(state.releases.byId),
      userCapabilities: getUserCapabilities(state),
      userId
    });
  }
  onboardingState.progress = onboardingState.progress || onboardingSteps.DASHBOARD_ONBOARDING_START;
  const demoDeviceAddress = `http://${getDemoDeviceAddress(Object.values(state.devices.byId), onboardingState.approach)}`;
  onboardingState.address = state.onboarding.demoArtifactPort ? `${demoDeviceAddress}:${state.onboarding.demoArtifactPort}` : demoDeviceAddress;
  return Promise.all([
    dispatch(actions4.setOnboardingComplete(onboardingState.complete)),
    dispatch(actions4.setOnboardingState(onboardingState)),
    dispatch(saveUserSettings({ onboarding: onboardingState }))
  ]);
});
var setOnboardingDeviceType = createAppAsyncThunk(
  `${sliceName4}/setOnboardingDeviceType`,
  (value, { dispatch }) => Promise.all([dispatch(actions4.setOnboardingDeviceType(value)), dispatch(saveUserSettings({ onboarding: { deviceType: value } }))])
);
var setOnboardingApproach = createAppAsyncThunk(
  `${sliceName4}/setOnboardingApproach`,
  (value, { dispatch }) => Promise.all([dispatch(actions4.setOnboardingApproach(value)), dispatch(saveUserSettings({ onboarding: { approach: value } }))])
);
var setOnboardingComplete = createAppAsyncThunk(`${sliceName4}/setOnboardingComplete`, (value, { dispatch }) => {
  const tasks = [Promise.resolve(dispatch(actions4.setOnboardingComplete(value)))];
  if (value) {
    tasks.push(Promise.resolve(dispatch(actions4.setShowOnboardingHelp(false))));
    tasks.push(Promise.resolve(dispatch(advanceOnboarding(onboardingSteps.DEPLOYMENTS_PAST_COMPLETED))));
  }
  return Promise.all(tasks);
});
var setOnboardingCanceled = createAppAsyncThunk(
  `${sliceName4}/setOnboardingCanceled`,
  (_, { dispatch }) => Promise.all([
    Promise.resolve(dispatch(actions4.setShowOnboardingHelp(false))),
    Promise.resolve(dispatch(actions4.setShowDismissOnboardingTipsDialog(false))),
    Promise.resolve(dispatch(actions4.setOnboardingComplete(true)))
  ]).then(() => dispatch(advanceOnboarding(onboardingSteps.DEPLOYMENTS_PAST_COMPLETED_FAILURE))).then(() => Tracking2.event({ category: "onboarding", action: onboardingSteps.ONBOARDING_CANCELED }))
);
var advanceOnboarding = createAppAsyncThunk(`${sliceName4}/advanceOnboarding`, (stepId, { dispatch, getState }) => {
  const steps = orderedOnboardingSteps;
  const progress2 = steps.findIndex((step) => step === getState().onboarding.progress);
  const stepIndex = steps.findIndex((step) => step === stepId);
  if (progress2 > stepIndex || getState().onboarding.progress === null) {
    return;
  }
  const madeProgress = steps[stepIndex + 1];
  const state = { ...getOnboardingState(getState()), progress: madeProgress };
  state.complete = stepIndex + 1 >= orderedOnboardingSteps.findIndex((step) => step === onboardingSteps.DEPLOYMENTS_PAST_COMPLETED_FAILURE) ? true : state.complete;
  Tracking2.event({ category: "onboarding", action: stepId });
  return Promise.all([dispatch(actions4.setOnboardingProgress(madeProgress)), dispatch(saveUserSettings({ onboarding: state }))]);
});

// src/organizationSlice/thunks.ts
import { PreviewRequest as PreviewRequestEnum } from "@northern.tech/types/MenderTypes";
import { dateRangeToUnix as dateRangeToUnix2, deepCompare as deepCompare3 } from "@northern.tech/utils/helpers";
import dayjs from "dayjs";
import utc from "dayjs/plugin/utc.js";
import { jwtDecode } from "jwt-decode";
import hashString from "md5";
import Cookies2 from "universal-cookie";
var cookies2 = new Cookies2();
dayjs.extend(utc);
var { setAnnouncement, setSnackbar: setSnackbar3 } = actions_default;
var { page: defaultPage3, perPage: defaultPerPage3 } = DEVICE_LIST_DEFAULTS;
var cancelRequest = createAppAsyncThunk(`${sliceName5}/cancelRequest`, (reason, { dispatch, getState }) => {
  const { id: tenantId } = getOrganization(getState());
  return general_api_default.post(`${tenantadmApiUrlv2}/tenants/${tenantId}/cancel`, { reason }).then(
    () => Promise.resolve(dispatch(setSnackbar3({ message: "Deactivation request was sent successfully", autoHideDuration: TIMEOUTS.fiveSeconds })))
  );
});
var getTargetLocation = (key) => {
  if (devLocations.includes(window.location.hostname)) {
    return "";
  }
  let subdomainSections = window.location.hostname.substring(0, window.location.hostname.indexOf(locations.us.location)).split(".");
  subdomainSections = subdomainSections.splice(0, subdomainSections.length - 1);
  if (!subdomainSections.find((section) => section === key)) {
    subdomainSections = key === locations.us.key ? subdomainSections.filter((section) => !locations[section]) : [...subdomainSections, key];
    return `https://${[...subdomainSections, ...locations.us.location.split(".")].join(".")}`;
  }
  return `https://${window.location.hostname}`;
};
var devLocations = ["localhost", "docker.mender.io"];
var createOrganizationTrial = createAppAsyncThunk(`${sliceName5}/createOrganizationTrial`, (data, { dispatch }) => {
  const { key } = locations[data.location];
  const targetLocation = getTargetLocation(key);
  const target = `${targetLocation}${tenantadmApiUrlv2}/tenants/trial`;
  return general_api_default.postUnauthorized(target, data).catch((err) => {
    if (err.response.status >= 400 && err.response.status < 500) {
      dispatch(setSnackbar3({ message: err.response.data.error, autoHideDuration: TIMEOUTS.fiveSeconds }));
      return Promise.reject(err);
    }
  }).then(({ headers }) => {
    cookies2.remove("oauth");
    cookies2.remove("externalID");
    cookies2.remove("email");
    dispatch(setFirstLoginAfterSignup(true));
    return new Promise(
      (resolve) => setTimeout(() => {
        window.location.assign(`${targetLocation}${headers.location || ""}`);
        return resolve();
      }, TIMEOUTS.fiveSeconds)
    );
  });
});
var startCardUpdate = createAppAsyncThunk(
  `${sliceName5}/startCardUpdate`,
  (_, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/billing/card`).then(({ data }) => {
    dispatch(actions5.receiveSetupIntent(data.intent_id));
    return Promise.resolve(data.secret);
  }).catch((err) => commonErrorHandler(err, `Updating the card failed:`, dispatch))
);
var confirmCardUpdate = createAppAsyncThunk(
  `${sliceName5}/confirmCardUpdate`,
  (_, { dispatch, getState }) => general_api_default.post(`${tenantadmApiUrlv2}/billing/card/${getState().organization.intentId}/confirm`).then(() => Promise.all([dispatch(setSnackbar3("Payment card was updated successfully")), dispatch(actions5.receiveSetupIntent(null))])).catch((err) => commonErrorHandler(err, `Updating the card failed:`, dispatch))
);
var getCurrentCard = createAppAsyncThunk(
  `${sliceName5}/getCurrentCard`,
  (_, { dispatch }) => general_api_default.get(`${tenantadmApiUrlv2}/billing`).then((res) => {
    const { last4, exp_month, exp_year, brand } = res.data.card || {};
    return Promise.resolve(dispatch(actions5.receiveCurrentCard({ brand, last4, expiration: { month: exp_month, year: exp_year } })));
  })
);
var startUpgrade = createAppAsyncThunk(
  `${sliceName5}/startUpgrade`,
  (tenantId, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/tenants/${tenantId}/upgrade/start`).then(({ data }) => Promise.resolve(data.secret)).catch((err) => commonErrorHandler(err, `There was an error upgrading your account:`, dispatch))
);
var cancelUpgrade = createAppAsyncThunk(
  `${sliceName5}/cancelUpgrade`,
  (tenantId) => general_api_default.post(`${tenantadmApiUrlv2}/tenants/${tenantId}/upgrade/cancel`)
);
var completeUpgrade = createAppAsyncThunk(
  `${sliceName5}/completeUpgrade`,
  ({ tenantId, plan, billing_profile }, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/tenants/${tenantId}/upgrade/complete`, { plan, billing_profile }).catch((err) => commonErrorHandler(err, `There was an error upgrading your account:`, dispatch)).then(() => Promise.all([dispatch(getDeviceLimit()), dispatch(getUserOrganization())]))
);
var prepareAuditlogQuery = ({
  startDate,
  endDate,
  user: userFilter,
  type,
  detail: detailFilter,
  sort = { direction: SORTING_OPTIONS.desc }
}) => {
  const userId = typeof userFilter === "object" && userFilter ? userFilter.id : userFilter;
  const detail = typeof detailFilter === "object" && detailFilter ? detailFilter.id : detailFilter;
  const { start: startUnix, end: endUnix } = dateRangeToUnix2(startDate, endDate);
  const createdAfter = startDate ? `&created_after=${startUnix}` : "";
  const createdBefore = endDate ? `&created_before=${endUnix}` : "";
  const typeSearch = type ? `&object_type=${type.value}`.toLowerCase() : "";
  const userSearch = userId ? `&actor_id=${userId}` : "";
  const objectSearch = type && detail ? `&${type.queryParameter}=${encodeURIComponent(detail)}` : "";
  const { direction = SORTING_OPTIONS.desc } = sort;
  return `${createdAfter}${createdBefore}${userSearch}${typeSearch}${objectSearch}&sort=${direction}`;
};
var getAuditLogs = createAppAsyncThunk(`${sliceName5}/getAuditLogs`, (selectionState, { dispatch, getState }) => {
  const { page, perPage } = selectionState;
  const { hasAuditlogs } = getTenantCapabilities(getState());
  if (!hasAuditlogs) {
    return Promise.resolve();
  }
  return general_api_default.get(`${auditLogsApiUrl}/logs?page=${page}&per_page=${perPage}${prepareAuditlogQuery(selectionState)}`).then(({ data, headers }) => {
    let total = headers[headerNames.total];
    total = Number(total || data.length);
    return Promise.resolve(dispatch(actions5.receiveAuditLogs({ events: data, total })));
  }).catch((err) => commonErrorHandler(err, `There was an error retrieving audit logs:`, dispatch));
});
var getAuditLogsCsvLink = createAppAsyncThunk(
  `${sliceName5}/getAuditLogsCsvLink`,
  (_, { getState }) => Promise.resolve(`${window.location.origin}${auditLogsApiUrl}/logs/export?limit=20000${prepareAuditlogQuery(getAuditlogState(getState()))}`)
);
var setAuditlogsState = createAppAsyncThunk(
  `${sliceName5}/setAuditlogsState`,
  (selectionState, { dispatch, getState }) => {
    const currentState = getAuditlogState(getState());
    const nextState = {
      ...currentState,
      ...selectionState,
      sort: { ...currentState.sort, ...selectionState.sort }
    };
    const tasks = [];
    const { isLoading: currentLoading, selectedIssue: currentIssue, ...currentRequestState } = currentState;
    const { isLoading: selectionLoading, selectedIssue: selectionIssue, ...selectionRequestState } = nextState;
    if (!deepCompare3(currentRequestState, selectionRequestState)) {
      nextState.isLoading = true;
      tasks.push(dispatch(getAuditLogs(nextState)).finally(() => dispatch(actions5.setAuditLogState({ isLoading: false }))));
    }
    tasks.push(dispatch(actions5.setAuditLogState(nextState)));
    return Promise.all(tasks);
  }
);
var tenantDataDivergedMessage = "The system detected there is a change in your plan or purchased add-ons. Please log out and log in again";
var addTenant = createAppAsyncThunk(
  `${sliceName5}/createTenant`,
  (selectionState, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/tenants`, selectionState).then(
    () => Promise.all([
      dispatch(setSnackbar3("Tenant was created successfully.")),
      new Promise((resolve) => setTimeout(() => resolve(dispatch(getTenants())), TIMEOUTS.oneSecond))
    ])
  ).catch((err) => commonErrorHandler(err, "There was an error creating tenant", dispatch, commonErrorFallback))
);
var tenantListRetrieval = async (config) => {
  const { page, perPage } = config;
  const params = new URLSearchParams({ page, per_page: perPage }).toString();
  const tenantList = await general_api_default.get(`${tenantadmApiUrlv2}/tenants?${params}`);
  const totalCount = tenantList.headers[headerNames.total] || TENANT_LIST_DEFAULT.perPage;
  return [tenantList.data, Number(totalCount)];
};
var getTenants = createAppAsyncThunk(`${sliceName5}/getTenants`, async (_, { dispatch, getState }) => {
  const currentState = getTenantsList(getState());
  const [tenants, pageCount] = await tenantListRetrieval(currentState);
  dispatch(actions5.setTenantListState({ ...currentState, total: pageCount, tenants }));
});
var setTenantsListState = createAppAsyncThunk(
  `${sliceName5}/setTenantsListState`,
  async (selectionState, { dispatch, getState }) => {
    const currentState = getTenantsList(getState());
    const nextState = {
      ...currentState,
      ...selectionState
    };
    if (!deepCompare3(currentState, selectionState)) {
      const [tenants, pageCount] = await tenantListRetrieval(nextState);
      return dispatch(actions5.setTenantListState({ ...nextState, tenants, total: pageCount }));
    }
    return dispatch(actions5.setTenantListState({ ...nextState }));
  }
);
var editTenantDeviceLimit = createAppAsyncThunk(
  `${sliceName5}/editDeviceLimit`,
  ({ newLimit, id, name }, { dispatch }) => general_api_default.put(`${tenantadmApiUrlv2}/tenants/${id}/child`, { device_limit: newLimit, name }).catch((err) => commonErrorHandler(err, `Device Limit cannot be changed`, dispatch)).then(
    () => Promise.all([
      dispatch(setSnackbar3("Device Limit was changed successfully")),
      dispatch(getUserOrganization()),
      new Promise((resolve) => setTimeout(() => resolve(dispatch(getTenants())), TIMEOUTS.oneSecond))
    ])
  )
);
var editBillingProfile = createAppAsyncThunk(
  `${sliceName5}/editBillingProfileEmail`,
  ({ billingProfile }, { dispatch }) => general_api_default.patch(`${tenantadmApiUrlv2}/billing/profile`, billingProfile).catch((err) => commonErrorHandler(err, `Failed to change billing profile`, dispatch)).then(() => Promise.all([dispatch(setSnackbar3("Billing Profile was changed successfully")), dispatch(getUserBilling())]))
);
var createBillingProfile = createAppAsyncThunk(
  `${sliceName5}/createBillingProfileEmail`,
  ({ billingProfile }, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/billing/profile`, billingProfile).catch((err) => commonErrorHandler(err, `Failed to create billing profile`, dispatch)).then(() => Promise.all([dispatch(setSnackbar3("Billing Profile was created successfully")), dispatch(getUserBilling())]))
);
var removeTenant = createAppAsyncThunk(
  `${sliceName5}/editDeviceLimit`,
  ({ id }, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/tenants/${id}/remove/start`).catch((err) => commonErrorHandler(err, `There was an error removing the tenant`, dispatch)).then(
    () => Promise.all([
      dispatch(setSnackbar3("The tenant was removed successfully")),
      dispatch(getUserOrganization()),
      new Promise((resolve) => setTimeout(() => resolve(dispatch(getTenants())), TIMEOUTS.oneSecond))
    ])
  )
);
var getUserOrganization = createAppAsyncThunk(
  `${sliceName5}/getUserOrganization`,
  (_, { dispatch, getState }) => general_api_default.get(`${tenantadmApiUrlv1}/user/tenant`).then((res) => {
    const tasks = [dispatch(actions5.setOrganization(res.data))];
    const { addons, plan, trial } = res.data;
    const { token } = getCurrentSession(getState());
    const jwt = jwtDecode(token);
    const jwtData = { addons: jwt["mender.addons"], plan: jwt["mender.plan"], trial: jwt["mender.trial"] };
    if (!deepCompare3({ addons, plan, trial }, jwtData)) {
      const hash = hashString(tenantDataDivergedMessage);
      cookies2.remove(`${jwt.sub}${hash}`);
      tasks.push(dispatch(setAnnouncement(tenantDataDivergedMessage)));
    }
    return Promise.all(tasks);
  })
);
var getUserBilling = createAppAsyncThunk(
  `${sliceName5}/getUserBilling`,
  (_, { dispatch }) => general_api_default.get(`${tenantadmApiUrlv2}/billing/profile`).then((res) => dispatch(actions5.setBillingProfile(res.data)))
);
var getUserSubscription = createAppAsyncThunk(`${sliceName5}/getUserSubscription`, (_, { dispatch }) => {
  const tasks = [dispatch(getBillingPreview({ preview_mode: PreviewRequestEnum.preview_mode.NEXT })).unwrap(), dispatch(getCurrentSubscription()).unwrap()];
  Promise.all(tasks).then(([currentPreview, currentSubscription]) => dispatch(actions5.setSubscription({ ...currentPreview, ...currentSubscription })));
});
var getBillingPreview = createAppAsyncThunk(
  `${sliceName5}/getBillingPreview`,
  (order) => general_api_default.post(`${tenantadmApiUrlv2}/billing/subscription/invoices/preview`, order).then(
    ({ data }) => order.preview_mode === "recurring" ? { ...parseSubscriptionPreview(data.lines), total: data.total } : data
  )
);
var getCurrentSubscription = createAppAsyncThunk(
  `${sliceName5}/getCurrentSubscription`,
  () => general_api_default.get(`${tenantadmApiUrlv2}/billing/subscription`).then((res) => res.data)
);
var successMessage = (planId) => `Thank you! You have successfully subscribed to the ${PLANS[planId].name} plan.  You can view and edit your billing details on the Organization and billing page.`;
var requestPlanUpgrade = createAppAsyncThunk(
  `${sliceName5}/requestPlanUpgrade`,
  (order, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/billing/subscription`, order).catch((err) => commonErrorHandler(err, "There was an error sending your request", dispatch, commonErrorFallback)).then(
    () => Promise.all([
      dispatch(setSnackbar3(successMessage(order.plan))),
      setTimeout(() => dispatch(getDeviceLimit()), TIMEOUTS.threeSeconds),
      dispatch(getUserOrganization())
    ])
  )
);
var sendSupportMessage = createAppAsyncThunk(
  `${sliceName5}/sendSupportMessage`,
  (content, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/contact/support`, content).catch((err) => commonErrorHandler(err, "There was an error sending your request", dispatch, commonErrorFallback)).then(() => Promise.resolve(dispatch(setSnackbar3({ message: "Your request was sent successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))))
);
var requestPlanChange = createAppAsyncThunk(
  `${sliceName5}/requestPlanChange`,
  ({ content, tenantId }, { dispatch, rejectWithValue }) => general_api_default.post(`${tenantadmApiUrlv2}/tenants/${tenantId}/plan`, content).catch(async (err) => {
    await commonErrorHandler(err, "There was an error sending your request", dispatch, commonErrorFallback);
    rejectWithValue(err);
  }).then(() => Promise.resolve(dispatch(setSnackbar3({ message: "Your request was sent successfully", autoHideDuration: TIMEOUTS.fiveSeconds }))))
);
var downloadLicenseReport = createAppAsyncThunk(
  `${sliceName5}/downloadLicenseReport`,
  (_, { dispatch }) => general_api_default.get(`${deviceAuthV2}/license`).catch((err) => commonErrorHandler(err, "There was an error downloading the report", dispatch, commonErrorFallback)).then((res) => res.data)
);
var createIntegration = createAppAsyncThunk(
  `${sliceName5}/createIntegration`,
  ({ id, ...integration }, { dispatch }) => general_api_default.post(`${iotManagerBaseURL}/integrations`, integration).catch((err) => commonErrorHandler(err, "There was an error creating the integration", dispatch, commonErrorFallback)).then(() => Promise.all([dispatch(setSnackbar3("The integration was set up successfully")), dispatch(getIntegrations())]))
);
var changeIntegration = createAppAsyncThunk(
  `${sliceName5}/changeIntegration`,
  ({ id, credentials }, { dispatch }) => general_api_default.put(`${iotManagerBaseURL}/integrations/${id}/credentials`, credentials).catch((err) => commonErrorHandler(err, "There was an error updating the integration", dispatch, commonErrorFallback)).then(() => Promise.all([dispatch(setSnackbar3("The integration was updated successfully")), dispatch(getIntegrations())]))
);
var deleteIntegration = createAppAsyncThunk(
  `${sliceName5}/deleteIntegration`,
  ({ id, provider }, { dispatch, getState }) => general_api_default.delete(`${iotManagerBaseURL}/integrations/${id}`, {}).catch((err) => commonErrorHandler(err, "There was an error removing the integration", dispatch, commonErrorFallback)).then(() => {
    const integrations = getState().organization.externalDeviceIntegrations.filter((item) => provider !== item.provider);
    return Promise.all([
      dispatch(setSnackbar3("The integration was removed successfully")),
      dispatch(actions5.receiveExternalDeviceIntegrations(integrations))
    ]);
  })
);
var getIntegrations = createAppAsyncThunk(
  `${sliceName5}/getIntegrations`,
  (_, { dispatch, getState }) => general_api_default.get(`${iotManagerBaseURL}/integrations`).catch((err) => commonErrorHandler(err, "There was an error retrieving the integration", dispatch, commonErrorFallback)).then(({ data }) => {
    const existingIntegrations = getState().organization.externalDeviceIntegrations;
    const integrations = data.reduce((accu, item) => {
      const existingIntegration = existingIntegrations.find((integration2) => item.id === integration2.id) ?? {};
      const integration = { ...existingIntegration, ...item };
      accu.push(integration);
      return accu;
    }, []);
    return Promise.resolve(dispatch(actions5.receiveExternalDeviceIntegrations(integrations)));
  })
);
var getWebhookEvents = createAppAsyncThunk(`${sliceName5}/getWebhookEvents`, (config = {}, { dispatch, getState }) => {
  const { isFollowUp, page = defaultPage3, perPage = defaultPerPage3 } = config;
  return general_api_default.get(`${iotManagerBaseURL}/events?page=${page}&per_page=${perPage}`).catch((err) => commonErrorHandler(err, "There was an error retrieving activity for this integration", dispatch, commonErrorFallback)).then(({ data }) => {
    const tasks = [
      dispatch(
        actions5.receiveWebhookEvents({
          value: isFollowUp ? getState().organization.webhooks.events : data,
          total: (page - 1) * perPage + data.length
        })
      )
    ];
    if (data.length >= perPage && !isFollowUp) {
      tasks.push(dispatch(getWebhookEvents({ isFollowUp: true, page: page + 1, perPage: 1 })));
    }
    return Promise.all(tasks);
  });
});
var ssoConfigActions = {
  create: { success: "stored", error: "storing" },
  edit: { success: "updated", error: "updating" },
  read: { success: "", error: "retrieving" },
  remove: { success: "removed", error: "removing" },
  readMultiple: { success: "", error: "retrieving" }
};
var ssoConfigActionErrorHandler = (err, type) => (dispatch) => commonErrorHandler(err, `There was an error ${ssoConfigActions[type].error} the SSO configuration.`, dispatch, commonErrorFallback);
var ssoConfigActionSuccessHandler = (type) => (dispatch) => dispatch(setSnackbar3(`The SSO configuration was ${ssoConfigActions[type].success} successfully`));
var storeSsoConfig = createAppAsyncThunk(
  `${sliceName5}/storeSsoConfig`,
  ({ config, contentType }, { dispatch }) => general_api_default.post(ssoIdpApiUrlv1, config, { headers: { "Content-Type": contentType, Accept: "application/json" } }).catch((err) => dispatch(ssoConfigActionErrorHandler(err, "create"))).then(() => Promise.all([dispatch(ssoConfigActionSuccessHandler("create")), dispatch(getSsoConfigs())]))
);
var changeSsoConfig = createAppAsyncThunk(
  `${sliceName5}/changeSsoConfig`,
  ({ config, contentType }, { dispatch }) => general_api_default.put(`${ssoIdpApiUrlv1}/${config.id}`, config, { headers: { "Content-Type": contentType, Accept: "application/json" } }).catch((err) => dispatch(ssoConfigActionErrorHandler(err, "edit"))).then(() => Promise.all([dispatch(ssoConfigActionSuccessHandler("edit")), dispatch(getSsoConfigs())]))
);
var deleteSsoConfig = createAppAsyncThunk(
  `${sliceName5}/deleteSsoConfig`,
  ({ id }, { dispatch, getState }) => general_api_default.delete(`${ssoIdpApiUrlv1}/${id}`).catch((err) => dispatch(ssoConfigActionErrorHandler(err, "remove"))).then(() => {
    const configs = getState().organization.ssoConfigs.filter((item) => id !== item.id);
    return Promise.all([dispatch(ssoConfigActionSuccessHandler("remove")), dispatch(actions5.receiveSsoConfigs(configs))]);
  })
);
var getSsoConfigById = createAppAsyncThunk(
  `${sliceName5}/getSsoConfigById`,
  (config, { dispatch }) => general_api_default.get(`${ssoIdpApiUrlv1}/${config.id}`).catch((err) => dispatch(ssoConfigActionErrorHandler(err, "read"))).then(({ data, headers }) => {
    const sso = Object.values(SSO_TYPES).find(({ contentType }) => contentType === headers["content-type"]);
    return sso ? Promise.resolve({ ...config, config: data, type: sso.id }) : Promise.reject("Unsupported SSO config content type.");
  })
);
var getSsoConfigs = createAppAsyncThunk(
  `${sliceName5}/getSsoConfigs`,
  (_, { dispatch }) => general_api_default.get(ssoIdpApiUrlv1).catch((err) => dispatch(ssoConfigActionErrorHandler(err, "readMultiple"))).then(
    ({ data }) => Promise.all(data.map((config) => dispatch(getSsoConfigById(config)).unwrap())).then((configs) => dispatch(actions5.receiveSsoConfigs(configs))).catch((err) => commonErrorHandler(err, err, dispatch, ""))
  )
);

// src/usersSlice/thunks.ts
import { duplicateFilter, extractErrorMessage as extractErrorMessage2, isEmpty as isEmpty2 } from "@northern.tech/utils/helpers";
import { clearAllRetryTimers } from "@northern.tech/utils/retrytimer";
import hashString2 from "md5";
import Cookies3 from "universal-cookie";
var cookies3 = new Cookies3();
var { setAnnouncement: setAnnouncement2, setSnackbar: setSnackbar4 } = actions_default;
var handleLoginError = (err, { token2fa: has2FA, password }, rejectWithValue) => () => {
  const errorText = extractErrorMessage2(err);
  const is2FABackend = errorText.includes("2fa");
  if (is2FABackend && !has2FA) {
    return rejectWithValue({ error: "2fa code missing" });
  }
  if (password === void 0) {
    return Promise.reject();
  }
  const twoFAError = is2FABackend ? " and verification code" : "";
  const errorMessage = `There was a problem logging in. Please check your email${twoFAError ? "," : " and"} password${twoFAError}. If you still have problems, contact an administrator.`;
  return rejectWithValue({ error: errorMessage });
};
var loginUser = createAppAsyncThunk(
  `${sliceName6}/loginUser`,
  ({ stayLoggedIn, ...userData }, { dispatch, rejectWithValue }) => users_api_default.postLogin(`${useradmApiUrl}/auth/login`, { ...userData, no_expiry: stayLoggedIn }).catch((err) => {
    cleanUp();
    return Promise.reject(dispatch(handleLoginError(err, userData, rejectWithValue)));
  }).then(({ text: token, contentType }) => {
    if (contentType.includes(APPLICATION_JSON_CONTENT_TYPE)) {
      const { id, kind } = token;
      const type = kind.split("/")[1];
      const ssoLoginUrl = SSO_TYPES[type].getStartUrl(id);
      window.location.replace(ssoLoginUrl);
      return;
    }
    if (contentType !== APPLICATION_JWT_CONTENT_TYPE || !token) {
      return;
    }
    const now = /* @__PURE__ */ new Date();
    now.setSeconds(now.getSeconds() + maxSessionAge);
    const expiresAt = stayLoggedIn ? void 0 : now.toISOString();
    setSessionInfo({ token, expiresAt });
    cookies3.remove("JWT", { path: "/" });
    return dispatch(getUser(OWN_USER_ID)).unwrap().catch((e) => {
      cleanUp();
      return Promise.reject(dispatch(setSnackbar4(extractErrorMessage2(e))));
    }).then(() => {
      window.sessionStorage.removeItem("pendings-redirect");
      if (window.location.pathname !== "/ui/") {
        window.location.replace("/ui/");
      }
      return Promise.resolve(dispatch(actions6.successfullyLoggedIn({ expiresAt, token })));
    });
  })
);
var logoutUser = createAppAsyncThunk(`${sliceName6}/logoutUser`, (_, { dispatch, getState }) => {
  if (Object.keys(getState().app.uploadsById).length) {
    return Promise.reject();
  }
  return general_api_default.post(`${useradmApiUrl}/auth/logout`).finally(() => {
    cleanUp();
    clearAllRetryTimers(setSnackbar4);
    return Promise.resolve(dispatch({ type: USER_LOGOUT }));
  });
});
var switchUserOrganization = createAppAsyncThunk(`${sliceName6}/switchUserOrganization`, (tenantId, { getState }) => {
  if (Object.keys(getState().app.uploadsById).length) {
    return Promise.reject();
  }
  return general_api_default.get(`${useradmApiUrl}/users/tenants/${tenantId}/token`).then(({ data: token }) => {
    window.sessionStorage.setItem("tenantChanged", "true");
    setSessionInfo({ ...getSessionInfo(), token });
    window.location.reload();
  });
});
var passwordResetStart = createAppAsyncThunk(
  `${sliceName6}/passwordResetStart`,
  (email, { dispatch }) => general_api_default.post(`${useradmApiUrl}/auth/password-reset/start`, { email }).catch(
    (err) => commonErrorHandler(err, `The password reset request cannot be processed:`, dispatch, void 0, true)
  )
);
var passwordResetComplete = createAppAsyncThunk(
  `${sliceName6}/passwordResetComplete`,
  ({ secretHash, newPassword }, { dispatch }) => general_api_default.post(`${useradmApiUrl}/auth/password-reset/complete`, { secret_hash: secretHash, password: newPassword }).catch((err = {}) => {
    const { error, response = {} } = err;
    let errorMsg = "";
    if (response.status == 400) {
      errorMsg = "the link you are using expired or the request is not valid, please try again.";
    } else {
      errorMsg = error;
    }
    dispatch(setSnackbar4("The password reset request cannot be processed: " + errorMsg));
    return Promise.reject(err);
  })
);
var verifyEmailStart = createAppAsyncThunk(
  `${sliceName6}/verifyEmailStart`,
  (_, { dispatch, getState }) => general_api_default.post(`${useradmApiUrl}/auth/verify-email/start`, { email: getCurrentUser(getState()).email }).catch((err) => commonErrorHandler(err, "An error occured starting the email verification process:", dispatch)).finally(() => Promise.resolve(dispatch(getUser(OWN_USER_ID))))
);
var verifyEmailComplete = createAppAsyncThunk(
  `${sliceName6}/verifyEmailComplete`,
  (secret_hash, { dispatch }) => general_api_default.post(`${useradmApiUrl}/auth/verify-email/complete`, { secret_hash }).catch((err) => commonErrorHandler(err, "An error occured completing the email verification process:", dispatch)).finally(() => Promise.resolve(dispatch(getUser(OWN_USER_ID))))
);
var verify2FA = createAppAsyncThunk(
  `${sliceName6}/verify2FA`,
  (tfaData, { dispatch }) => users_api_default.putVerifyTFA(`${useradmApiUrl}/2faverify`, tfaData).then(() => Promise.resolve(dispatch(getUser(OWN_USER_ID)))).catch(
    (err) => commonErrorHandler(err, "An error occured validating the verification code: failed to verify token, please try again.", dispatch, void 0, true)
  )
);
var getUserList = createAppAsyncThunk(
  `${sliceName6}/getUserList`,
  (_, { dispatch, getState }) => general_api_default.get(`${useradmApiUrl}/users`).then((res) => {
    const currentUsersById = getUsersById(getState());
    const users = res.data.reduce(
      (accu, item) => {
        accu[item.id] = {
          ...accu[item.id],
          ...item
        };
        return accu;
      },
      { ...currentUsersById }
    );
    return dispatch(actions6.receivedUserList(users));
  }).catch((err) => commonErrorHandler(err, `Users couldn't be loaded.`, dispatch, commonErrorFallback))
);
var getUser = createAppAsyncThunk(
  `${sliceName6}/getUser`,
  (id, { dispatch, rejectWithValue }) => general_api_default.get(`${useradmApiUrl}/users/${id}`).then(
    ({ data: user }) => Promise.all([
      dispatch(actions6.receivedUser(user)),
      dispatch(setHideAnnouncement({ shouldHide: false, userId: user.id })),
      dispatch(updateUserColumnSettings({ currentUserId: user.id })),
      user
    ])
  ).catch((e) => rejectWithValue(e))
);
var initializeSelf = createAppAsyncThunk(`${sliceName6}/initializeSelf`, (_, { dispatch }) => dispatch(getUser(OWN_USER_ID)));
var updateUserColumnSettings = createAppAsyncThunk(
  `${sliceName6}/updateUserColumnSettings`,
  ({ columns, currentUserId }, { dispatch, getState }) => {
    const userId = currentUserId ?? getCurrentUser(getState()).id;
    const storageKey = `${userId}-column-widths`;
    let customColumns = [];
    if (!columns) {
      try {
        customColumns = JSON.parse(window.localStorage.getItem(storageKey) || "") || customColumns;
      } catch {
      }
    } else {
      customColumns = columns;
    }
    window.localStorage.setItem(storageKey, JSON.stringify(customColumns));
    return Promise.resolve(dispatch(actions6.setCustomColumns(customColumns)));
  }
);
var userActions = {
  add: {
    successMessage: "The user was added successfully.",
    errorMessage: "adding"
  },
  create: {
    successMessage: "The user was created successfully.",
    errorMessage: "creating"
  },
  edit: {
    successMessage: "The user has been updated.",
    errorMessage: "editing"
  },
  remove: {
    successMessage: "The user was removed from the system.",
    errorMessage: "removing"
  }
};
var userActionErrorHandler = (err, type, dispatch) => commonErrorHandler(err, `There was an error ${userActions[type].errorMessage} the user.`, dispatch);
var createUser = createAppAsyncThunk(
  `${sliceName6}/createUser`,
  ({ shouldResetPassword, ...userData }, { dispatch }) => general_api_default.post(`${useradmApiUrl}/users`, { ...userData, send_reset_password: shouldResetPassword }).then(() => Promise.all([dispatch(getUserList()), dispatch(setSnackbar4(userActions.create.successMessage))])).catch((err) => userActionErrorHandler(err, "create", dispatch))
);
var removeUser = createAppAsyncThunk(
  `${sliceName6}/removeUser`,
  (userId, { dispatch }) => general_api_default.delete(`${useradmApiUrl}/users/${userId}`).then(() => Promise.all([dispatch(actions6.removedUser(userId)), dispatch(getUserList()), dispatch(setSnackbar4(userActions.remove.successMessage))])).catch((err) => userActionErrorHandler(err, "remove", dispatch))
);
var editUser = createAppAsyncThunk(
  `${sliceName6}/editUser`,
  ({ id, ...userData }, { dispatch, getState }) => general_api_default.put(`${useradmApiUrl}/users/${id}`, userData).then(
    () => Promise.all([
      dispatch(actions6.updatedUser({ ...userData, id: id === OWN_USER_ID ? getCurrentUser(getState()).id : id })),
      dispatch(setSnackbar4(userActions.edit.successMessage))
    ])
  ).catch((err) => userActionErrorHandler(err, "edit", dispatch))
);
var checkEmailExists = createAppAsyncThunk(`${sliceName6}/checkEmailExists`, async (email) => {
  const response = await general_api_default.get(`${useradmApiUrl}/users/exists?email=${encodeURIComponent(email)}`);
  return response.data.exists;
});
var addUserToCurrentTenant = createAppAsyncThunk(`${sliceName6}/addUserToTenant`, (userId, { dispatch, getState }) => {
  const { id } = getOrganization(getState());
  return general_api_default.post(`${useradmApiUrl}/users/${userId}/assign`, { tenant_ids: [id] }).catch((err) => commonErrorHandler(err, `There was an error adding the user to your organization:`, dispatch)).then(() => Promise.all([dispatch(setSnackbar4(userActions.add.successMessage)), dispatch(getUserList())]));
});
var enableUser2fa = createAppAsyncThunk(
  `${sliceName6}/enableUser2fa`,
  (userId = OWN_USER_ID, { dispatch }) => general_api_default.post(`${useradmApiUrl}/users/${userId}/2fa/enable`).catch((err) => commonErrorHandler(err, `There was an error enabling Two Factor authentication for the user.`, dispatch)).then(() => Promise.resolve(dispatch(getUser(userId))))
);
var disableUser2fa = createAppAsyncThunk(
  `${sliceName6}/disableUser2fa`,
  (userId = OWN_USER_ID, { dispatch }) => general_api_default.post(`${useradmApiUrl}/users/${userId}/2fa/disable`).catch((err) => commonErrorHandler(err, `There was an error disabling Two Factor authentication for the user.`, dispatch)).then(() => Promise.all([dispatch(getUser(userId)), dispatch(actions6.receivedQrCode(null))]))
);
var mapHttpPermission = (permission) => Object.entries(uiPermissionsByArea).reduce(
  (accu, [area, definition]) => {
    const endpointMatches = definition.endpoints.filter(
      (endpoint) => endpoint.path.test(permission.value) && (endpoint.types.includes(permission.type) || permission.type === PermissionTypes.Any)
    );
    if (permission.value === PermissionTypes.Any || permission.value.includes(apiRoot) && endpointMatches.length) {
      const endpointUiPermission = endpointMatches.reduce((endpointAccu, endpoint) => [...endpointAccu, ...endpoint.uiPermissions], []);
      const collector = (endpointUiPermission || definition.uiPermissions).reduce((permissionsAccu, uiPermission) => {
        if (permission.type === PermissionTypes.Any || !endpointMatches.length && uiPermission.verbs.some((verb) => verb === permission.type)) {
          permissionsAccu.push(uiPermission.value);
        }
        return permissionsAccu;
      }, []).filter(duplicateFilter);
      if (Array.isArray(accu[area])) {
        accu[area] = [...accu[area], ...collector].filter(duplicateFilter);
      } else {
        accu[area] = mergePermissions(accu[area], { [scopedPermissionAreas[area].excessiveAccessSelector]: collector });
      }
    }
    return accu;
  },
  { ...emptyUiPermissions }
);
var permissionActionTypes = {
  any: mapHttpPermission,
  CREATE_DEPLOYMENT: (permission) => permission.type === PermissionTypes.DeviceGroup ? {
    deployments: [uiPermissionsById.deploy.value],
    groups: { [permission.value]: [uiPermissionsById.deploy.value] }
  } : {},
  http: mapHttpPermission,
  REMOTE_TERMINAL: (permission) => permission.type === PermissionTypes.DeviceGroup ? {
    groups: { [permission.value]: [uiPermissionsById.connect.value] }
  } : {},
  VIEW_DEVICE: (permission) => permission.type === PermissionTypes.DeviceGroup ? {
    groups: { [permission.value]: [uiPermissionsById.read.value] }
  } : {}
};
var combinePermissions = (existingPermissions, additionalPermissions = {}) => Object.entries(additionalPermissions).reduce((accu, [name, permissions]) => {
  const maybeExistingPermissions = accu[name] || [];
  accu[name] = [...permissions, ...maybeExistingPermissions].filter(duplicateFilter);
  return accu;
}, existingPermissions);
var tryParseCustomPermission = (permission) => {
  const uiPermissions = permissionActionTypes[permission.action](permission.object);
  const result = mergePermissions({ ...emptyUiPermissions }, uiPermissions);
  return { isCustom: true, permission, result };
};
var customPermissionHandler = (accu, permission) => {
  const processor = tryParseCustomPermission(permission);
  return {
    ...accu,
    isCustom: accu.isCustom || processor.isCustom,
    uiPermissions: mergePermissions(accu.uiPermissions, processor.result)
  };
};
var mapPermissionSet = (permissionSetName, names, scope, existingGroupsPermissions = {}) => {
  const permission = Object.values(uiPermissionsById).find((permission2) => permission2.permissionSets[scope] === permissionSetName)?.value;
  const scopedPermissions = names.reduce((accu, name) => combinePermissions(accu, { [name]: [permission] }), existingGroupsPermissions);
  return Object.entries(scopedPermissions).reduce((accu, [key, permissions]) => ({ ...accu, [key]: deriveImpliedAreaPermissions(scope, permissions) }), {});
};
var isEmptyPermissionSet = (permissionSet) => !Object.values(permissionSet).reduce((accu, permissions) => {
  if (Array.isArray(permissions)) {
    return accu || !!permissions.length;
  }
  return accu || !isEmpty2(permissions);
}, false);
var parseRolePermissions = ({ permission_sets_with_scope = [], permissions = [] }, permissionSets) => {
  const preliminaryResult = permission_sets_with_scope.reduce(
    (accu, permissionSet) => {
      const processor = permissionSets[permissionSet.name];
      if (!processor) {
        return accu;
      }
      const scope = Object.keys(scopedPermissionAreas).find((scope2) => uiPermissionsByArea[scope2].scope === permissionSet.scope?.type);
      if (scope) {
        const result = mapPermissionSet(
          permissionSet.name,
          permissionSet.scope.value,
          scope,
          accu.uiPermissions[scope]
        );
        return { ...accu, uiPermissions: { ...accu.uiPermissions, [scope]: result } };
      } else if (isEmptyPermissionSet(processor.result)) {
        return processor.permissions?.reduce(customPermissionHandler, accu);
      }
      return {
        ...accu,
        isCustom: accu.isCustom || processor.isCustom,
        uiPermissions: mergePermissions(accu.uiPermissions, processor.result)
      };
    },
    { isCustom: false, uiPermissions: { ...emptyUiPermissions, groups: {}, releases: {} } }
  );
  return permissions.reduce(customPermissionHandler, preliminaryResult);
};
var normalizeRbacRoles = (roles, rolesById2, permissionSets) => roles.reduce(
  (accu, role) => {
    let normalizedPermissions;
    let isCustom = false;
    if (rolesById2[role.name]) {
      normalizedPermissions = {
        ...rolesById2[role.name].uiPermissions,
        groups: { ...rolesById2[role.name].uiPermissions.groups },
        releases: { ...rolesById2[role.name].uiPermissions.releases }
      };
    } else {
      const result = parseRolePermissions(role, permissionSets);
      normalizedPermissions = result.uiPermissions;
      isCustom = result.isCustom;
    }
    const roleState = accu[role.name] ?? { ...emptyRole };
    accu[role.name] = {
      ...roleState,
      ...role,
      description: roleState.description ? roleState.description : role.description,
      editable: !rolesById[role.name] && !isCustom && (typeof roleState.editable !== "undefined" ? roleState.editable : true),
      isCustom,
      name: roleState.name ? roleState.name : role.name,
      uiPermissions: normalizedPermissions
    };
    return accu;
  },
  { ...rolesById2 }
);
var getPermissionSets = createAppAsyncThunk(
  `${sliceName6}/getPermissionSets`,
  (_, { dispatch, getState }) => general_api_default.get(`${useradmApiUrlv2}/permission_sets?per_page=500`).then(({ data }) => {
    const permissionSets = data.reduce(
      (accu, permissionSet) => {
        const permissionSetState = accu[permissionSet.name] ?? {};
        let permissionSetObject = { ...permissionSetState, ...permissionSet };
        permissionSetObject.result = Object.values(uiPermissionsById).reduce(
          (accu2, item) => Object.entries(item.permissionSets).reduce((collector, [area, permissionSet2]) => {
            if (scopedPermissionAreas[area]) {
              return collector;
            }
            if (permissionSet2 === permissionSetObject.name) {
              collector[area] = [...collector[area], item.value].filter(duplicateFilter);
            }
            return collector;
          }, accu2),
          { ...emptyUiPermissions, ...permissionSetObject.result ?? {} }
        );
        const scopes = Object.values(scopedPermissionAreas).reduce((accu2, { key, scopeType }) => {
          if (permissionSetObject.supported_scope_types?.includes(key) || permissionSetObject.supported_scope_types?.includes(scopeType)) {
            accu2.push(key);
          }
          return accu2;
        }, []);
        permissionSetObject = scopes.reduce((accu2, scope) => {
          accu2.result = {
            ...accu2.result,
            [scope]: mapPermissionSet(permissionSetObject.name, [scopedPermissionAreas[scope].excessiveAccessSelector], scope)
          };
          return accu2;
        }, permissionSetObject);
        accu[permissionSet.name] = permissionSetObject;
        return accu;
      },
      { ...getState().users.permissionSetsById }
    );
    return Promise.all([dispatch(actions6.receivedPermissionSets(permissionSets)), permissionSets]);
  }).catch(() => console.log("Permission set retrieval failed - likely accessing a non-RBAC backend"))
);
var getRoles = createAppAsyncThunk(
  `${sliceName6}/getRoles`,
  (_, { dispatch, getState }) => Promise.all([general_api_default.get(`${useradmApiUrlv2}/roles?per_page=500`), dispatch(getPermissionSets())]).then((results) => {
    if (!results) {
      return Promise.resolve();
    }
    const [{ data: roles }, { payload: permissionSetTasks }] = results;
    const rolesById2 = normalizeRbacRoles(roles, getRolesById(getState()), permissionSetTasks[permissionSetTasks.length - 1]);
    return Promise.resolve(dispatch(actions6.receivedRoles(rolesById2)));
  }).catch(() => console.log("Role retrieval failed - likely accessing a non-RBAC backend")).finally(() => Promise.resolve(dispatch(actions6.finishedRoleInitialization(true))))
);
var deriveImpliedAreaPermissions = (area, areaPermissions, skipPermissions = []) => {
  const highestAreaPermissionLevelSelected = areaPermissions.reduce(
    (highest, current) => uiPermissionsById[current].permissionLevel > highest ? uiPermissionsById[current].permissionLevel : highest,
    1
  );
  return uiPermissionsByArea[area].uiPermissions.reduce((permissions, current) => {
    if ((current.permissionLevel < highestAreaPermissionLevelSelected || areaPermissions.includes(current.value)) && !skipPermissions.includes(current.value)) {
      permissions.push(current.value);
    }
    return permissions;
  }, []);
};
var transformAreaRoleDataToScopedPermissionsSets = (area, areaPermissions, excessiveAccessSelector) => {
  const permissionSetObject = areaPermissions.reduce((accu, { item, uiPermissions }) => {
    const skipPermissions = scopedPermissionAreas.releases.key === area && item !== ALL_RELEASES ? [uiPermissionsById.upload.value] : [];
    const impliedPermissions = deriveImpliedAreaPermissions(area, uiPermissions, skipPermissions);
    accu = impliedPermissions.reduce((itemPermissionAccu, impliedPermission) => {
      const permissionSetState = itemPermissionAccu[uiPermissionsById[impliedPermission].permissionSets[area]] ?? {
        type: uiPermissionsByArea[area].scope,
        value: []
      };
      itemPermissionAccu[uiPermissionsById[impliedPermission].permissionSets[area]] = {
        ...permissionSetState,
        value: [...permissionSetState.value, item]
      };
      return itemPermissionAccu;
    }, accu);
    return accu;
  }, {});
  return Object.entries(permissionSetObject).map(([name, { value, ...scope }]) => {
    if (value.includes(excessiveAccessSelector)) {
      return { name };
    }
    return { name, scope: { ...scope, value: value.filter(duplicateFilter) } };
  });
};
var transformRoleDataToRole = (roleData, roleState = {}) => {
  const role = { ...roleState, ...roleData };
  const { description = "", name, uiPermissions = emptyUiPermissions } = role;
  const { maybeUiPermissions, remainderKeys } = Object.entries(emptyUiPermissions).reduce(
    (accu, [key, emptyPermissions]) => {
      if (!scopedPermissionAreas[key]) {
        accu.remainderKeys.push(key);
      } else if (uiPermissions[key]) {
        accu.maybeUiPermissions[key] = uiPermissions[key].reduce(itemUiPermissionsReducer, emptyPermissions);
      }
      return accu;
    },
    { maybeUiPermissions: {}, remainderKeys: [] }
  );
  const { permissionSetsWithScope, roleUiPermissions } = remainderKeys.reduce(
    (accu, area) => {
      const areaPermissions = role.uiPermissions[area];
      if (!Array.isArray(areaPermissions)) {
        return accu;
      }
      const impliedPermissions = deriveImpliedAreaPermissions(area, areaPermissions);
      accu.roleUiPermissions[area] = impliedPermissions;
      const mappedPermissions = impliedPermissions.map((uiPermission) => ({ name: uiPermissionsById[uiPermission].permissionSets[area] }));
      accu.permissionSetsWithScope.push(...mappedPermissions);
      return accu;
    },
    { permissionSetsWithScope: [{ name: defaultPermissionSets.Basic.name }], roleUiPermissions: {} }
  );
  const scopedPermissionSets = Object.values(scopedPermissionAreas).reduce((accu, { key, excessiveAccessSelector }) => {
    if (!uiPermissions[key]) {
      return accu;
    }
    accu.push(
      ...transformAreaRoleDataToScopedPermissionsSets(
        key,
        uiPermissions[key],
        excessiveAccessSelector
      )
    );
    return accu;
  }, []);
  return {
    permissionSetsWithScope: [...permissionSetsWithScope, ...scopedPermissionSets],
    role: {
      ...emptyRole,
      name,
      description: description ? description : roleState.description || "",
      uiPermissions: {
        ...emptyUiPermissions,
        ...roleUiPermissions,
        ...maybeUiPermissions
      }
    }
  };
};
var roleActions = {
  create: {
    successMessage: "The role was created successfully.",
    errorMessage: "creating"
  },
  edit: {
    successMessage: "The role has been updated.",
    errorMessage: "editing"
  },
  remove: {
    successMessage: "The role was deleted successfully.",
    errorMessage: "removing"
  }
};
var roleActionErrorHandler = (err, type, dispatch, meta) => {
  let errorContext = `There was an error ${roleActions[type].errorMessage} the role.`;
  if (meta) {
    const { permissionSetsCreated, name } = meta;
    errorContext += ` Tried to ${type} role ${name} with ${permissionSetsCreated} permission sets.`;
  }
  return commonErrorHandler(err, errorContext, dispatch);
};
var createRole = createAppAsyncThunk(`${sliceName6}/createRole`, (roleData, { dispatch }) => {
  const { permissionSetsWithScope, role } = transformRoleDataToRole(roleData);
  return general_api_default.post(`${useradmApiUrlv2}/roles`, {
    name: role.name,
    description: role.description,
    permission_sets_with_scope: permissionSetsWithScope
  }).then(() => Promise.all([dispatch(actions6.createdRole(role)), dispatch(getRoles()), dispatch(setSnackbar4(roleActions.create.successMessage))])).catch((err) => roleActionErrorHandler(err, "create", dispatch, { permissionSetsCreated: permissionSetsWithScope.length, name: role.name }));
});
var editRole = createAppAsyncThunk(`${sliceName6}/editRole`, (roleData, { dispatch, getState }) => {
  const { permissionSetsWithScope, role } = transformRoleDataToRole(roleData, getRolesById(getState())[roleData.name]);
  return general_api_default.put(`${useradmApiUrlv2}/roles/${role.name}`, {
    description: role.description,
    name: role.name,
    permission_sets_with_scope: permissionSetsWithScope
  }).then(() => Promise.all([dispatch(actions6.createdRole(role)), dispatch(getRoles()), dispatch(setSnackbar4(roleActions.edit.successMessage))])).catch((err) => roleActionErrorHandler(err, "edit", dispatch, { permissionSetsCreated: permissionSetsWithScope.length, name: role.name }));
});
var removeRole = createAppAsyncThunk(
  `${sliceName6}/removeRole`,
  (roleId, { dispatch }) => general_api_default.delete(`${useradmApiUrlv2}/roles/${roleId}`).then(() => Promise.all([dispatch(actions6.removedRole(roleId)), dispatch(getRoles()), dispatch(setSnackbar4(roleActions.remove.successMessage))])).catch((err) => roleActionErrorHandler(err, "remove", dispatch))
);
var getGlobalSettings2 = createAppAsyncThunk(
  `${sliceName6}/getGlobalSettings`,
  (_, { dispatch }) => general_api_default.get(`${useradmApiUrl}/settings`).then(({ data: settings, headers: { etag } }) => {
    window.sessionStorage.setItem(settingsKeys.initialized, "true");
    return Promise.all([dispatch(actions6.setGlobalSettings(settings)), dispatch(setOfflineThreshold()), etag]);
  })
);
var saveGlobalSettings = createAppAsyncThunk(
  `${sliceName6}/saveGlobalSettings`,
  ({ beOptimistic = false, notify = false, ...settings }, { dispatch, getState }) => {
    if (!window.sessionStorage.getItem(settingsKeys.initialized) && !beOptimistic) {
      return;
    }
    return dispatch(getGlobalSettings2()).unwrap().then((result) => {
      const updatedSettings = { ...getState().users.globalSettings, ...settings };
      if (getCurrentUser(getState()).verified) {
        updatedSettings["2fa"] = twoFAStates.enabled;
      } else {
        delete updatedSettings["2fa"];
      }
      const tasks = [dispatch(actions6.setGlobalSettings(updatedSettings))];
      const headers = result[result.length - 1] ? { "If-Match": result[result.length - 1] } : {};
      return general_api_default.post(`${useradmApiUrl}/settings`, updatedSettings, { headers }).then(() => {
        if (notify) {
          tasks.push(dispatch(setSnackbar4("Settings saved successfully")));
        }
        return Promise.all(tasks);
      }).catch((err) => {
        if (beOptimistic) {
          return Promise.all([tasks]);
        }
        console.log(err);
        return commonErrorHandler(err, `The settings couldn't be saved.`, dispatch);
      });
    });
  }
);
var getUserSettings2 = createAppAsyncThunk(
  `${sliceName6}/getUserSettings`,
  (_, { dispatch }) => general_api_default.get(`${useradmApiUrl}/settings/me`).then(({ data: settings, headers: { etag } }) => {
    window.sessionStorage.setItem(settingsKeys.initialized, "true");
    return Promise.all([dispatch(actions6.setUserSettings(settings)), etag]);
  })
);
var saveUserSettings = createAppAsyncThunk(
  `${sliceName6}/saveUserSettings`,
  (settings = { onboarding: {} }, { dispatch, getState }) => {
    if (!getCurrentUser(getState()).id) {
      return Promise.resolve();
    }
    return dispatch(getUserSettings2()).unwrap().then((result) => {
      const userSettings = getUserSettings(getState());
      const onboardingState = getOnboardingState(getState());
      const tooltipState = getTooltipsState(getState());
      const updatedSettings = {
        ...userSettings,
        ...settings,
        onboarding: {
          ...onboardingState,
          ...settings.onboarding
        },
        tooltips: tooltipState
      };
      const headers = result[result.length - 1] ? { "If-Match": result[result.length - 1] } : {};
      return Promise.all([
        Promise.resolve(dispatch(actions6.setUserSettings(updatedSettings))),
        general_api_default.post(`${useradmApiUrl}/settings/me`, updatedSettings, { headers })
      ]).catch(() => dispatch(actions6.setUserSettings(userSettings)));
    });
  }
);
var get2FAQRCode = createAppAsyncThunk(
  `${sliceName6}/get2FAQRCode`,
  (_, { dispatch }) => general_api_default.get(`${useradmApiUrl}/2faqr`).then((res) => dispatch(actions6.receivedQrCode(res.data.qr)))
);
var setHideAnnouncement = createAppAsyncThunk(
  `${sliceName6}/setHideAnnouncement`,
  ({ shouldHide, userId }, { dispatch, getState }) => {
    const currentUserId = userId || getCurrentUser(getState()).id;
    const hash = getState().app.hostedAnnouncement ? hashString2(getState().app.hostedAnnouncement) : "";
    const announceCookie = cookies3.get(`${currentUserId}${hash}`);
    if (shouldHide || hash.length && typeof announceCookie !== "undefined") {
      cookies3.set(`${currentUserId}${hash}`, true, { maxAge: 604800 });
      dispatch(setAnnouncement2(""));
    }
  }
);
var getTokens = createAppAsyncThunk(
  `${sliceName6}/getTokens`,
  (_, { dispatch, getState }) => general_api_default.get(`${useradmApiUrl}/settings/tokens`).then(({ data: tokens }) => {
    const user = getCurrentUser(getState());
    const updatedUser = {
      ...user,
      tokens
    };
    return Promise.resolve(dispatch(actions6.updatedUser(updatedUser)));
  })
);
var ONE_YEAR = 31536e3;
var generateToken = createAppAsyncThunk(
  `${sliceName6}/generateToken`,
  ({ expiresIn = ONE_YEAR, name }, { dispatch }) => general_api_default.post(`${useradmApiUrl}/settings/tokens`, { name, expires_in: expiresIn }).then(({ data: token }) => Promise.all([dispatch(getTokens()), token])).catch((err) => commonErrorHandler(err, "There was an error creating the token:", dispatch))
);
var revokeToken = createAppAsyncThunk(
  `${sliceName6}/revokeToken`,
  (token, { dispatch }) => general_api_default.delete(`${useradmApiUrl}/settings/tokens/${token.id}`).then(() => Promise.resolve(dispatch(getTokens())))
);
var setTooltipReadState = createAppAsyncThunk(
  `${sliceName6}/setTooltipReadState`,
  async ({ persist, ...remainder }, { dispatch }) => {
    dispatch(actions6.setTooltipState(remainder));
    if (persist) {
      await dispatch(saveUserSettings());
    }
  }
);
var setAllTooltipsReadState = createAppAsyncThunk(
  `${sliceName6}/toggleHelptips`,
  ({ readState = READ_STATES.read, tooltipIds }, { dispatch }) => {
    const updatedTips = tooltipIds.reduce((accu, id) => ({ ...accu, [id]: { readState } }), {});
    return Promise.resolve(dispatch(actions6.setTooltipsState(updatedTips))).then(() => dispatch(saveUserSettings()));
  }
);
var submitFeedback = createAppAsyncThunk(
  `${sliceName6}/submitFeedback`,
  ({ satisfaction, feedback, ...meta }, { dispatch }) => general_api_default.post(`${tenantadmApiUrlv2}/contact/support`, {
    subject: "feedback submission",
    body: JSON.stringify({ feedback, satisfaction, meta })
  }).then(() => {
    const today = /* @__PURE__ */ new Date();
    dispatch(saveUserSettings({ feedbackCollectedAt: today.toISOString().split("T")[0] }));
    setTimeout(() => dispatch(actions6.setShowFeedbackDialog(false)), TIMEOUTS.threeSeconds);
  })
);

// src/appSlice/thunks.ts
var cookies4 = new Cookies4();
var setFirstLoginAfterSignup = createAppAsyncThunk(`${sliceName}/setFirstLoginAfterSignup`, (firstLoginAfterSignup, { dispatch }) => {
  cookies4.set("firstLoginAfterSignup", !!firstLoginAfterSignup, { maxAge: 60, path: "/", domain: ".mender.io", sameSite: false });
  dispatch(actions.setFirstLoginAfterSignup(!!firstLoginAfterSignup));
});
var dateFunctionMap = {
  getDays: "getDate",
  setDays: "setDate"
};
var setOfflineThreshold = createAppAsyncThunk(`${sliceName}/setOfflineThreshold`, (_, { dispatch, getState }) => {
  const { interval, intervalUnit } = getOfflineThresholdSettings(getState());
  const today = /* @__PURE__ */ new Date();
  const intervalName = `${intervalUnit.charAt(0).toUpperCase()}${intervalUnit.substring(1)}`;
  const setter = dateFunctionMap[`set${intervalName}`] ?? `set${intervalName}`;
  const getter = dateFunctionMap[`get${intervalName}`] ?? `get${intervalName}`;
  today[setter](today[getter]() - interval);
  let value;
  try {
    value = today.toISOString();
  } catch {
    return Promise.resolve(dispatch(actions.setSnackbar("There was an error saving the offline threshold, please check your settings.")));
  }
  return Promise.resolve(dispatch(actions.setOfflineThreshold(value)));
});
var versionRegex = new RegExp(/\d+\.\d+/);
var getLatestRelease = (thing) => {
  const latestKey = Object.keys(thing).filter((key) => versionRegex.test(key)).sort().reverse()[0];
  return thing[latestKey];
};
var repoKeyMap = {
  integration: "Integration",
  mender: "Mender-Client",
  "mender-artifact": "Mender-Artifact"
};
var deductSaasState = (latestRelease, guiTags) => {
  const latestGuiTag = guiTags.length ? guiTags[0].name : "";
  return latestGuiTag ? latestGuiTag : latestRelease.release;
};
var getLatestReleaseInfo = createAppAsyncThunk(`${sliceName}/getLatestReleaseInfo`, (_, { dispatch, getState }) => {
  if (!getFeatures(getState()).isHosted) {
    return Promise.resolve();
  }
  return Promise.all([general_api_default.get("/versions.json"), general_api_default.get("/tags.json")]).catch((err) => {
    console.log("init error:", extractErrorMessage3(err));
    return Promise.resolve([{ data: {} }, { data: [] }]);
  }).then(([{ data }, { data: guiTags }]) => {
    if (!guiTags.length) {
      return Promise.resolve();
    }
    const { releases } = data;
    const latestRelease = getLatestRelease(getLatestRelease(releases));
    const { latestRepos, latestVersions } = latestRelease.repos.reduce(
      (accu, item) => {
        if (repoKeyMap[item.name]) {
          accu.latestVersions[repoKeyMap[item.name]] = getComparisonCompatibleVersion(item.version);
        }
        accu.latestRepos[item.name] = getComparisonCompatibleVersion(item.version);
        return accu;
      },
      { latestVersions: { ...getState().app.versionInformation }, latestRepos: {} }
    );
    const info = deductSaasState(latestRelease, guiTags);
    return Promise.resolve(
      dispatch(
        actions.setVersionInformation({
          ...latestVersions,
          Server: info,
          latestRelease: {
            releaseDate: latestRelease.release_date,
            repos: latestRepos
          }
        })
      )
    );
  });
});
var setSearchState = createAppAsyncThunk(`${sliceName}/setSearchState`, (searchState, { dispatch, getState }) => {
  const currentState = getSearchState(getState());
  const nextState = {
    ...currentState,
    ...searchState,
    sort: {
      ...currentState.sort,
      ...searchState.sort
    }
  };
  const tasks = [];
  const { isSearching: currentSearching, deviceIds: currentDevices, searchTotal: currentTotal, ...currentRequestState } = currentState;
  const { isSearching: nextSearching, deviceIds: nextDevices, searchTotal: nextTotal, ...nextRequestState } = nextState;
  if (nextRequestState.searchTerm && !deepCompare4(currentRequestState, nextRequestState)) {
    nextState.isSearching = true;
    tasks.push(
      dispatch(searchDevices(nextState)).unwrap().then((results) => {
        const searchResult = results[results.length - 1];
        return dispatch(actions.setSearchState({ ...searchResult, isSearching: false }));
      }).catch(() => dispatch(actions.setSearchState({ isSearching: false, searchTotal: 0 })))
    );
  }
  tasks.push(dispatch(actions.setSearchState(nextState)));
  return Promise.all(tasks);
});

export {
  setFirstLoginAfterSignup,
  setOfflineThreshold,
  getLatestReleaseInfo,
  setSearchState,
  deriveDeploymentGroup,
  getDeploymentsByStatus2 as getDeploymentsByStatus,
  createDeployment,
  getDeploymentDevices,
  getDeviceDeployments,
  resetDeviceDeployments,
  getSingleDeployment,
  getDeviceLog,
  abortDeployment,
  updateDeploymentControlMap,
  setDeploymentsState,
  getDeploymentsConfig,
  saveDeltaDeploymentsConfig,
  getGroups,
  addDevicesToGroup,
  removeDevicesFromGroup,
  addStaticGroup,
  removeStaticGroup,
  getDynamicGroups,
  addDynamicGroup,
  updateDynamicGroup,
  removeDynamicGroup,
  selectGroup,
  getGroupDevices,
  getAllGroupDevices,
  getAllDynamicGroupDevices,
  getDeviceById2 as getDeviceById,
  getDeviceInfo,
  getDeviceCount,
  getAllDeviceCounts,
  getDeviceLimit,
  setDeviceListState,
  getDevicesByStatus,
  getAllDevicesByStatus,
  searchDevices,
  getDeviceAttributes,
  updateReportData,
  getReportDataWithoutBackendSupport,
  getDeviceConnect,
  triggerDeviceUpdate,
  getSessionDetails,
  getDeviceFileDownloadLink,
  deviceFileUpload,
  getDeviceAuth,
  getDevicesWithAuth,
  updateDeviceAuth,
  updateDevicesAuth,
  deleteAuthset,
  preauthDevice,
  decommissionDevice,
  getDeviceConfig,
  setDeviceConfig,
  applyDeviceConfig,
  setDeviceTags,
  getDeviceTwin,
  setDeviceTwin,
  getSystemDevices,
  getGatewayDevices,
  getOnboardingState2 as getOnboardingState,
  setOnboardingDeviceType,
  setOnboardingApproach,
  setOnboardingComplete,
  setOnboardingCanceled,
  advanceOnboarding,
  cancelRequest,
  getTargetLocation,
  createOrganizationTrial,
  startCardUpdate,
  confirmCardUpdate,
  getCurrentCard,
  startUpgrade,
  cancelUpgrade,
  completeUpgrade,
  getAuditLogs,
  getAuditLogsCsvLink,
  setAuditlogsState,
  tenantDataDivergedMessage,
  addTenant,
  getTenants,
  setTenantsListState,
  editTenantDeviceLimit,
  editBillingProfile,
  createBillingProfile,
  removeTenant,
  getUserOrganization,
  getUserBilling,
  getUserSubscription,
  getBillingPreview,
  getCurrentSubscription,
  requestPlanUpgrade,
  sendSupportMessage,
  requestPlanChange,
  downloadLicenseReport,
  createIntegration,
  changeIntegration,
  deleteIntegration,
  getIntegrations,
  getWebhookEvents,
  storeSsoConfig,
  changeSsoConfig,
  deleteSsoConfig,
  getSsoConfigById,
  getSsoConfigs,
  loginUser,
  logoutUser,
  switchUserOrganization,
  passwordResetStart,
  passwordResetComplete,
  verifyEmailStart,
  verifyEmailComplete,
  verify2FA,
  getUserList,
  getUser,
  initializeSelf,
  updateUserColumnSettings,
  createUser,
  removeUser,
  editUser,
  checkEmailExists,
  addUserToCurrentTenant,
  enableUser2fa,
  disableUser2fa,
  normalizeRbacRoles,
  getPermissionSets,
  getRoles,
  createRole,
  editRole,
  removeRole,
  getGlobalSettings2 as getGlobalSettings,
  saveGlobalSettings,
  getUserSettings2 as getUserSettings,
  saveUserSettings,
  get2FAQRCode,
  setHideAnnouncement,
  getTokens,
  generateToken,
  revokeToken,
  setTooltipReadState,
  setAllTooltipsReadState,
  submitFeedback
};
//# sourceMappingURL=chunk-3P3IE42O.js.map