declare const XML_METADATA_FORMAT = "xml";
declare const JSON_METADATA_FORMAT = "json";
declare const getSamlStartUrl: (id: any) => string;
declare const getOidcStartUrl: (id: any) => string;
declare const SSO_TYPES: {
    readonly saml: {
        readonly id: "saml";
        readonly type: "saml";
        readonly title: "SAML";
        readonly metadataFormat: "xml";
        readonly editorLanguage: "xml";
        readonly contentType: "application/samlmetadata+xml";
        readonly getStartUrl: (id: any) => string;
        readonly configDetails: readonly [{
            readonly key: "entityID";
            readonly label: "Entity ID";
            readonly getValue: (id: any) => string;
        }, {
            readonly key: "acs";
            readonly label: "ACS URL";
            readonly getValue: (id: any) => string;
        }, {
            readonly key: "startURL";
            readonly label: "Start URL";
            readonly getValue: (id: any) => string;
        }];
    };
    readonly oidc: {
        readonly id: "oidc";
        readonly type: "oidc";
        readonly title: "OpenID Connect";
        readonly metadataFormat: "json";
        readonly editorLanguage: "json";
        readonly contentType: "application/json";
        readonly getStartUrl: (id: any) => string;
        readonly configDetails: readonly [{
            readonly key: "startURL";
            readonly label: "Start Url";
            readonly getValue: (id: any) => string;
        }];
    };
};
type ContentType = (typeof SSO_TYPES)[keyof typeof SSO_TYPES]['contentType'];
declare const auditlogTypes: {
    artifact: {
        title: string;
        queryParameter: string;
        value: string;
    };
    deployment: {
        title: string;
        queryParameter: string;
        value: string;
    };
    device: {
        title: string;
        queryParameter: string;
        value: string;
    };
    user_access_token: {
        title: string;
        queryParameter: string;
        value: string;
    };
    user: {
        title: string;
        queryParameter: string;
        value: string;
    };
    tenant: {
        title: string;
        queryParameter: string;
        value: string;
    };
};
declare const AUDIT_LOGS_TYPES: {
    title: string;
    queryParameter: string;
    value: string;
}[];
declare const SP_AUDIT_LOGS_TYPES: {
    title: string;
    queryParameter: string;
    value: string;
}[];
declare const TENANT_LIST_DEFAULT: {
    page: number;
    perPage: number;
};

export { AUDIT_LOGS_TYPES, type ContentType, JSON_METADATA_FORMAT, SP_AUDIT_LOGS_TYPES, SSO_TYPES, TENANT_LIST_DEFAULT, XML_METADATA_FORMAT, auditlogTypes, getOidcStartUrl, getSamlStartUrl };
