import { AlertSubject } from './AlertSubject.js';
import './AlertDetails.js';
import './LineDescriptor.js';

type Alert = {
    /**
     * A unique ID for the alert.
     */
    id?: string;
    /**
     * The name of the alert.
     */
    name?: string;
    device_id: string;
    /**
     * Alert severity level
     */
    level?: Alert.level;
    subject: AlertSubject;
    /**
     * Time and date when the alert occurred
     */
    timestamp: string;
};
declare namespace Alert {
    /**
     * Alert severity level
     */
    enum level {
        OK = "OK",
        CRITICAL = "CRITICAL"
    }
}

export { Alert };
