import { AlertDetails } from './AlertDetails.js';
import './LineDescriptor.js';

/**
 * Alert subject: the description of the alert origin
 */
type AlertSubject = {
    /**
     * Name of an entity that caused the alert
     */
    name: string;
    /**
     * The type of executable that triggered the alert
     */
    type: string;
    /**
     * Status of an entity that caused the alert
     */
    status: string;
    details?: AlertDetails;
};

export type { AlertSubject };
