import { AWSCredentials } from './AWSCredentials.cjs';
import { AzureSharedAccessSecret } from './AzureSharedAccessSecret.cjs';
import { HTTP } from './HTTP.cjs';

type Credentials = {
    /**
     * The credential type
     */
    type: Credentials.type;
} & (AWSCredentials | AzureSharedAccessSecret | HTTP);
declare namespace Credentials {
    /**
     * The credential type
     */
    enum type {
        AWS = "aws",
        SAS = "sas",
        HTTP = "http"
    }
}

export { Credentials };
