"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/EditableLongText.tsx
var EditableLongText_exports = {};
__export(EditableLongText_exports, {
  EditableLongText: () => EditableLongText
});
module.exports = __toCommonJS(EditableLongText_exports);
var import_react3 = require("react");
var import_material3 = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_helpers2 = require("@northern.tech/utils/helpers");

// src/Confirm.tsx
var import_react = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var EditButton = ({ onClick, disabled = false }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { onClick, size: "small", disabled, startIcon: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Edit, {}), style: { padding: 5 }, children: "Edit" });
var ConfirmationButtons = ({ onConfirm, onCancel }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox", children: [
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onConfirm, size: "small", "aria-label": "confirm", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Check, { color: "disabled" }) }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onCancel, size: "small", "aria-label": "cancel", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Close, { color: "disabled" }) })
] });

// src/ExpandableAttribute.tsx
var import_react2 = require("react");
var import_icons_material2 = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_helpers = require("@northern.tech/utils/helpers");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"), 1);
var import_jsx_runtime2 = require("react/jsx-runtime");
var defaultClasses = { root: "attributes" };
var ExpandableAttribute = ({
  className = "",
  copyToClipboard,
  dividerDisabled,
  onExpansion,
  primary,
  secondary,
  secondaryTypographyProps = {},
  setSnackbar,
  style,
  textClasses,
  ...remainder
}) => {
  const textContent = (0, import_react2.useRef)(null);
  const [expanded, setExpanded] = (0, import_react2.useState)(false);
  const [overflowActive, setOverflowActive] = (0, import_react2.useState)(false);
  const [tooltipVisible, setTooltipVisible] = (0, import_react2.useState)(false);
  (0, import_react2.useEffect)(() => {
    if (textContent.current) {
      const overflowActiveCurrently = textContent.current.scrollWidth > textContent.current.clientWidth || textContent.current.scrollHeight > textContent.current.clientHeight;
      if (overflowActive !== overflowActiveCurrently && !expanded) {
        setOverflowActive(overflowActiveCurrently);
      }
    }
  }, [expanded, overflowActive, textContent]);
  const onClick = (0, import_react2.useCallback)(() => {
    if (copyToClipboard && setSnackbar) {
      (0, import_copy_to_clipboard.default)(secondary);
      setSnackbar("Value copied to clipboard");
    }
    if (!expanded && !!onExpansion) {
      onExpansion();
    }
    setExpanded(import_helpers.toggle);
  }, [copyToClipboard, expanded, onExpansion, secondary, setSnackbar]);
  const currentTextClasses = `${textClasses ? textClasses.secondary : "inventory-text"}${expanded && overflowActive ? " expanded-attribute" : ""}`;
  const secondaryText = /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("span", { className: currentTextClasses, ref: textContent, children: secondary }),
    " ",
    overflowActive ? /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("a", { children: [
      "show ",
      expanded ? "less" : "more"
    ] }) : null
  ] });
  const cssClasses = { ...defaultClasses, root: `${defaultClasses.root} ${copyToClipboard ? "copy-to-clipboard" : ""}`.trim() };
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { className, onClick, onMouseEnter: () => setTooltipVisible(true), onMouseLeave: () => setTooltipVisible(false), style, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.ListItem, { classes: cssClasses, divider: !dividerDisabled, ...remainder, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      import_material2.ListItemText,
      {
        primary,
        secondary: secondaryText,
        secondaryTypographyProps: { title: secondary, component: "div", ...secondaryTypographyProps }
      }
    ),
    copyToClipboard ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material2.FileCopyOutlined, { fontSize: "small" }) }) : null
  ] }) });
};
var ExpandableAttribute_default = ExpandableAttribute;

// src/EditableLongText.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  notes: { display: "block", whiteSpace: "pre-wrap" },
  // @ts-expect-error: type misalignment in styleOverride root type
  notesWrapper: { minWidth: theme.components?.MuiFormControl?.styleOverrides?.root?.minWidth }
}));
var EditableLongText = ({ contentFallback = "", fullWidth, original, onChange, placeholder = "-" }) => {
  const [isEditing, setIsEditing] = (0, import_react3.useState)(false);
  const [value, setValue] = (0, import_react3.useState)(original);
  const { classes } = useStyles();
  (0, import_react3.useEffect)(() => {
    setValue(original);
  }, [original]);
  const onCancelClick = () => {
    setValue(original);
    setIsEditing(false);
  };
  const onEdit = ({ target: { value: value2 } }) => setValue(value2);
  const onEditClick = () => setIsEditing(true);
  const onToggleEditing = (0, import_react3.useCallback)(
    (event) => {
      event.stopPropagation();
      if (event.key && (event.key !== "Enter" || event.shiftKey)) {
        return;
      }
      if (isEditing) {
        onChange(value);
      }
      setIsEditing(import_helpers2.toggle);
    },
    [isEditing, onChange, value]
  );
  const fullWidthClass = fullWidth ? "full-width" : "";
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "flexbox", style: { alignItems: "end" }, children: isEditing ? /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_jsx_runtime3.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
      import_material3.TextField,
      {
        className: `margin-right ${fullWidthClass}`,
        multiline: true,
        onChange: onEdit,
        onKeyDown: onToggleEditing,
        placeholder,
        value
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(ConfirmationButtons, { onCancel: onCancelClick, onConfirm: onToggleEditing })
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_jsx_runtime3.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
      ExpandableAttribute_default,
      {
        className: `${fullWidthClass} margin-right ${classes.notesWrapper}`,
        component: "div",
        dense: true,
        disableGutters: true,
        primary: "",
        secondary: original || value || contentFallback,
        textClasses: { secondary: classes.notes }
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(EditButton, { onClick: onEditClick })
  ] }) });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EditableLongText
});
//# sourceMappingURL=EditableLongText.cjs.map