import {
  MenderTooltip_default
} from "./chunk-6YMQVQXN.js";

// src/Pagination.tsx
import { memo, useEffect, useState } from "react";
import { KeyboardArrowLeft, KeyboardArrowRight } from "@mui/icons-material";
import { IconButton, TablePagination } from "@mui/material";
import { DEVICE_LIST_DEFAULTS, DEVICE_LIST_MAXIMUM_LENGTH, TIMEOUTS } from "@northern.tech/store/constants";
import { useDebounce } from "@northern.tech/utils/debouncehook";
import { jsx, jsxs } from "react/jsx-runtime";
var defaultRowsPerPageOptions = [10, 20, DEVICE_LIST_MAXIMUM_LENGTH];
var { perPage: defaultPerPage } = DEVICE_LIST_DEFAULTS;
var paginationIndex = 1;
var paginationLimit = 1e4;
var MaybeWrapper = ({ children, disabled }) => disabled ? /* @__PURE__ */ jsx(MenderTooltip_default, { arrow: true, placement: "top", title: "Please refine your filter criteria first in order to proceed.", children: /* @__PURE__ */ jsx("div", { children }) }) : /* @__PURE__ */ jsx("div", { children });
var TablePaginationActions = ({ count, page = 0, onPageChange, rowsPerPage = defaultPerPage, showCountInfo = true }) => {
  const [pageNo, setPageNo] = useState(page + paginationIndex);
  useEffect(() => {
    setPageNo(page + paginationIndex);
  }, [page, rowsPerPage, count]);
  const debouncedPage = useDebounce(pageNo, TIMEOUTS.debounceShort);
  useEffect(() => {
    const newPage = Math.min(Math.max(paginationIndex, debouncedPage), Math.max(paginationIndex, Math.ceil(count / rowsPerPage)));
    if (newPage !== page + paginationIndex) {
      onPageChange(newPage);
    }
  }, [count, debouncedPage, onPageChange, page, rowsPerPage]);
  const pages = Math.ceil(count / rowsPerPage);
  const isAtPaginationLimit = pageNo >= paginationLimit / rowsPerPage;
  return /* @__PURE__ */ jsxs("div", { className: "flexbox center-aligned", children: [
    showCountInfo && /* @__PURE__ */ jsx("div", { children: `${(pageNo - paginationIndex) * rowsPerPage + 1}-${Math.min(pageNo * rowsPerPage, count)} of ${count}` }),
    /* @__PURE__ */ jsx(IconButton, { onClick: () => setPageNo(pageNo - 1), disabled: pageNo === paginationIndex, size: "large", "aria-label": "prev", children: /* @__PURE__ */ jsx(KeyboardArrowLeft, {}) }),
    /* @__PURE__ */ jsx(MaybeWrapper, { disabled: isAtPaginationLimit, children: /* @__PURE__ */ jsx(IconButton, { onClick: () => setPageNo(pageNo + 1), disabled: pageNo >= pages || isAtPaginationLimit, size: "large", "aria-label": "next", children: /* @__PURE__ */ jsx(KeyboardArrowRight, {}) }) })
  ] });
};
var Pagination = (props) => {
  const { className, onChangeRowsPerPage, onChangePage, page = 0, rowsPerPageOptions = defaultRowsPerPageOptions, showCountInfo, ...remainingProps } = props;
  const propsPage = Math.max(page - paginationIndex, 0);
  return /* @__PURE__ */ jsx(
    TablePagination,
    {
      className: `flexbox margin-top ${className || ""}`,
      classes: { spacer: "flexbox no-basis" },
      component: "div",
      labelDisplayedRows: () => "",
      labelRowsPerPage: "Rows",
      slotProps: { select: { name: "pagination" } },
      rowsPerPageOptions,
      onRowsPerPageChange: (e) => onChangeRowsPerPage(e.target.value),
      page: propsPage,
      onPageChange: onChangePage,
      ActionsComponent: (actionProps) => /* @__PURE__ */ jsx(TablePaginationActions, { ...actionProps, showCountInfo }),
      ...remainingProps
    }
  );
};
var areEqual = (prevProps, nextProps) => Math.floor(prevProps.count / prevProps.rowsPerPage) === Math.floor(nextProps.count / nextProps.rowsPerPage) && prevProps.page === nextProps.page && prevProps.rowsPerPage === nextProps.rowsPerPage && prevProps.disabled === nextProps.disabled;
var Pagination_default = memo(Pagination, areEqual);

export {
  TablePaginationActions,
  Pagination_default
};
//# sourceMappingURL=chunk-LOMBHKTZ.js.map