import {
  UserChange
} from "./chunk-EGAFGAOG.js";
import {
  DeviceConfiguration_default
} from "./chunk-RYIX3CGY.js";
import {
  FallbackComponent_default
} from "./chunk-4HUJEAGX.js";
import {
  FileTransfer_default
} from "./chunk-L7BXKSN6.js";
import {
  PortForward_default
} from "./chunk-53DSLQTC.js";
import {
  TerminalSession_default
} from "./chunk-U2F7NBPO.js";

// src/auditlogs/EventDetailsDrawerContentMap.tsx
var changeTypes = {
  user: "user",
  device: "device",
  tenant: "tenant"
};
var configChangeDescriptor = {
  set_configuration: "definition",
  deploy_configuration: "deployment"
};
var EventDetailsDrawerContentMap = (item, FallbackComponent = FallbackComponent_default) => {
  const { type } = item.object || {};
  let content = { title: "Entry details", content: FallbackComponent };
  if (type === changeTypes.user) {
    content = { title: `${item.action}d user`, content: UserChange };
  } else if (type === changeTypes.device && item.action.includes("terminal")) {
    content = { title: "Remote session log", content: TerminalSession_default };
  } else if (type === changeTypes.device && item.action.includes("file")) {
    content = { title: "File transfer", content: FileTransfer_default };
  } else if (type === changeTypes.device && item.action.includes("portforward")) {
    content = { title: "Port forward", content: PortForward_default };
  } else if (type === changeTypes.device && item.action.includes("configuration")) {
    content = { title: `Device configuration ${configChangeDescriptor[item.action] || ""}`, content: DeviceConfiguration_default };
  } else if (type === changeTypes.device) {
    content = { title: "Device change", content: FallbackComponent };
  } else if (type === changeTypes.tenant) {
    content = { title: `${item.action}d tenant`, content: UserChange };
  }
  return content;
};
var EventDetailsDrawerContentMap_default = EventDetailsDrawerContentMap;

export {
  EventDetailsDrawerContentMap_default
};
//# sourceMappingURL=chunk-A33MALPY.js.map