import {
  DetailInformation,
  DeviceDetails_default
} from "./chunk-LHTCZWYC.js";

// src/auditlogs/eventdetails/FileTransfer.tsx
import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useTheme } from "@mui/material/styles";
import Loader from "@northern.tech/common-ui/Loader";
import { getAuditlogDevice, getIdAttribute, getUserCapabilities } from "@northern.tech/store/selectors";
import { getDeviceById } from "@northern.tech/store/thunks";
import { jsx, jsxs } from "react/jsx-runtime";
var FileTransfer = ({ item, onClose }) => {
  const dispatch = useDispatch();
  const {
    actor,
    meta: { path = [] },
    object = {}
  } = item;
  const device = useSelector(getAuditlogDevice);
  const { canReadDevices } = useSelector(getUserCapabilities);
  const idAttribute = useSelector(getIdAttribute);
  const theme = useTheme();
  useEffect(() => {
    if (canReadDevices) {
      dispatch(getDeviceById(object.id));
    }
  }, [canReadDevices, dispatch, object.id]);
  if (canReadDevices && !device) {
    return /* @__PURE__ */ jsx(Loader, { show: true });
  }
  const sessionMeta = {
    Path: path.join(","),
    User: actor.email
  };
  return /* @__PURE__ */ jsxs("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ jsx(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ jsx(DetailInformation, { title: "file transfer", details: sessionMeta })
  ] });
};
var FileTransfer_default = FileTransfer;

export {
  FileTransfer,
  FileTransfer_default
};
//# sourceMappingURL=chunk-L7BXKSN6.js.map