// src/onboardingSlice/index.ts
import { createSlice } from "@reduxjs/toolkit";
var sliceName = "onboarding";
var initialState = {
  approach: null,
  complete: false,
  deviceType: null,
  demoArtifactPort: 85,
  progress: null,
  showTips: null,
  showTipsDialog: false
};
var onboardingSlice = createSlice({
  name: sliceName,
  initialState,
  reducers: {
    setOnboardingState: (state, action) => ({ ...state, ...action.payload }),
    setDemoArtifactPort: (state, action) => {
      state.demoArtifactPort = action.payload;
    },
    setShowOnboardingHelp: (state, action) => {
      state.showTips = action.payload;
    },
    setShowDismissOnboardingTipsDialog: (state, action) => {
      state.showTipsDialog = action.payload;
    },
    setOnboardingComplete: (state, action) => {
      state.complete = action.payload;
    },
    setOnboardingProgress: (state, action) => {
      state.progress = action.payload;
    },
    setOnboardingDeviceType: (state, action) => {
      state.deviceType = action.payload;
    },
    setOnboardingApproach: (state, action) => {
      state.approach = action.payload;
    }
  }
});
var actions = onboardingSlice.actions;
var onboardingSlice_default = onboardingSlice.reducer;

export {
  sliceName,
  initialState,
  onboardingSlice,
  actions,
  onboardingSlice_default
};
//# sourceMappingURL=chunk-VANBSJS5.js.map