"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/constants.ts
var constants_exports = {};
__export(constants_exports, {
  ADDONS: () => ADDONS,
  ALL_DEVICES: () => import_constants6.ALL_DEVICES,
  ALL_DEVICE_STATES: () => import_constants6.ALL_DEVICE_STATES,
  ALL_RELEASES: () => import_constants6.ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE: () => import_constants6.APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE: () => import_constants6.APPLICATION_JWT_CONTENT_TYPE,
  ARTIFACT_GENERATION_TYPE: () => ARTIFACT_GENERATION_TYPE,
  ATTRIBUTE_SCOPES: () => import_constants6.ATTRIBUTE_SCOPES,
  AUDIT_LOGS_TYPES: () => AUDIT_LOGS_TYPES,
  BEGINNING_OF_TIME: () => BEGINNING_OF_TIME,
  BENEFITS: () => BENEFITS,
  DARK_MODE: () => DARK_MODE,
  DEFAULT_PENDING_INPROGRESS_COUNT: () => DEFAULT_PENDING_INPROGRESS_COUNT,
  DEPLOYMENT_ROUTES: () => DEPLOYMENT_ROUTES,
  DEPLOYMENT_STATES: () => DEPLOYMENT_STATES,
  DEPLOYMENT_TYPES: () => DEPLOYMENT_TYPES,
  DEVICE_CONNECT_STATES: () => DEVICE_CONNECT_STATES,
  DEVICE_DISMISSAL_STATE: () => DEVICE_DISMISSAL_STATE,
  DEVICE_FILTERING_OPTIONS: () => import_constants6.DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS: () => import_constants6.DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS: () => import_constants6.DEVICE_LIST_DEFAULTS,
  DEVICE_LIST_MAXIMUM_LENGTH: () => DEVICE_LIST_MAXIMUM_LENGTH,
  DEVICE_MESSAGE_PROTOCOLS: () => DEVICE_MESSAGE_PROTOCOLS,
  DEVICE_MESSAGE_TYPES: () => DEVICE_MESSAGE_TYPES,
  DEVICE_ONLINE_CUTOFF: () => DEVICE_ONLINE_CUTOFF,
  DEVICE_STATES: () => import_constants6.DEVICE_STATES,
  EXTERNAL_PROVIDER: () => EXTERNAL_PROVIDER,
  JSON_METADATA_FORMAT: () => JSON_METADATA_FORMAT,
  LIGHT_MODE: () => LIGHT_MODE,
  MAX_PAGE_SIZE: () => MAX_PAGE_SIZE,
  OWN_USER_ID: () => OWN_USER_ID,
  PLANS: () => PLANS,
  PermissionTypes: () => import_constants6.PermissionTypes,
  READ_STATES: () => READ_STATES,
  REPORT_CHART_SIZE_LIMIT: () => REPORT_CHART_SIZE_LIMIT,
  SORTING_OPTIONS: () => import_constants6.SORTING_OPTIONS,
  SP_AUDIT_LOGS_TYPES: () => SP_AUDIT_LOGS_TYPES,
  SSO_TYPES: () => SSO_TYPES,
  TENANT_LIST_DEFAULT: () => TENANT_LIST_DEFAULT,
  TIMEOUTS: () => TIMEOUTS,
  UNGROUPED_GROUP: () => UNGROUPED_GROUP,
  USER_LOGOUT: () => USER_LOGOUT,
  XML_METADATA_FORMAT: () => XML_METADATA_FORMAT,
  alertChannels: () => import_constants6.alertChannels,
  apiRoot: () => import_constants6.apiRoot,
  apiUrl: () => import_constants6.apiUrl,
  auditLogsApiUrl: () => import_constants6.auditLogsApiUrl,
  auditlogTypes: () => auditlogTypes,
  canAccess: () => canAccess,
  chartTypes: () => chartTypes,
  checkPermissionsObject: () => checkPermissionsObject,
  countries: () => countries,
  credentialTypes: () => credentialTypes,
  currentArtifact: () => currentArtifact,
  defaultIdAttribute: () => defaultIdAttribute,
  defaultPermissionSets: () => import_constants6.defaultPermissionSets,
  defaultReportType: () => defaultReportType,
  defaultReports: () => defaultReports,
  defaultStats: () => defaultStats,
  deploymentDisplayStates: () => deploymentDisplayStates,
  deploymentPrototype: () => deploymentPrototype,
  deploymentStatesToSubstates: () => deploymentStatesToSubstates,
  deploymentStatesToSubstatesWithSkipped: () => deploymentStatesToSubstatesWithSkipped,
  deploymentSubstates: () => deploymentSubstates,
  deploymentsApiUrl: () => import_constants6.deploymentsApiUrl,
  deploymentsApiUrlV2: () => import_constants6.deploymentsApiUrlV2,
  deviceAuthV2: () => import_constants6.deviceAuthV2,
  deviceConfig: () => import_constants6.deviceConfig,
  deviceConnect: () => import_constants6.deviceConnect,
  emptyChartSelection: () => emptyChartSelection,
  emptyFilter: () => emptyFilter,
  emptyRole: () => import_constants6.emptyRole,
  emptyUiPermissions: () => import_constants6.emptyUiPermissions,
  emptyWebhook: () => emptyWebhook,
  geoAttributes: () => geoAttributes,
  getOidcStartUrl: () => getOidcStartUrl,
  getSamlStartUrl: () => getSamlStartUrl,
  headerNames: () => import_constants6.headerNames,
  installationSubstatesMap: () => installationSubstatesMap,
  inventoryApiUrl: () => import_constants6.inventoryApiUrl,
  inventoryApiUrlV2: () => import_constants6.inventoryApiUrlV2,
  iotManagerBaseURL: () => import_constants6.iotManagerBaseURL,
  itemUiPermissionsReducer: () => itemUiPermissionsReducer,
  limitDefault: () => import_constants6.limitDefault,
  listDefaultsByState: () => listDefaultsByState,
  locations: () => locations,
  maxSessionAge: () => import_constants6.maxSessionAge,
  monitorApiUrlv1: () => import_constants6.monitorApiUrlv1,
  onboardingSteps: () => onboardingSteps,
  orderedOnboardingSteps: () => orderedOnboardingSteps,
  pauseMap: () => pauseMap,
  reportingApiUrl: () => import_constants6.reportingApiUrl,
  rolesById: () => import_constants6.rolesById,
  rolesByName: () => import_constants6.rolesByName,
  rootfsImageVersion: () => rootfsImageVersion,
  scopedPermissionAreas: () => import_constants6.scopedPermissionAreas,
  serviceProviderRolesById: () => import_constants6.serviceProviderRolesById,
  settingsKeys: () => settingsKeys,
  softwareIndicator: () => softwareIndicator,
  softwareTitleMap: () => softwareTitleMap,
  ssoIdpApiUrlv1: () => import_constants6.ssoIdpApiUrlv1,
  tenantadmApiUrlv1: () => import_constants6.tenantadmApiUrlv1,
  tenantadmApiUrlv2: () => import_constants6.tenantadmApiUrlv2,
  timeUnits: () => timeUnits,
  twoFAStates: () => import_constants6.twoFAStates,
  uiPermissionsByArea: () => import_constants6.uiPermissionsByArea,
  uiPermissionsById: () => import_constants6.uiPermissionsById,
  useradmApiUrl: () => import_constants6.useradmApiUrl,
  useradmApiUrlv1: () => import_constants6.useradmApiUrlv1,
  useradmApiUrlv2: () => import_constants6.useradmApiUrlv2,
  yes: () => yes
});
module.exports = __toCommonJS(constants_exports);
var import_constants6 = require("@northern.tech/utils/constants");

// src/appSlice/constants.ts
var import_icons_material = require("@mui/icons-material");
var startingDeviceCount = {
  os: "for first 50 devices",
  professional: "for first 250 devices"
};
var chartTypes = {
  bar: { key: "bar", Icon: import_icons_material.BarChart },
  pie: { key: "pie", Icon: import_icons_material.PieChartOutline }
};
var emptyChartSelection = { software: "", group: "", chartType: chartTypes.bar.key, attribute: "artifact_name" };
var defaultReportType = "distribution";
var defaultReports = [{ ...emptyChartSelection, group: null, attribute: "artifact_name", type: defaultReportType }];
var BEGINNING_OF_TIME = "2016-01-01T00:00:00.000Z";
var locations = {
  eu: { key: "eu", title: "EU", location: "eu.hosted.mender.io" },
  us: { key: "us", title: "US", location: "hosted.mender.io" }
};
var PLANS = {
  os: {
    id: "os",
    name: "Basic",
    minimalDeviceCount: 50,
    offer: true,
    price: "$34 / month",
    deviceCount: startingDeviceCount.os,
    description: "The core features of Mender. To continue using Enterprise Trial features\u2014like Delta updates, scheduled deployments, phased rollouts, device filtering, dynamic groups, RBAC, audit logs, and more\u2014please upgrade to a higher plan.",
    features: ["Access to core features of Mender", "Basic support"]
  },
  professional: {
    id: "professional",
    name: "Professional",
    minimalDeviceCount: 250,
    offer: true,
    price: "$291 / month",
    deviceCount: startingDeviceCount.professional,
    description: "Everything in Basic, plus enhanced update management and automation features.",
    features: ["Advanced OTA features", "Higher priority support"]
  },
  enterprise: {
    id: "enterprise",
    name: "Enterprise",
    minimalDeviceCount: 1e3,
    price: "Custom pricing",
    deviceCount: "Unlimited devices",
    description: "Every advanced feature of Mender, tailored for complex and large-scale deployments. Not available as a monthly subscription \u2014 ask us for a quote.",
    features: ["All Mender features", "Advanced security features", "SLA-backed support"]
  }
};
var ADDONS = {
  configure: {
    id: "configure",
    title: "Configure",
    description: "Expand your plan with device configuration features",
    needs: ["hasDeviceConfig"],
    os: {
      price: "$11/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$65/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  },
  monitor: {
    id: "monitor",
    title: "Monitor",
    description: "Expand your plan with device monitoring features",
    needs: ["hasMonitor"],
    os: {
      price: "-",
      deviceCount: "-"
    },
    professional: {
      price: "$86/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["professional", "enterprise"]
  },
  troubleshoot: {
    id: "troubleshoot",
    title: "Troubleshoot",
    description: "Expand your plan with device troubleshooting features",
    needs: ["hasDeviceConnect"],
    os: {
      price: "$27/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$72/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  }
};
var BENEFITS = {
  auditlog: { id: "auditlog", benefit: "trace change across your devices and access troubleshooting session replay", requiredPlan: PLANS.professional.id },
  dashboard: { id: "dashboard", benefit: "actionable insights into the devices you are updating with Mender", requiredPlan: PLANS.enterprise.id },
  deltaGeneration: {
    id: "deltaGeneration",
    benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery",
    requiredPlan: PLANS.enterprise.id
  },
  deviceConfiguration: { id: "deviceConfiguration", benefit: "device configuration features", requiredAddon: ADDONS.configure.id },
  deviceMonitor: { id: "deviceMonitor", benefit: "device monitoring features", requiredAddon: ADDONS.monitor.id, requiredPlan: PLANS.professional.id },
  deviceTroubleshoot: { id: "deviceTroubleshoot", benefit: "device troubleshooting features", requiredAddon: ADDONS.troubleshoot.id },
  dynamicGroups: { id: "dynamicGroups", benefit: "create dynamic groups to ease device management", requiredPlan: PLANS.enterprise.id },
  fullFiltering: { id: "fullFiltering", benefit: "filtering by multiple attributes to improve the device overview", requiredPlan: PLANS.professional.id },
  gateway: { id: "gateway", benefit: "see devices connected to your gateway device for easy access", requiredPlans: PLANS.professional.id },
  pausedDeployments: {
    id: "pausedDeployments",
    benefit: "granular control about update rollout to allow synchronization across your fleet",
    requiredPlan: PLANS.enterprise.id
  },
  phasedDeployments: { id: "phasedDeployments", benefit: "choose to roll out deployments in multiple phases", requiredPlan: PLANS.enterprise.id },
  rbac: { id: "rbac", benefit: "granular role based access control", requiredPlan: PLANS.enterprise.id },
  retryDeployments: { id: "retryDeployments", benefit: "optional retries for failed rollout attempts", requiredPlan: PLANS.professional.id },
  scheduledDeployments: {
    id: "scheduledDeployments",
    benefit: "scheduled deployments to steer the distribution of your updates.",
    requiredPlan: PLANS.professional.id
  },
  webhookEvents: {
    id: "webhookEvents",
    benefit: "receive inventory events and select which type(s) of events the webhook will receive",
    requiredPlan: PLANS.professional.id
  },
  default: { id: "default", benefit: "gain access to this feature", requiredPlan: PLANS.enterprise.id }
};
var yes = () => true;
var canAccess = yes;
var DARK_MODE = "dark";
var LIGHT_MODE = "light";

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var DEVICE_LIST_MAXIMUM_LENGTH = 50;
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants6.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var MAX_PAGE_SIZE = 500;
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants6.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants6.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants6.SORTING_OPTIONS.desc }
};
var DEFAULT_PENDING_INPROGRESS_COUNT = 10;
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var DEPLOYMENT_TYPES = {
  software: "software",
  configuration: "configuration"
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentDisplayStates = {
  finished: "Finished",
  scheduled: "Scheduled",
  skipped: "Skipped",
  paused: "Paused",
  pending: "Pending",
  inprogress: "In Progress",
  success: "Success",
  successes: "Success",
  failure: "Fail",
  failures: "Fail"
};
var deploymentPrototype = {
  devices: {},
  name: void 0,
  statistics: { status: {} }
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/devicesSlice/constants.ts
var emptyFilter = { key: null, value: "", operator: import_constants6.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "inventory" };
var DEVICE_MESSAGE_PROTOCOLS = {
  Shell: 1
};
var DEVICE_MESSAGE_TYPES = {
  Delay: "delay",
  New: "new",
  Ping: "ping",
  Pong: "pong",
  Resize: "resize",
  Shell: "shell",
  Stop: "stop"
};
var DEVICE_DISMISSAL_STATE = "dismiss";
var DEVICE_CONNECT_STATES = {
  connected: "connected",
  disconnected: "disconnected",
  unknown: "unknown"
};
var geoAttributes = ["geo-lat", "geo-lon"].map((attribute) => ({ attribute, scope: "inventory" }));
var REPORT_CHART_SIZE_LIMIT = 6;

// src/onboardingSlice/constants.ts
var onboardingSteps = {
  ONBOARDING_START: "onboarding-start",
  DEVICES_PENDING_ONBOARDING_START: "devices-pending-onboarding-start",
  DASHBOARD_ONBOARDING_START: "dashboard-onboarding-start",
  DASHBOARD_ONBOARDING_PENDINGS: "dashboard-onboarding-pendings",
  DEVICES_DELAYED_ONBOARDING: "devices-delayed-onboarding",
  DEVICES_PENDING_ONBOARDING: "devices-pending-onboarding",
  DEVICES_ACCEPTED_ONBOARDING: "devices-accepted-onboarding",
  DEVICES_PENDING_ACCEPTING_ONBOARDING: "devices-pending-accepting-onboarding",
  DEVICES_DEPLOY_RELEASE_ONBOARDING: "devices-deploy-release-onboarding",
  SCHEDULING_ARTIFACT_SELECTION: "scheduling-artifact-selection",
  SCHEDULING_ALL_DEVICES_SELECTION: "scheduling-all-devices-selection",
  SCHEDULING_GROUP_SELECTION: "scheduling-group-selection",
  SCHEDULING_RELEASE_TO_DEVICES: "scheduling-release-to-devices",
  DEPLOYMENTS_INPROGRESS: "deployments-inprogress",
  DEPLOYMENTS_COMPLETED: "deployments-completed",
  DEPLOYMENTS_PAST: "deployments-past",
  DEPLOYMENTS_PAST_COMPLETED: "deployments-past-completed",
  DEPLOYMENTS_PAST_COMPLETED_FAILURE: "deployments-past-completed-failure",
  ONBOARDING_CANCELED: "onboarding-canceled"
};
var orderedOnboardingSteps = [
  onboardingSteps.DASHBOARD_ONBOARDING_START,
  onboardingSteps.DEVICES_PENDING_ONBOARDING_START,
  onboardingSteps.DEVICES_DELAYED_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ONBOARDING,
  onboardingSteps.DEVICES_PENDING_ACCEPTING_ONBOARDING,
  onboardingSteps.DASHBOARD_ONBOARDING_PENDINGS,
  onboardingSteps.DEVICES_ACCEPTED_ONBOARDING,
  onboardingSteps.DEVICES_DEPLOY_RELEASE_ONBOARDING,
  onboardingSteps.SCHEDULING_ALL_DEVICES_SELECTION,
  onboardingSteps.SCHEDULING_GROUP_SELECTION,
  onboardingSteps.SCHEDULING_ARTIFACT_SELECTION,
  onboardingSteps.SCHEDULING_RELEASE_TO_DEVICES,
  onboardingSteps.DEPLOYMENTS_INPROGRESS,
  onboardingSteps.DEPLOYMENTS_PAST,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED,
  onboardingSteps.DEPLOYMENTS_PAST_COMPLETED_FAILURE,
  onboardingSteps.ONBOARDING_CANCELED
];

// src/organizationSlice/constants.ts
var XML_METADATA_FORMAT = "xml";
var JSON_METADATA_FORMAT = "json";
var getSamlStartUrl = (id) => `${window.location.origin}${import_constants6.useradmApiUrl}/auth/sso/${id}/login`;
var getOidcStartUrl = (id) => `${window.location.origin}${import_constants6.useradmApiUrl}/oidc/${id}/start`;
var SSO_TYPES = {
  saml: {
    id: "saml",
    type: "saml",
    title: "SAML",
    metadataFormat: XML_METADATA_FORMAT,
    editorLanguage: XML_METADATA_FORMAT,
    contentType: "application/samlmetadata+xml",
    getStartUrl: getSamlStartUrl,
    configDetails: [
      { key: "entityID", label: "Entity ID", getValue: (id) => `${window.location.origin}${import_constants6.useradmApiUrl}/sso/sp/metadata/${id}` },
      { key: "acs", label: "ACS URL", getValue: (id) => `${window.location.origin}${import_constants6.useradmApiUrl}/auth/sso/${id}/acs` },
      { key: "startURL", label: "Start URL", getValue: getSamlStartUrl }
    ]
  },
  oidc: {
    id: "oidc",
    type: "oidc",
    title: "OpenID Connect",
    metadataFormat: JSON_METADATA_FORMAT,
    editorLanguage: JSON_METADATA_FORMAT,
    contentType: "application/json",
    getStartUrl: getOidcStartUrl,
    configDetails: [{ key: "startURL", label: "Start Url", getValue: getOidcStartUrl }]
  }
};
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};

// src/releasesSlice/constants.ts
var ARTIFACT_GENERATION_TYPE = { SINGLE_FILE: "single_file" };
var currentArtifact = "artifact_name";
var softwareIndicator = ".version";
var rootfsImageVersion = "rootfs-image.version";
var softwareTitleMap = { [rootfsImageVersion]: { title: "Root filesystem", priority: 0, key: rootfsImageVersion } };

// src/usersSlice/constants.ts
var itemUiPermissionsReducer = (accu, { item, uiPermissions }) => item ? { ...accu, [item]: uiPermissions } : accu;
var checkSinglePermission = (permission, requiredPermission) => requiredPermission === permission || import_constants6.uiPermissionsById[permission].permissionLevel > import_constants6.uiPermissionsById[requiredPermission].permissionLevel;
var checkPermissionsObject = (permissions, requiredPermission, scopedAccess, superAccess) => permissions[superAccess]?.some((permission) => checkSinglePermission(permission, requiredPermission)) || permissions[scopedAccess]?.some((permission) => checkSinglePermission(permission, requiredPermission));
var USER_LOGOUT = "USER_LOGOUT";
var OWN_USER_ID = "me";
var settingsKeys = { initialized: "settings-initialized" };
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ADDONS,
  ALL_DEVICES,
  ALL_DEVICE_STATES,
  ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE,
  ARTIFACT_GENERATION_TYPE,
  ATTRIBUTE_SCOPES,
  AUDIT_LOGS_TYPES,
  BEGINNING_OF_TIME,
  BENEFITS,
  DARK_MODE,
  DEFAULT_PENDING_INPROGRESS_COUNT,
  DEPLOYMENT_ROUTES,
  DEPLOYMENT_STATES,
  DEPLOYMENT_TYPES,
  DEVICE_CONNECT_STATES,
  DEVICE_DISMISSAL_STATE,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  DEVICE_LIST_MAXIMUM_LENGTH,
  DEVICE_MESSAGE_PROTOCOLS,
  DEVICE_MESSAGE_TYPES,
  DEVICE_ONLINE_CUTOFF,
  DEVICE_STATES,
  EXTERNAL_PROVIDER,
  JSON_METADATA_FORMAT,
  LIGHT_MODE,
  MAX_PAGE_SIZE,
  OWN_USER_ID,
  PLANS,
  PermissionTypes,
  READ_STATES,
  REPORT_CHART_SIZE_LIMIT,
  SORTING_OPTIONS,
  SP_AUDIT_LOGS_TYPES,
  SSO_TYPES,
  TENANT_LIST_DEFAULT,
  TIMEOUTS,
  UNGROUPED_GROUP,
  USER_LOGOUT,
  XML_METADATA_FORMAT,
  alertChannels,
  apiRoot,
  apiUrl,
  auditLogsApiUrl,
  auditlogTypes,
  canAccess,
  chartTypes,
  checkPermissionsObject,
  countries,
  credentialTypes,
  currentArtifact,
  defaultIdAttribute,
  defaultPermissionSets,
  defaultReportType,
  defaultReports,
  defaultStats,
  deploymentDisplayStates,
  deploymentPrototype,
  deploymentStatesToSubstates,
  deploymentStatesToSubstatesWithSkipped,
  deploymentSubstates,
  deploymentsApiUrl,
  deploymentsApiUrlV2,
  deviceAuthV2,
  deviceConfig,
  deviceConnect,
  emptyChartSelection,
  emptyFilter,
  emptyRole,
  emptyUiPermissions,
  emptyWebhook,
  geoAttributes,
  getOidcStartUrl,
  getSamlStartUrl,
  headerNames,
  installationSubstatesMap,
  inventoryApiUrl,
  inventoryApiUrlV2,
  iotManagerBaseURL,
  itemUiPermissionsReducer,
  limitDefault,
  listDefaultsByState,
  locations,
  maxSessionAge,
  monitorApiUrlv1,
  onboardingSteps,
  orderedOnboardingSteps,
  pauseMap,
  reportingApiUrl,
  rolesById,
  rolesByName,
  rootfsImageVersion,
  scopedPermissionAreas,
  serviceProviderRolesById,
  settingsKeys,
  softwareIndicator,
  softwareTitleMap,
  ssoIdpApiUrlv1,
  tenantadmApiUrlv1,
  tenantadmApiUrlv2,
  timeUnits,
  twoFAStates,
  uiPermissionsByArea,
  uiPermissionsById,
  useradmApiUrl,
  useradmApiUrlv1,
  useradmApiUrlv2,
  yes
});
//# sourceMappingURL=constants.cjs.map