import * as reselect from 'reselect';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { Release as Release$1 } from '@northern.tech/types/MenderTypes';
import { ReadState } from '../usersSlice/constants.cjs';
import { User, UserSession, CustomColumn, GlobalSettings, UserSettings } from '../usersSlice/index.cjs';
import { OrganizationState } from '../organizationSlice/types.cjs';
import { OnboardingApproach } from '../onboardingSlice/index.cjs';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { Deployment, DeploymentByStatus, DeploymentConfig, SelectionState } from '../deploymentsSlice/index.cjs';
import { DeviceSliceType } from '../devicesSlice/index.cjs';
import { SearchState, SentryConfig, SnackbarContent, Upload } from '../appSlice/index.cjs';
import { Release, ReleasesList, ReleaseSliceType } from './index.cjs';
import { RootState } from '../store.cjs';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '../commonConstants.cjs';
import 'react/jsx-runtime';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import '@mui/material';
import '../organizationSlice/constants.cjs';
import '../devicesSlice/constants.cjs';
import 'redux-thunk';

declare const getReleasesById: (state: RootState) => Record<string, Release>;
declare const getReleaseTags: (state: RootState) => string[];
declare const getReleaseListState: (state: RootState) => ReleasesList;
declare const getUpdateTypes: (state: RootState) => string[];
declare const getReleasesList: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => Release$1[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Release>, resultFuncArgs_1: string[], resultFuncArgs_2: {}) => Release$1[];
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Release>, resultFuncArgs_1: string[], resultFuncArgs_2: {}) => Release$1[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => Release$1[];
    dependencies: [(state: RootState) => Record<string, Release>, (state: RootState) => string[], () => {}];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getReleaseTagsById: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: string[]) => {};
    memoizedResultFunc: ((resultFuncArgs_0: string[]) => {}) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {};
    dependencies: [(state: RootState) => string[]];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getHasReleases: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => boolean) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: ReleasesList, resultFuncArgs_1: Record<string, Release>) => boolean;
    memoizedResultFunc: ((resultFuncArgs_0: ReleasesList, resultFuncArgs_1: Record<string, Release>) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => boolean;
    dependencies: [(state: RootState) => ReleasesList, (state: RootState) => Record<string, Release>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getSelectedRelease: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => Release) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Release>, resultFuncArgs_1: string | null) => Release;
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Release>, resultFuncArgs_1: string | null) => Release) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => Release;
    dependencies: [(state: RootState) => Record<string, Release>, (state: RootState) => string | null];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getSelectedReleases: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => Release$1[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: ReleasesList, resultFuncArgs_1: Release$1[]) => Release$1[];
    memoizedResultFunc: ((resultFuncArgs_0: ReleasesList, resultFuncArgs_1: Release$1[]) => Release$1[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => Release$1[];
    dependencies: [(state: RootState) => ReleasesList, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => Release$1[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Record<string, Release>, resultFuncArgs_1: string[], resultFuncArgs_2: {}) => Release$1[];
        memoizedResultFunc: ((resultFuncArgs_0: Record<string, Release>, resultFuncArgs_1: string[], resultFuncArgs_2: {}) => Release$1[]) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => Release$1[];
        dependencies: [(state: RootState) => Record<string, Release>, (state: RootState) => string[], () => {}];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};

export { getHasReleases, getReleaseListState, getReleaseTags, getReleaseTagsById, getReleasesById, getReleasesList, getSelectedRelease, getSelectedReleases, getUpdateTypes };
