"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/usersSlice/constants.ts
var constants_exports = {};
__export(constants_exports, {
  OWN_USER_ID: () => OWN_USER_ID,
  READ_STATES: () => READ_STATES,
  USER_LOGOUT: () => USER_LOGOUT,
  checkPermissionsObject: () => checkPermissionsObject,
  itemUiPermissionsReducer: () => itemUiPermissionsReducer,
  settingsKeys: () => settingsKeys
});
module.exports = __toCommonJS(constants_exports);

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/usersSlice/constants.ts
var itemUiPermissionsReducer = (accu, { item, uiPermissions }) => item ? { ...accu, [item]: uiPermissions } : accu;
var checkSinglePermission = (permission, requiredPermission) => requiredPermission === permission || import_constants.uiPermissionsById[permission].permissionLevel > import_constants.uiPermissionsById[requiredPermission].permissionLevel;
var checkPermissionsObject = (permissions, requiredPermission, scopedAccess, superAccess) => permissions[superAccess]?.some((permission) => checkSinglePermission(permission, requiredPermission)) || permissions[scopedAccess]?.some((permission) => checkSinglePermission(permission, requiredPermission));
var USER_LOGOUT = "USER_LOGOUT";
var OWN_USER_ID = "me";
var settingsKeys = { initialized: "settings-initialized" };
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  OWN_USER_ID,
  READ_STATES,
  USER_LOGOUT,
  checkPermissionsObject,
  itemUiPermissionsReducer,
  settingsKeys
});
//# sourceMappingURL=constants.cjs.map