import { Permission } from './Permission.js';
import './PermissionObject.js';

/**
 * Permission set descriptor.
 */
type PermissionSet = {
    /**
     * A unique name.
     */
    name: string;
    action?: string;
    object?: string;
    /**
     * Description of the permission set.
     */
    description?: string;
    permissions: Array<Permission>;
    supported_scope_types?: Array<string>;
};

export type { PermissionSet };
