"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/constants/api.ts
var api_exports = {};
__export(api_exports, {
  apiRoot: () => apiRoot,
  apiUrl: () => apiUrl,
  auditLogsApiUrl: () => auditLogsApiUrl,
  deploymentsApiUrl: () => deploymentsApiUrl,
  deploymentsApiUrlV1: () => deploymentsApiUrlV1,
  deploymentsApiUrlV2: () => deploymentsApiUrlV2,
  deviceAuthV2: () => deviceAuthV2,
  deviceConfig: () => deviceConfig,
  deviceConnect: () => deviceConnect,
  headerNames: () => headerNames,
  inventoryApiUrl: () => inventoryApiUrl,
  inventoryApiUrlV1: () => inventoryApiUrlV1,
  inventoryApiUrlV2: () => inventoryApiUrlV2,
  iotManagerBaseURL: () => iotManagerBaseURL,
  maxSessionAge: () => maxSessionAge,
  monitorApiUrlv1: () => monitorApiUrlv1,
  reportingApiUrl: () => reportingApiUrl,
  ssoIdpApiUrlv1: () => ssoIdpApiUrlv1,
  tenantadmApiUrlv1: () => tenantadmApiUrlv1,
  tenantadmApiUrlv2: () => tenantadmApiUrlv2,
  useradmApiUrl: () => useradmApiUrl,
  useradmApiUrlv1: () => useradmApiUrlv1,
  useradmApiUrlv2: () => useradmApiUrlv2
});
module.exports = __toCommonJS(api_exports);
var apiRoot = "/api/management";
var apiUrl = {
  v1: `${apiRoot}/v1`,
  v2: `${apiRoot}/v2`
};
var auditLogsApiUrl = `${apiUrl.v1}/auditlogs`;
var deploymentsApiUrl = `${apiUrl.v1}/deployments`;
var deploymentsApiUrlV1 = deploymentsApiUrl;
var deploymentsApiUrlV2 = `${apiUrl.v2}/deployments`;
var deviceAuthV2 = `${apiUrl.v2}/devauth`;
var deviceConfig = `${apiUrl.v1}/deviceconfig/configurations/device`;
var deviceConnect = `${apiUrl.v1}/deviceconnect`;
var inventoryApiUrl = `${apiUrl.v1}/inventory`;
var inventoryApiUrlV1 = inventoryApiUrl;
var inventoryApiUrlV2 = `${apiUrl.v2}/inventory`;
var iotManagerBaseURL = `${apiUrl.v1}/iot-manager`;
var monitorApiUrlv1 = `${apiUrl.v1}/devicemonitor`;
var reportingApiUrl = `${apiUrl.v1}/reporting`;
var ssoIdpApiUrlv1 = `${apiUrl.v1}/useradm/sso/idp/metadata`;
var tenantadmApiUrlv1 = `${apiUrl.v1}/tenantadm`;
var tenantadmApiUrlv2 = `${apiUrl.v2}/tenantadm`;
var useradmApiUrl = `${apiUrl.v1}/useradm`;
var useradmApiUrlv1 = useradmApiUrl;
var useradmApiUrlv2 = `${apiUrl.v2}/useradm`;
var maxSessionAge = 900;
var headerNames = {
  link: "link",
  location: "location",
  total: "x-total-count"
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  apiRoot,
  apiUrl,
  auditLogsApiUrl,
  deploymentsApiUrl,
  deploymentsApiUrlV1,
  deploymentsApiUrlV2,
  deviceAuthV2,
  deviceConfig,
  deviceConnect,
  headerNames,
  inventoryApiUrl,
  inventoryApiUrlV1,
  inventoryApiUrlV2,
  iotManagerBaseURL,
  maxSessionAge,
  monitorApiUrlv1,
  reportingApiUrl,
  ssoIdpApiUrlv1,
  tenantadmApiUrlv1,
  tenantadmApiUrlv2,
  useradmApiUrl,
  useradmApiUrlv1,
  useradmApiUrlv2
});
//# sourceMappingURL=api.cjs.map