import { useCallback } from 'react';
import Notify from 'simple-notify'

type NotifyProps = {
  autoclose?: boolean;
  customWrapper?: string;
  showCloseButton?: boolean;
  effect?: string;
  status?: 'error' | 'info';
  text: string;
  customIcon?: string;
};

export const useNotify = () => {
  const commonProps: Omit<NotifyProps, 'text'> = {
    autoclose: true,
    customWrapper: '<div class="cf-notification"></div>',
    showCloseButton: false,
    effect: 'slide'
  };

  const notify = useCallback((type: 'error' | 'success' | 'info', text: string, props: Partial<NotifyProps> = {}) => {
    const icons: Record<'error' | 'success' | 'info', string> = {
      error: '<i class="bi bi-exclamation-triangle-fill"></i>',
      success: '<i class="bi bi-check-circle-fill"></i>',
      info: '<i class="bi bi-hourglass-split"></i>'
    };

    new Notify({
      text,
      status: type !== 'success' ? type : undefined,
      customIcon: icons[type],
      ...commonProps,
      ...props
    });
  }, []);

  return {
    error: (text: string, props?: Partial<NotifyProps>) => notify('error', text, props),
    success: (text: string, props?: Partial<NotifyProps>) => notify('success', text, props),
    info: (text: string, props?: Partial<NotifyProps>) => notify('info', text, props)
  };
};

export default useNotify;
