let fileChangesSqlService = Class.extend({

    SQL: 'SELECT fc.hostkey, ' +
        '                              fc.filename as "Filename", ' +
        '                              h.hostname as "Host name", ' +
        '                              fc.changetype as "Change type", ' +
        '                              fc.changedetails as "Change details", ' +
        '                              fc.changetimestamp as "Change time" ' +
        '                       FROM filechangeslog AS fc ' +
        '                       LEFT JOIN hosts h ON h.hostkey = fc.hostkey',
    WHERE: '',

    getSql: function (types = null, dates = null, fileName = null) {

        this.WHERE = '';
        this.processDate(dates);
        this.processTypes(types);
        this.processFileName(fileName);
        return this.SQL + ' ' + this.WHERE;
    },

    processDate: function (date = null) {
        if (date != undefined || data != null) {
            let where = ' changetimestamp BETWEEN \'' + common.time.format(date.startDate, 'Y-m-d 00:00:00', false) + '\' AND \'' +  common.time.format(date.endDate, 'Y-m-d 23:59:59', false) + '\''
            this.addWhere(where);
        }
    },

    processTypes: function (types = null) {
        let where = [];

        // if all types selected or deselected then do not filter
        if (new Set(Object.values(types)).size == 1) {
            return;
        }

        Object.keys(types).forEach(function (key) {
            let value = types[key];
            if (value == true) {
                switch (key) {
                    case 'contentChange':
                        where.push("changetype = 'C'")
                        break;
                    case 'diff':
                        where.push("changetype = 'DIFF'")
                        break;
                    case 'fileRemoved':
                        where.push("changetype = 'R'")
                        break;
                    case 'fileAdded':
                        where.push("changetype = 'N'")
                        break;
                    case 'fileStats':
                        where.push("changetype = 'S'")
                        break;
                }
            }
        })

        if (where.length > 0) {
            this.addWhere('(' + where.join(' OR ') + ')');
        }
    },

    processFileName: function (fileName = null) {
        if (fileName != null) {
            let lastFileNameCharacter = fileName.substr(-1);
            // check if directory
            if (lastFileNameCharacter == '/' || lastFileNameCharacter == '\\') {
                fileName = fileName + '%';
            }
            this.addWhere(" filename LIKE '" + fileName.replace(/\\/g, '\\\\') + "'")
        }
    },

    addWhere: function (where) {
        if (this.WHERE == '') {
            this.WHERE = ' WHERE ' + where;
        } else {
            this.WHERE += ' AND ' + where;
        }
    }
});

(function () {

    var fileChangesSqlServiceProvider = Class.extend({
        instance: new fileChangesSqlService(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('fileChangesSqlService', [])
        .provider('fileChangesSqlService', fileChangesSqlServiceProvider);
}());
