'use strict';

dashboardApp.directive('changesWidget', ['changesWidgetHelper', '$q', function (changesWidgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/changes_widget',
        restrict: 'A',
        scope: {
            widget: '=',
            currentUser: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',

        },
        link: function (scope, element) {
            scope.$watch(function () {
                    return element.attr('refresh');
                },
                function () {
                    scope.chartList = changesWidgetHelper.getChartConfig();

                    changesWidgetHelper.getChangeStats({"changeDaysNumber": 6}).then(
                        function (result) {
                            changesWidgetHelper.setChartData(result);
                            scope.widget.changeStats = result;
                            scope.chartList = changesWidgetHelper.getChartConfig();
                        }
                    );
                });


        }
    };

}]);

dashboardApp.directive('alertWidget', ['widgetHelper', function (widgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/alert_widget',
        restrict: 'A',
        name: 'ctrl',
        scope: {
            widget: '=',
            currentUser: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',
            getPriorityNumbers: "&"
        },
        link: function (scope, element) {

            scope.$watch(function () {
                return element.attr('refresh');
            }, function () {
                scope.widgetsLoaded = false;
                widgetHelper.getAlertStatsBySeverity(scope.widget.alerts).then(
                    function (result) {
                        scope.widget.severityStat = result;
                        scope.widgetsLoaded = true;
                    });
            });


        }
    };

}]);

dashboardApp.directive('singleAlertWidget', ['widgetHelper', function (widgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/single_alert_widget',
        restrict: 'A',
        name: 'ctrl',
        scope: {
            widget: '=',
            currentUser: '=',
            currentDash: '=',
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',
            getPriorityNumbers: '&'
        },
        link: function (scope, element) {

            const colors = function () {
                return {
                    high: {
                        title: `<i style="color: ${isDarkModeEnabled() ? '#E79D99' : '#D74936'};font-size: 24px" class="bi bi-exclamation-triangle-fill"></i><br />High`,
                        colors: {
                            pie: isDarkModeEnabled() ? '#E79D99' : '#D74936',
                            title: isDarkModeEnabled() ? '#E79D99' : '#D74936'
                        }
                    },
                    medium: {
                        title: `<i style="color: ${isDarkModeEnabled() ? '#F9B479' : '#F5821F'};font-size: 24px" class="bi bi-exclamation-triangle-fill"></i><br />Medium`,
                        colors: {
                            pie: isDarkModeEnabled() ? '#F9B479' : '#F5821F',
                            title: isDarkModeEnabled() ? '#D1D2D3' : '#4F5665'
                        }
                    },
                    low: {
                        title: `<i style="color: ${isDarkModeEnabled() ? '#FEF59F' : '#FEDB3E'};font-size: 24px" class="bi bi-exclamation-triangle-fill"></i><br />Low`,
                        colors: {
                            pie: isDarkModeEnabled() ? '#FEF59F' : '#FEDB3E',
                            title: isDarkModeEnabled() ? '#D1D2D3' : '#4F5665'
                        }
                    },
                    ok: {
                        title: `<i style="color: ${isDarkModeEnabled() ? '#95D0A7' : '#45B26B'};font-size: 24px" class="bi bi-check-circle-fill"></i>`,
                        colors: {
                            pie: isDarkModeEnabled() ? '#95D0A7' : '#45B26B',
                            title: isDarkModeEnabled() ? '#D1D2D3' : '#4F5665'
                        }
                    },
                    labels: isDarkModeEnabled() ? '#D1D2D3' : '#0B132A',
                    seriesNeutral: isDarkModeEnabled() ? '#383E42' : '#F7F7F7'
                }
            }

            const getPieSeries = (stats) => {
                let series = [];
                if (stats.failAlerts == 0) {
                    series = [['', 0], ['', 100]];
                } else if (stats.failHosts == stats.totalHosts) {
                    series = [['', 100], ['', 0]];
                } else {
                    let failedPercentage = Math.round(stats.failHosts / stats.totalHosts * 100);
                    failedPercentage = (failedPercentage == 100) ? 99 : ((failedPercentage == 0) ? 1 : failedPercentage);
                    const passedPercentage = 100 - failedPercentage;
                    series = [[`${failedPercentage}%`, failedPercentage], [`${passedPercentage}%`, passedPercentage]];
                }
                return series;
            }

            const getHighChartsConfig = () => {
                return {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: 0,
                        plotShadow: false,
                        backgroundColor: 'transparent'
                    },
                    exporting: {enabled: false},
                    title: {
                        text: colors()[scope.severity].title,
                        useHTML: true,
                        align: 'center',
                        verticalAlign: 'middle',
                        style: {
                            fontSize: '13px',
                            lineHeight: '16px',
                            fontWeight: 'normal',
                            fontFamily: 'Red Hat Text',
                            textAlign: 'center',
                            color: colors()[scope.severity].colors.title
                        }
                    },
                    tooltip: {
                        enabled: false
                    },
                    plotOptions: {
                        pie: {
                            dataLabels: {
                                enabled: true,
                                distance: 0,
                                connectorColor: 'transparent',
                                color: colors().labels,
                                style: {
                                    fontSize: '15px',
                                    fontWeight: 'bold',
                                    fontFamily: 'Red Hat Text',
                                    textOverflow: 'none'
                                }
                            },
                            size: 120
                        }
                    },
                    series: [{
                        type: 'pie',
                        borderWidth: 0,
                        colors: [colors()[scope.severity].colors.pie, colors().seriesNeutral],
                        innerSize: '77%',
                        data: getPieSeries(scope.stats)
                    }],
                    credits: {
                        enabled: false
                    },
                }
            }

            scope.$watch(function () {
                return element.attr('refresh');
            }, function () {
                scope.widgetsLoaded = false;
                widgetHelper.getAlertStatsBySeverity(scope.widget.alerts).then(
                    function (result) {
                        scope.widget.severityStat = result;
                        scope.widgetsLoaded = true;

                        Object.keys(scope.widget.severityStat).forEach((severity) => {
                            if (scope.widget.severityStat[severity].totalAlerts > 0) {
                                scope.stats = scope.widget.severityStat[severity];
                                scope.severity = scope.stats.failAlerts === 0 ? 'ok' : severity;
                                scope.chartConfig = getHighChartsConfig();
                            }
                        })
                    });
            });
        }
    };
}]);
