class SolidGaugeWidget extends BaseInventoryWidget {
    constructor(payload, data)
    {
        super(payload, data);
        this.config = {
            chart: {
                type: 'solidgauge',
                backgroundColor: 'transparent',
                events: {
                    click: this.clickAction.bind(this)
                },
            },

            title: null,

            pane: {
                center: ['50%', '85%'],
                size: '140%',
                startAngle: -90,
                endAngle: 90,
                background: {
                    innerRadius: '60%',
                    outerRadius: '100%',
                    shape: 'arc'
                }
            },

            exporting: {
                enabled: false
            },

            tooltip: {
                enabled: false
            },

            // the value axis
            yAxis: {
                title: {
                    y: -80,
                    text: '22' + ' avg.'
                },
                labels: {
                    style: {
                        color: '#fff'
                    }
                }
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                solidgauge: {
                    dataLabels: {
                        y: 5,
                        borderWidth: 0,
                        useHTML: true
                    }
                }
            }
        };
    }

    getConfig() {
        return Highcharts.merge(this.config, {
            yAxis: {
                min: this.payload.min,
                max: this.payload.max,
                stops: this.getStops(this.payload.startColor),
                title: {
                    text: this.variable + ' avg.'
                }
            },
            series: [{
                data: [this.data.data[0]],
                dataLabels: {
                    format:
                        '<div style="text-align:center">' +
                        '<span style="font-size:25px">{y}</span><br/>' +
                        '</div>'
                }
            }]
        });
    }

    getStops(startColor) {
        return startColor == 'green' ?
            [
                [0.1, '#55BF3B'], // green
                [0.5, '#DDDF0D'], // yellow
                [0.9, '#DF5353'] // red
            ] :
            [
                [0.1, '#DF5353'], // red
                [0.5, '#DDDF0D'], // yellow
                [0.9, '#55BF3B'] // green
            ];
    }
}
