$(document).ready(function () {
    const form =  $("#change_password");
    // global variables for ajax and drag&drop
    const options = {
        target: '#msg',  // target element(s) to be updated with server response
        dataType: 'json',
        success: function (responseObj, statusText, xhr, $form) {
            $("#formInfoMessage").find('.alert').remove();

            if (responseObj.responseText != undefined && responseObj.responseText.type != undefined) {
                $("#formInfoMessage").append('<div class="alert ' + responseObj.responseText.type + '"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>' + responseObj.responseText.content + '</div>');
                $("#formInfoMessage").fadeIn(100);
            }

            if (responseObj.message != undefined) {
                var success = false;
                $.each(responseObj.message, function (type, content) {
                    $("#formInfoMessage").append('<div class="alert ' + type + '"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>' + content + '</div>')
                    $("#formInfoMessage").fadeIn(100);
                });
            }

            if (responseObj.status == 'all_ok') {
                $('#default-warning').fadeOut(500);
                $('#default-logging').fadeIn(500);
                window.setTimeout(function () {
                    if (typeof $('.bootbox').modal === 'function')  {
                        $('.bootbox').modal('hide');
                    }
                    if (!!!form.attr('noredirect')) {
                         window.location.href = "/";
                    }
                }, 1600);
            }

            if (responseObj.status === 'password-reset-completed') {
                $('#password-reset-completed').fadeIn(200);
                $('#save').prop('disabled', true);
                window.setTimeout(function () {
                    window.location.href = "/";
                }, 3000);
            }

            if (responseObj.status != undefined && responseObj.status == 'all_ok') {
                $('#msg').html(responseObj.responseText);
            }
            return;
        }
    };

    $(document).ready(function () {
        let suggestion = '';
        $.validator.addMethod('complexPassword', val => {
            const {feedback: {suggestions = {}}, score = 0} = zxcvbn(val);
            [suggestion] = suggestions;
            return score >= passwordComplexity;
        }, () => `Password too weak.&nbsp;${suggestion}`);

        form.validate({
            rules: {
                old: {
                    required: true,
                },
                new: {
                    required: true,
                    minlength: minPasswordLength,
                    complexPassword: true
                },
                new_confirm: {
                    required: true,
                    equalTo: "#new",
                }
            },
            messages: {
                old: {
                    required: "Please enter old password"
                },
                new: {
                    required: "Please enter new password",
                    minlength: `Password must be at least ${minPasswordLength}&nbsp;characters long`,
                },
                new_confirm: {
                    required: "Please confirm your new password",
                    equalTo: "Passwords do not match",
                },
            },
            errorPlacement: function (error, [element]) {
                error.insertAfter(element.parentNode.querySelector('.show-password-button'));
                error.attr('title', error.text());
            },
            highlight: function(element, error, eee, fff) {
                const errorContainer = element.parentNode.querySelector('label.error');
                if (errorContainer) {
                    errorContainer.title = errorContainer.innerText;
                }
            },
            submitHandler: function (form) {
                if (typeof twoFa !== "undefined") {
                    twoFa.asyncCheck2FaVerificationValid(true).then(() => $(form).ajaxSubmit(options), () => {});
                } else {
                    $(form).ajaxSubmit(options);
                }
            }
        });
    });
});
