'use strict';

var actionServiceClass = Class.extend({
    ACTIONS_URL: MP_SITE_URL + '/actions',

    agentRun: function (hostkey) {
        return this.$http({
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            },
            url: this.ACTIONS_URL + '/agent_run',
            data: $.param({hostkey})
        });
    },

    reportCollection: function (hostkey) {
        return this.$http({
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            },
            url: this.ACTIONS_URL + '/report_collection',
            data: $.param({hostkey})
        });
    },

    getHubKey: function () {
        const url = this.ACTIONS_URL + '/hub_key';
        return this.$http.get(url);
    },
});

(function () {
    var actionServiceProvider = Class.extend({
        instance: new actionServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('actionServiceModule', [])
        .provider('actionService', actionServiceProvider);
}());
