<div>
    <form class="include-exclude-form">
        <div>
            <a ng-if="includedEntriesCount > 0" href="#" class="btn btn-link btn-transparent" role="button" ng-click="showHost(true)">
                {{ pluralize('host', includedHostsCount, true) }} included, {{ includedEntriesCount }} inclusion {{ pluralize('entry', includedEntriesCount) }}
                <i    rel="tooltip"
                      ng-if="intersectionsInclExcl()"
                      data-original-title="Some hosts are both included and excluded. Exclusion will take precedence."
                      data-placement="right"
                      class="bi bi-exclamation-triangle-fill">
                </i>
                <br />
                ({{ entriesList(includedHosts) }})
            </a>
            <a ng-if="includedEntriesCount === 0"
               href="#" class="btn btn-link btn-transparent" role="button" ng-click="showHost(true)">
                Include {{ otherFiltersApplied ? 'additional' : '' }} hosts
            </a>
        </div>
        <div>
            <a  ng-if="excludedEntriesCount > 0"
                href="#" class="btn btn-link btn-transparent" role="button" ng-click="showHost(false)">
                {{ pluralize('host', excludedHostsCount, true) }} excluded, {{ excludedEntriesCount }} exclusion {{ pluralize('entry', excludedEntriesCount) }}
                <br />
                ({{ entriesList(excludedHosts) }})
            </a>
            <a ng-if="excludedEntriesCount === 0" href="#" class="btn btn-link btn-transparent" role="button" ng-click="showHost(false)">
               Exclude hosts
            </a>
        </div>
    </form>
</div>

<script type="text/ng-template" id="hostSelectionByNameModal.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="hostSearch =''; close()">
            <i class="bi bi-x"></i>
        </button>
        <h2 ng-if="modalData.include">Include {{ otherFiltersApplied ? 'additional' : '' }} hosts</h2>
        <h2 ng-if="!modalData.include">Exclude hosts</h2>
    </div>
    <div class="row modal-body no-padding include-additional-modal">
        <div class="subtitle" ng-if="modalData.include">
            Including hosts will cause them to be added to the filter results, even if they don't match the rules of the
            filter.
        </div>
        <div class="subtitle" ng-if="!modalData.include">
            Excluding hosts will remove them from the filter results.
        </div>
        <div class="main">
            <div class="inclExcl">
                <div>

                <span class="searchBlock">
                        <input style="width: 290px" ng-model="modalData.searchString" name="modalData.searchString"
                               type="text" placeholder="Search for hostname, ID, IP, MAC">
                </span>


                    <div ng-if="modalData.queryIsIpMask || modalData.queryIsIp" class="addIpMask">
                        <a href="javascript:void(0)" ng-click="addEntry(modalData.queryIsIpMask ? 'ip_mask' : 'ip', modalData.searchString)">Add IP
                            {{ modalData.searchString }}
                        </a>
                        <i
                                rel="tooltip" class="bi bi-info-circle-fill margin-left-8" data-title="Status"
                                data=""
                                data-placement="right"
                                title=""
                                data-original-title="The list will change dynamically if hosts appear with a matching IP address">

                        </i>
                    </div>

                    <div ng-if="modalData.queryIsHostname" class="addIpMask">
                        <a href="javascript:void(0)" ng-click="addEntry('hostname', modalData.searchString)">Add hostname
                            "{{ modalData.searchString }}"
                        </a>
                        <i
                                rel="tooltip" class="bi bi-info-circle-fill margin-left-8" data-title="Status"
                                data=""
                                data-placement="right"
                                title=""
                                data-original-title="The list will change dynamically if hosts appear with a matching hostname">

                        </i>
                    </div>
                    <div class="noHostsFound" ng-show="showHosts && totalHostList.length == 0">
                        <p>No hosts found.</p>
                    </div>
                    <div class="host-list" ng-show="totalHostList.length > 0">
                        <ul class="unstyled">
                            <li ng-repeat="host in totalHostList" ng-class="{'collapsed': modalData.collapsedHost === host.hostkey}">
                                <div class="checkbox" ng-click="setCollapsedHost($event,  modalData.collapsedHost === host.hostkey ? null : host.hostkey)"  >
                                    <div title="{{host.hostname}}" class="host-list_name">{{host.hostname}} <span ng-if="host.searchTooltip">({{host.searchTooltip.attr}}: <span ng-class="{highlight: host.searchTooltip.highlight}">{{ host.searchTooltip.value }}</span>)</span></div>
                                    <div ng-if="!includedHosts[host.hostkey]" style="float: right;">
                                        <span ng-hide="modalData.collapsedHost === host.hostkey" class="btn-select dnc"><i class="bi bi-chevron-down"></i></span>
                                        <span ng-show="modalData.collapsedHost === host.hostkey" class="btn-select dnc"><i class="bi bi-chevron-up"></i></span>
                                    </div>
                                </div>
                                <div class="collapsed-data" ng-show="modalData.collapsedHost === host.hostkey">
                                    <div ng-class="{disabled: isEntryAdded('hostkey', host.hostkey)}">
                                        <div>ID: <span title="{{ host.hostkey }}">{{ host.hostkey }}</span></div>
                                        <button ng-disabled="isEntryAdded('hostkey', host.hostkey)" ng-click="addEntry('hostkey', host.hostkey)" class="btn btn-link">Add <i class="bi bi-arrow-right"></i></button>
                                    </div>
                                    <div ng-class="{disabled: isEntryAdded('ip', ip)}" ng-repeat="ip in host.ip.split(', ') track by $index">
                                        <div>IP: {{ ip }}</div>
                                        <button ng-disabled="isEntryAdded('ip', ip)" ng-click="addEntry('ip', ip)" class="btn btn-link">Add <i class="bi bi-arrow-right"></i></button>
                                    </div>
                                    <div ng-class="{disabled: isEntryAdded('hostname', host.hostname)}">
                                        <div>Name: {{ host.hostname }}</div>
                                        <button ng-disabled="isEntryAdded('hostname', host.hostname)" ng-click="addEntry('hostname', host.hostname)" class="btn btn-link">Add <i class="bi bi-arrow-right"></i></button>
                                    </div>
                                    <div ng-class="{disabled: isEntryAdded('mac', mac)}" ng-repeat="mac in host.mac.split(', ') track by $index">
                                        <div>MAC: {{ mac }}</div>
                                        <button ng-disabled="isEntryAdded('mac', mac)" ng-click="addEntry('mac', mac)" class="btn btn-link">Add <i class="bi bi-arrow-right"></i></button>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <!--- PAGINATION  START -->
                    <div class="float-left paginator_SE">
                        <div class="pull-right pagination"
                             ng-show="paginator.resultCount > paginator.defaultRowsPerPage">
                            <ul class="pull-left">
                                <li ng-if="paginator.page != 1 && paginator.pages > 5">
                                    <a title="Go to First Page" ng-click="paginator.reloadView(1)"
                                       href="javascript:void(0)">First</a>
                                </li>
                                <li ng-if="paginator.page != 1">
                                    <a title="Go to Previous Page"
                                       ng-click="paginator.reloadView(paginator.page -1 || 1)"
                                       href="javascript:void(0)">&laquo;</a>
                                </li>


                                <li ng-repeat="item in paginator.resultPagesList"
                                    ng-class="{active: item == paginator.page}">
                                    <span ng-if="item == paginator.page">{{item}}</span>
                                    <a ng-if="item != paginator.page" title="Go to Page {{item}}"
                                       ng-click="paginator.reloadView(item)" href="javascript:void(0)">{{item}}</a>
                                </li>


                                <li ng-if="paginator.page != paginator.pages ">
                                    <a title="Go to Next Page"
                                       ng-click="paginator.reloadView(paginator.page+1 || paginator.pages)"
                                       href="javascript:void(0)">&raquo;</a>
                                </li>
                                <li ng-if="paginator.page != paginator.pages && paginator.pages > 5">
                                    <a title="Go to Last Page" ng-click="paginator.reloadView(paginator.pages)"
                                       href="javascript:void(0)">Last</a>
                                </li>
                            </ul>

                        </div>
                    </div>
                    <!--- PAGINATION END -->
                </div>
            </div>
            <div>
                <div>
                    <div class="right-summary">
                         <span class="clear-all flex-grow">{{ pluralize('entry', entriesCount(), true) }} , {{ pluralize('host', hostsCount, true) }} in total <i
                                     rel="tooltip" class="bi bi-info-circle-fill" data-title="Status" data=""
                                     data-placement="bottom"
                                     title=""
                                     data-original-title="Usually, the number of entries matches the number of hosts. If not, it could for example be due to multiple hosts having the given IP address, or if no hosts are currently reporting a specified hostname."></i></span>
                        <button class="btn btn-link clear-all" ng-click="clearAll()"><i class="bi bi-trash"></i> Clear all
                        </button>
                    </div>
                    <div class="entries_tabs">
                        <a href="javascript:void(0)" ng-class="{active: modalData.selectedType == 'hostkey'}" ng-click="modalData.selectedType='hostkey'">ID({{ entries.hostkey.length || 0 }})</a>
                        <a href="javascript:void(0)" ng-class="{active: modalData.selectedType == 'ip'}" ng-click="modalData.selectedType='ip'">IP({{ entries.ip.length + entries.ip_mask.length || 0 }})</a>
                        <a href="javascript:void(0)" ng-class="{active: modalData.selectedType == 'hostname'}" ng-click="modalData.selectedType='hostname'">Hostname({{ entries.hostname.length || 0 }})</a>
                        <a href="javascript:void(0)" ng-class="{active: modalData.selectedType == 'mac'}" ng-click="modalData.selectedType='mac'">MAC({{ entries.mac.length || 0 }})</a>
                    </div>
                    <div ng-switch on="modalData.selectedType">
                        <div ng-switch-when="hostkey">
                            <ul class="include-exclude-form-entities">
                                <li ng-repeat="hostkey in entries.hostkey" ng-class="{recentlyAdded: $first && modalData.lastIncludedEntryType == 'hostkey'}">
                                    <span class="flex">
                                        {{ entriesData.hostkey[hostkey].hostname }}
                                        (<span class="ellipsis display-inline-block" style="max-width: 150px;">{{ hostkey }}</span>)&nbsp;
                                    </span>
                                    <a href="javascript:void(0)" class="removeEntry" ng-click="removeEntry('hostkey', hostkey)">Remove</a>
                                </li>
                            </ul>
                        </div>
                        <div ng-switch-when="ip">
                            <ul class="include-exclude-form-entities">
                                <li ng-repeat="subnet in entries.ip_mask" ng-class="{recentlyAdded: $first && modalData.lastIncludedEntryType == 'ip_mask'}">
                                    <span rel="tooltip" data-title="{{ ipMaskDescription(entriesData.ip_mask[subnet], subnet) }}" data-placement='bottom'>{{ subnet }} ({{ entriesData.ip_mask[subnet].length || 0 }} hosts)</span>
                                    <a href="javascript:void(0)" class="removeEntry" ng-click="removeEntry('ip_mask', subnet)">Remove</a>
                                </li>
                                <li ng-repeat="ip in entries.ip" ng-class="{recentlyAdded: $first && modalData.lastIncludedEntryType == 'ip'}">
                                    <span>{{ ip }} ({{ entriesData.ip[ip].hostname || 'no hostname'}})</span>
                                    <a href="javascript:void(0)" class="removeEntry" ng-click="removeEntry('ip', ip)">Remove</a>
                                </li>
                            </ul>
                        </div>
                        <div ng-switch-when="hostname">
                            <ul class="include-exclude-form-entities">
                                <li ng-repeat="hostname in entries.hostname" ng-class="{recentlyAdded: $first && modalData.lastIncludedEntryType == 'hostname'}">
                                    <span>
                                        {{ hostname }}
                                    </span>
                                    <a href="javascript:void(0)" ng-click="removeEntry('hostname', hostname, $event)" class="removeEntry">Remove</a>
                                </li>
                            </ul>
                        </div>
                        <div ng-switch-when="mac">
                            <ul class="include-exclude-form-entities">
                                <li ng-repeat="mac in entries.mac" ng-class="{recentlyAdded: $first && modalData.lastIncludedEntryType == 'mac'}">
                                    <span>
                                        {{ mac }} ({{ entriesData.mac[mac].hostname}})
                                    </span>
                                    <a href="javascript:void(0)" class="removeEntry" ng-click="removeEntry('mac', mac)">Remove</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="modal-footer">
        <button class="btn btn-large btn-primary" ng-click="save()">Confirm</button>
    </div>
</script>
