<?php

/**
 * Class LastAgentRunUnsuccessfulSqlBuilder
 */
class LastAgentRunUnsuccessfulSqlBuilder extends BaseHealthDiagnosticSqlBuilder
{
    public const AGENT_STATUS_FAIL = 'FAIL';

    /**
     * @var string
     */
    protected $sql = 'SELECT HostKey 
                      FROM agentstatus WHERE agentstatus.lastagentexecutionstatus = \'%s\'
                      AND hostkey NOT IN (SELECT hostkey FROM health_diagnostics_dismissed WHERE username = \'%s\' AND report_type = \'%s\' )';

    /**
     * @var string
     */
    protected $nonOverlappedSql;

    /**
     * @var string
     */
    protected $reportSql = 'SELECT h.Hostkey as key,h.hostname as "Host name", lastreporttimestamp as "Last report collected"  
                            FROM hosts h';


    /**
     * @return string
     */
    public function getSql(): string
    {
        //Add fail status to query
        $this->sql = sprintf($this->sql, self::AGENT_STATUS_FAIL, $this->userName, BaseHealthDiagnostic::LAST_AGENT_RUN_UNSUCCESSFUL_TYPE);

        return $this->sql;
    }

    /**
     * Extend report sql by adding where in (report sql).
     * It needs to include in report only needed hosts.
     *
     * @return string
     */
    public function getReportSql(): string
    {
        $this->reportSql = sprintf($this->reportSql . ' WHERE HostKey IN (%s)', $this->getNonOverlappedSql());

        return $this->reportSql;
    }

}
