<?php

class Graph extends CF_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('vitals_model');
    }

    /**
     * replace special characters for javascript support such as ':'
     * @param type $obs
     */
    function canonifyObservables($obs)
    {
        $replaceArray = array('!', '"', '#', '$', '%', '&', '(', ')', '*', '+', ',', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}', '~');

        return str_replace($replaceArray, '', $obs);
    }

    function magnifiedView($parameter)
    {

        $getparams = $this->uri->uri_to_assoc(3);

        $observables = $getparams['obs'];
        $hostKey = $getparams['host'];
        $units = $getparams['units'];
        $username = $this->session->userdata('username');
        $graphData = $this->vitals_model->getVitalsMagnifiedViewJson($username, $hostKey, $observables);
        $manipulatedSeriesData = json_decode($graphData, true);
        if ($graphData !== null && $manipulatedSeriesData !== false && !empty($manipulatedSeriesData))
        {

            $this->data['graphLastUpdated'] = $this->vitals_model->getVitalsLastUpdate($username, $hostKey);
            //$this->data['graphDetails'] = $this->vitals_model->getVitalsMagnifiedAnalysis($username, $hostKey, $observables);
            $this->data['graphDetails'] = array();
            $this->data['graphdata'] = ($graphData);
            $this->data['observable'] = $this->canonifyObservables($observables);
            $this->data['units'] = $units;


            $lineSeries1 = array();
            $lineSeries2 = array();
            $tempMaxValue = array();
            $tempMinValue = array();
            $tempMeasured = array();

            foreach ($manipulatedSeriesData as $points => $values)
            {
                $lineSeries1[] = array($values[0], $values[1]);
                $lineSeries2[] = array($values[0], $values[2]);
                $tempMeasured[] = $values[1];
                $tempMaxValue[] = ($values[2] + $values[3]);
                $tempMinValue[] = ($values[2] - $values[3]);
            }

            # we can calculate the min and maximum y value for float as well
            $maxMeasured = max($tempMeasured);
            $minMeasured = min($tempMeasured);
            $maxCombined = max($tempMaxValue);
            $minCombined = min($tempMinValue);
            $max = ($maxMeasured > $maxCombined) ? $maxMeasured : $maxCombined;
            $this->data['graphdatamax'] = ceil($max + 1);

            $min = $minCombined < $minMeasured ? $minCombined : $minMeasured;
            $min = ceil($min - 1);
            $this->data['graphdatamin'] = $min;


            $this->data['graphdatalineseries1'] = json_encode($lineSeries1);
            $this->data['graphdatalineseries2'] = json_encode($lineSeries2);
            $this->load->view('graph/magnifiedView', $this->data);
        }
        else
        {
            respond_ok($this->lang->line('graph_data_not_available'));
        }
    }

    function weekView()
    {

        $getparams = $this->uri->uri_to_assoc(3);

        $observables = $getparams['obs'];
        $hostKey = $getparams['host'];
        $units = $getparams['units'];
        $this->data['units'] = $units;
        $username = $this->session->userdata('username');
        $graphData = $this->vitals_model->getVitalsWeekViewJson($username, $hostKey, $observables);

        $manipulatedSeriesData = json_decode($graphData, true);
        if ($graphData !== null && $manipulatedSeriesData !== false && !empty($manipulatedSeriesData))
        {

            $this->data['graphLastUpdated'] = $this->vitals_model->getVitalsLastUpdate($username, $hostKey);
            //$this->data['graphDetails'] = $this->vitals_model->getVitalsWeekAnalysis($username, $hostKey, $observables);
            $this->data['graphDetails'] = array();
            $this->data['graphdata'] = $graphData;
            $this->data['observable'] = $this->canonifyObservables($observables);
            $lineSeries1 = array();
            $lineSeries2 = array();
            $tempMaxValue = array();
            $tempMinValue = array();
            $tempMeasured = array();

            foreach ($manipulatedSeriesData as $points => $values)
            {
                $lineSeries1[] = array($values[0], $values[1]);
                $lineSeries2[] = array($values[0], $values[2]);
                $tempMeasured[] = $values[1];
                $tempMaxValue[] = ($values[2] + $values[3]);
                $tempMinValue[] = ($values[2] - $values[3]);
            }

            # we can calculate the min and maximum y value for float as well
            $maxMeasured = max($tempMeasured);
            $minMeasured = min($tempMeasured);
            $maxCombined = max($tempMaxValue);
            $minCombined = min($tempMinValue);
            $max = ($maxMeasured > $maxCombined) ? $maxMeasured : $maxCombined;
            $this->data['graphdatamax'] = ceil($max + 1);

            $min = $minCombined < $minMeasured ? $minCombined : $minMeasured;
            $min = ceil($min - 1);
            $this->data['graphdatamin'] = $min;



            $this->data['graphdatalineseries1'] = json_encode($lineSeries1);
            $this->data['graphdatalineseries2'] = json_encode($lineSeries2);

            $this->load->view('graph/weekly', $this->data);
        }
        else
        {
            respond_ok($this->lang->line('graph_data_not_available'));
        }
    }

    function yearView()
    {

        $getparams = $this->uri->uri_to_assoc(3);

        $observables = $getparams['obs'];
        $hostKey = $getparams['host'];
        $units = $getparams['units'];
        $this->data['units'] = $units;

        $username = $this->session->userdata('username');
        $graphData = $this->vitals_model->getVitalsYearViewJson($username, $hostKey, $observables);
        $manipulatedSeriesData = json_decode($graphData, true);
        if ($graphData !== null && $manipulatedSeriesData !== false && !empty($manipulatedSeriesData))
        {

            $this->data['graphLastUpdated'] = $this->vitals_model->getVitalsLastUpdate($username, $hostKey);
            //$this->data['graphDetails'] = $this->vitals_model->getVitalsYearAnalysis($username, $hostKey, $observables);
            $this->data['graphDetails'] = array();
            $this->data['graphdata'] = $graphData;
            $this->data['observable'] = $this->canonifyObservables($observables);
            $lineSeries1 = array();
            $lineSeries2 = array();
            $tempMaxValue = array();
            $tempMinValue = array();

            foreach ($manipulatedSeriesData as $points => $values)
            {
                $lineSeries1[] = array($values[0], $values[1]);
                $lineSeries2[] = array($values[0], $values[2]);
                $tempMaxValue[] = ($values[2] + $values[3]);
                $tempMinValue[] = ($values[2] - $values[3]);
            }

            # we can calculate the min and maximum y value for float as well
            $this->data['graphdatamax'] = ceil(max($tempMaxValue) + 1);
            $min = (min($tempMinValue) != 0) ? min($tempMinValue) - 1 : 0;
            $min = ceil($min);
            $this->data['graphdatamin'] = $min;



            $this->data['graphdatalineseries1'] = json_encode($lineSeries1);
            $this->data['graphdatalineseries2'] = json_encode($lineSeries2);

            $this->load->view('graph/yearview', $this->data);
        }
        else
        {
            respond_ok($this->lang->line('graph_data_not_available'));
        }
    }

    function histogramView()
    {

        $getparams = $this->uri->uri_to_assoc(3);

        $observables = $getparams['obs'];
        $hostKey = $getparams['host'];
        $units = $getparams['units'];
        $this->data['units'] = $units;


        $username = $this->session->userdata('username');
        $graphData = $this->vitals_model->getVitalsHistogramViewJson($username, $hostKey, $observables);
        $manipulatedSeriesData = json_decode($graphData, true);
        if ($graphData !== null && $manipulatedSeriesData !== false && !empty($manipulatedSeriesData))
        {

            //$this->data['graphDetails'] = $this->vitals_model->getVitalsHistogramAnalysis($username, $hostKey, $observables);
            $this->data['graphDetails'] = array();
            $this->data['graphdata'] = $graphData;
            $this->data['observable'] = $this->canonifyObservables($observables);

            $this->load->view('graph/histogram', $this->data);
        }
        else
        {
            respond_ok($this->lang->line('graph_data_not_available'));
        }
    }

}
