import React from 'react';
import { Box } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import AIAgentIcon from './AiAgentIcon';

const useStyles = makeStyles()(theme => ({
  header: {
    display: 'flex',
    alignItems: 'center',
    color: theme.palette.darkBlue[900]
  }
}));

interface AiAgentHeaderProps {
  iconWidth?: string;
  iconHeight?: string;
  fontSize?: number;
}

const AiAgentHeader: React.FC<AiAgentHeaderProps> = ({ 
  iconWidth = "22", 
  iconHeight = "34",
  fontSize = 20
}) => {
  const { classes } = useStyles();

  return (
    <Box className={classes.header} sx={{ fontSize }}>
      <AIAgentIcon width={iconWidth} height={iconHeight} />
      <Box sx={{ ml: 1 }}>AI agent</Box>
    </Box>
  );
};

export default AiAgentHeader;
